<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(8, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(10, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


if(isset($action) AND $action=='modifier'){

	/******************************/
	/**  Traitement des erreurs  **/
	/******************************/
	if(strlen(trim($competition_date_debut))==0){
		$erreur_message .= "- la date de début est manquante<br>";
	}
	if(strlen(trim($competition_heure_debut))==0){
		$erreur_message .= "- l'heure de début est manquante<br>";
	}else{
		if(preg_match('/:/', $competition_heure_debut)==false){
			$erreur_message .= "- l'heure de début est incorrecte<br>";
		}
	}
	if(strlen(trim($competition_sponsor_1))==0){
		$erreur_message .= "- le sponsor du 1er jour est manquant<br>";
	}
	if(strlen(trim($competition_sponsor_2))==0){
		$erreur_message .= "- le sponsor du 2ème jour est manquant<br>";
	}
	if(strlen(trim($competition_sponsor_3))==0){
		$erreur_message .= "- le sponsor du 3ème jour est manquant<br>";
	}
	if(strlen(trim($competition_sponsor_4))==0){
		$erreur_message .= "- le sponsor du 4ème jour est manquant<br>";
	}

	/******************************/
	/**  Traitement des données  **/
	/******************************/
	$competition_sponsor_1 = htmlentities(strtoupper($competition_sponsor_1), ENT_QUOTES);
	$competition_sponsor_2 = htmlentities(strtoupper($competition_sponsor_2), ENT_QUOTES);
	$competition_sponsor_3 = htmlentities(strtoupper($competition_sponsor_3), ENT_QUOTES);
	$competition_sponsor_4 = htmlentities(strtoupper($competition_sponsor_4), ENT_QUOTES);
	if(!isset($competition_active)){ $competition_active = 0; }

	/****************************************/
	/**  Enregistrement des modifications  **/
	/****************************************/
	if($erreur_message==''){

		$tab_date_debut = explode('/', $competition_date_debut);
		$competition_date_debut_jour = $tab_date_debut[0];
		$competition_date_debut_mois = $tab_date_debut[1];
		$competition_date_debut_annee = $tab_date_debut[2];

		$competition_date_fin = date('d/m/Y', mktime(0, 0, 0, $competition_date_debut_mois, $competition_date_debut_jour+($competition_nb_jours-1), $competition_date_debut_annee));

		if(isset($competition_sponsors_classement)){ $competition_sponsors_classement = implode(',', $competition_sponsors_classement); }

		// Requête de mise à jour de la compétition
		$requete_maj = mysqli_query($connexion_mysql, 'UPDATE competitions SET competition_annee="'.$competition_date_debut_annee.'", competition_date_debut=STR_TO_DATE("'.$competition_date_debut.'", "%d/%m/%Y"), competition_date_fin=STR_TO_DATE("'.$competition_date_fin.'", "%d/%m/%Y"), competition_heure_debut=STR_TO_DATE("'.$competition_heure_debut.'", "%H:%i"), competition_sponsor_1="'.$competition_sponsor_1.'", competition_sponsor_2="'.$competition_sponsor_2.'", competition_sponsor_3="'.$competition_sponsor_3.'", competition_sponsor_4="'.$competition_sponsor_4.'", competition_sponsors_classement="'.$competition_sponsors_classement.'", competition_active="'.$competition_active.'" WHERE competition_id="'.$compet_id.'"');

		header('Location: ./');
		exit;

	}else{
		$competition_sponsor_1 = stripslashes($competition_sponsor_1);
		$competition_sponsor_2 = stripslashes($competition_sponsor_2);
		$competition_sponsor_3 = stripslashes($competition_sponsor_3);
		$competition_sponsor_4 = stripslashes($competition_sponsor_4);
		$competition_sponsors_classement = explode(',', $competition_sponsors_classement);
	}

}


if(isset($erreur_message) AND $erreur_message==''){

	// Sélection de la compétition
	$requete_competition = mysqli_query($connexion_mysql, 'SELECT DATE_FORMAT(competition_date_debut, "%d/%m/%Y"), TIME_FORMAT(competition_heure_debut, "%H:%i"), competition_sponsor_1, competition_sponsor_2, competition_sponsor_3, competition_sponsor_4, competition_sponsors_classement, competition_active FROM competitions WHERE competition_id="'.$compet_id.'"');
	$resultat_competition = mysqli_fetch_array($requete_competition);
	$competition_date_debut = $resultat_competition[0];
	$competition_heure_debut = $resultat_competition[1];
	$competition_sponsor_1 = decodage_apostrophe(html_entity_decode(stripslashes($resultat_competition[2])));
	$competition_sponsor_2 = decodage_apostrophe(html_entity_decode(stripslashes($resultat_competition[3])));
	$competition_sponsor_3 = decodage_apostrophe(html_entity_decode(stripslashes($resultat_competition[4])));
	$competition_sponsor_4 = decodage_apostrophe(html_entity_decode(stripslashes($resultat_competition[5])));
	$competition_sponsors_classement = explode(',', $resultat_competition[6]);
	$competition_active = $resultat_competition[7];

}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none">
</head>

<body>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2">

	<div id="contenu_3" align="left" style="width: 650px;">

		<div id="titres">
			<span class="titre_1"><a href="./">Compétitions</a> <span class="separateur">/</span> <span class="titre_2">Modifier</span></span>
		</div>
		<br clear="all">

		<div id="bloc_bis">

			<?php if(isset($erreur_message) AND $erreur_message!=''){ ?>
				<div align="center"><div id="message_erreur" align="left"><b><?=$erreur_message_introduction.'</b><br>'.$erreur_message?></div></div>
			<?php } ?>

			<form name="modifier" action="<?=$PHP_SELF?>" method="post" enctype="multipart/form-data">

				<input type="hidden" name="action" value="modifier">
				<input type="hidden" name="compet_id" value="<?=$compet_id?>">

				<div id="formulaire_ligne">
					<div id="formulaire_libelle">Activation</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="checkbox" name="competition_active" value="1" <?php if($competition_active==1){ echo 'checked'; } ?>></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Date de début</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="competition_date_debut" value="<?=$competition_date_debut?>" class="input" style="width: 80px;">&nbsp;&nbsp;&nbsp; (format: dd/mm/aaaa)</div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Heure de début</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="competition_heure_debut" value="<?=$competition_heure_debut?>" class="input" style="width: 40px;">&nbsp;&nbsp;&nbsp; (format: hh:mm)</div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne_intertitre">SPONSORS JOURNALIERS</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">1er jour</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="competition_sponsor_1" value="<?=$competition_sponsor_1?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">2ème jour</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="competition_sponsor_2" value="<?=$competition_sponsor_2?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">3ème jour</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="competition_sponsor_3" value="<?=$competition_sponsor_3?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">4ème jour</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="competition_sponsor_4" value="<?=$competition_sponsor_4?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne_intertitre">SPONSORS DU CLASSEMENT</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Sponsors</div>
					<div id="formulaire_champ" style="width: 500px;">
						<?php 
						// Sélection des sponsors enregistrées pour le classement
						$requete_sponsors_classement = mysqli_query($connexion_mysql, 'SELECT sponsor_id, sponsor_nom FROM sponsors WHERE sponsor_actif=1 ORDER BY sponsor_classement');
						$nb_sponsors_classement = mysqli_num_rows($requete_sponsors_classement);
						if($nb_sponsors_classement!=0){
							for($sponsor_classement_boucle=0; $sponsor_classement_boucle<$nb_sponsors_classement; $sponsor_classement_boucle++){
								$resultat_sponsor_classement = mysqli_fetch_array($requete_sponsors_classement);
								$sponsor_classement_id = $resultat_sponsor_classement[0];
								$sponsor_classement_nom = $resultat_sponsor_classement[1];

								if(in_array($sponsor_classement_id, $competition_sponsors_classement)==true){ $sponsor_classement_selection = ' checked'; }else{ $sponsor_classement_selection = ''; }

								echo '<input type="checkbox" id="sponsor_classement_'.$sponsor_classement_id.'" name="competition_sponsors_classement[]" value="'.$sponsor_classement_id.'" class="checbox"'.$sponsor_classement_selection.'> <label for="sponsor_classement_'.$sponsor_classement_id.'">'.$sponsor_classement_nom.'</label><br>'."\n";

							}
						}else{
							echo 'Aucun sponsor disponible pour le classement.';
						}
						?>
					</div>
					<br clear="all">
				</div>

				<div id="formulaire_boutons"><input type="image" src="<?=$admin_img?>btn_enregistrer.png" width="150" height="32" align="absmiddle" style="margin: 15px 5px 20px 0px;"> ou&nbsp; <a href="./" class="lien_annuler">annuler</a></div>

			</form>

		</div>

	</div>
	<br clear="all">

</div></div>

<?php include $general_path_relatif.'sources/pied_page.inc'; ?>

<script language="Javascript">
	<!-- 
	document.modifier.competition_date_debut.focus();
	//-->
</script>

</body>
</html>
