<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(8, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(11, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


if(isset($action) AND $action=='modifier'){

	// Récupération des IDs de chaque golf
	$tab_golfs = array();
	foreach($tab_par as $golf_id=>$golf){
		array_push($tab_golfs, $golf_id);
	}

	/******************************/
	/**  Traitement des erreurs  **/
	/******************************/

	foreach($tab_golfs as $cle=>$golf_id){

		// Sélection du golf
		$requete_golf = mysqli_query($connexion_mysql, 'SELECT golf_nom FROM golfs WHERE golf_id='.$golf_id);
		$resultat_golf = mysqli_fetch_array($requete_golf);
		$golf_nom = strtoupper_max($resultat_golf[0]);

		foreach($tab_par[$golf_id] as $par_trou=>$par_indicateur){
			if($par_indicateur==''){
				$erreur_message .= "- le PAR du golf « ".$golf_nom." » pour le trou n°".($par_trou+1)." est manquant<br>";
			}elseif(is_numeric($par_indicateur)==false AND is_int($par_indicateur)==false){
				$erreur_message .= "- le PAR du golf « ".$golf_nom." » pour le trou n°".($par_trou+1)." est incorrect<br>";
			}
		}
		foreach($tab_handicap[$golf_id] as $handicap_trou=>$handicap_indicateur){
			if($handicap_indicateur==''){
				$erreur_message .= "- l'handicap du golf « ".$golf_nom." » pour le trou n°".($handicap_trou+1)." est manquant<br>";
			}elseif(is_numeric($handicap_indicateur)==false AND is_int($handicap_indicateur)==false){
				$erreur_message .= "- l'handicap du golf « ".$golf_nom." » pour le trou n°".($handicap_trou+1)." est incorrect<br>";
			}
		}
		foreach($tab_blanches[$golf_id] as $blanches_trou=>$blanches_indicateur){
			if($blanches_indicateur==''){
				$erreur_message .= "- la distance blanche du golf « ".$golf_nom." » pour le trou n°".($blanches_trou+1)." est manquante<br>";
			}elseif(is_numeric($blanches_indicateur)==false AND is_int($blanches_indicateur)==false){
				$erreur_message .= "- la distance blanche du golf « ".$golf_nom." » pour le trou n°".($blanches_trou+1)." est incorrecte<br>";
			}
		}
		foreach($tab_jaunes[$golf_id] as $jaunes_trou=>$jaunes_indicateur){
			if($jaunes_indicateur==''){
				$erreur_message .= "- la distance jaune du golf « ".$golf_nom." » pour le trou n°".($jaunes_trou+1)." est manquante<br>";
			}elseif(is_numeric($jaunes_indicateur)==false AND is_int($jaunes_indicateur)==false){
				$erreur_message .= "- la distance jaune du golf « ".$golf_nom." » pour le trou n°".($jaunes_trou+1)." est incorrecte<br>";
			}
		}
		foreach($tab_rouges[$golf_id] as $rouges_trou=>$rouges_indicateur){
			if($rouges_indicateur==''){
				$erreur_message .= "- la distance rouge du golf « ".$golf_nom." » pour le trou n°".($rouges_trou+1)." est manquante<br>";
			}elseif(is_numeric($rouges_indicateur)==false AND is_int($rouges_indicateur)==false){
				$erreur_message .= "- la distance rouge du golf « ".$golf_nom." » pour le trou n°".($rouges_trou+1)." est incorrecte<br>";
			}
		}

	}

	if($erreur_message==''){

		/****************************************/
		/**  Enregistrement des modifications  **/
		/****************************************/

		// Suppression des roadbooks déjà enregistrés
		$requete_suppression = mysqli_query($connexion_mysql, 'TRUNCATE TABLE golfs_roadbook');

		// Défragmentation de la table
		$requete_defragmentation = mysqli_query($connexion_mysql, 'ALTER TABLE golfs_roadbook AUTO_INCREMENT=1');

		foreach($tab_golfs as $cle=>$golf_id){

			foreach($tab_par[$golf_id] as $par_trou=>$par_indicateur){

				$handicap_indicateur = $tab_handicap[$golf_id][$par_trou];
				$blanche_indicateur = $tab_blanches[$golf_id][$par_trou];
				$jaune_indicateur = $tab_jaunes[$golf_id][$par_trou];
				$rouge_indicateur = $tab_rouges[$golf_id][$par_trou];

				// Requête d'insertion du roadbook
				$requete_insertion = mysqli_query($connexion_mysql, 'INSERT INTO golfs_roadbook (roadbook_golf, roadbook_trou, roadbook_par, roadbook_hcp, roadbook_blanche, roadbook_jaune, roadbook_rouge) VALUES('.$golf_id.', '.$par_trou.', '.$par_indicateur.', "'.$handicap_indicateur.'", "'.$blanche_indicateur.'", '.$jaune_indicateur.', '.$rouge_indicateur.')');

			}

		}

		header('Location: ./');
		exit;

	}

}

if(!isset($erreur_message) OR (isset($erreur_message) AND $erreur_message=='')){

	// Sélection du roadbook
	$requete_roadbook = mysqli_query($connexion_mysql, 'SELECT roadbook_golf, roadbook_trou, roadbook_par, roadbook_hcp, roadbook_blanche, roadbook_jaune, roadbook_rouge FROM golfs_roadbook ORDER BY roadbook_golf, roadbook_trou');
	$nb_roadbook = mysqli_num_rows($requete_roadbook);
	if($nb_roadbook!=0){
		for($roadbook_boucle=0; $roadbook_boucle<$nb_roadbook; $roadbook_boucle++){
			$resultat_roadbook = mysqli_fetch_array($requete_roadbook);
			$roadbook_golf = $resultat_roadbook[0];
			$roadbook_trou = $resultat_roadbook[1];
			$roadbook_par = $resultat_roadbook[2];
			$roadbook_hcp = $resultat_roadbook[3];
			$roadbook_blanche = $resultat_roadbook[4];
			$roadbook_jaune = $resultat_roadbook[5];
			$roadbook_rouge = $resultat_roadbook[6];

			// Initialisation des tableaux
			if(!isset($tab_par[$roadbook_golf])){
				$tab_par[$roadbook_golf] = array();
				$tab_handicap[$roadbook_golf] = array();
				$tab_blanches[$roadbook_golf] = array();
				$tab_jaunes[$roadbook_golf] = array();
				$tab_rouges[$roadbook_golf] = array();
				$tab_par_aller[$roadbook_golf] = $tab_par_retour[$roadbook_golf] = $tab_par_total[$roadbook_golf] = 0;
			}

			array_push($tab_par[$roadbook_golf], $roadbook_par);
			array_push($tab_handicap[$roadbook_golf], $roadbook_hcp);
			array_push($tab_blanches[$roadbook_golf], $roadbook_blanche);
			array_push($tab_jaunes[$roadbook_golf], $roadbook_jaune);
			array_push($tab_rouges[$roadbook_golf], $roadbook_rouge);

			if($roadbook_trou<=9){
				$tab_par_aller[$roadbook_golf] = $tab_par_aller[$roadbook_golf] + $roadbook_par;
			}else{
				$tab_par_retour[$roadbook_golf] = $tab_par_retour[$roadbook_golf] + $roadbook_par;
			}
			$tab_par_total[$roadbook_golf] = $tab_par_total[$roadbook_golf] + $roadbook_par;

		}
	}

}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<link rel="stylesheet" type="text/css" href="<?=$general_path_relatif?>css/cartes_score.css">
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none">
</head>

<body>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2">

	<div id="contenu_3" align="left" style="width: 940px;">

		<div id="titres">
			<span class="titre_1"><a href="./">Roadbooks</a> <span class="separateur">/</span> <span class="titre_2">Modifier</span></span>
		</div>
		<br clear="all">

		<div id="bloc_bis">

			<?php if(isset($erreur_message) AND $erreur_message!=''){ ?>
				<div align="center"><div id="message_erreur" align="left"><b><?=$erreur_message_introduction.'</b><br>'.$erreur_message?></div></div>
			<?php } ?>

			<form name="modifier" action="<?=$PHP_SELF?>" method="post" enctype="multipart/form-data">

				<input type="hidden" name="action" value="modifier">

				<?php 
				// Sélection des parcours de golf
				$requete_golfs = mysqli_query($connexion_mysql, 'SELECT DISTINCT(roadbook_golf), golf_nom FROM golfs_roadbook A INNER JOIN golfs B ON A.roadbook_golf=B.golf_id ORDER BY roadbook_golf');
				$nb_golfs = mysqli_num_rows($requete_golfs);
				if($nb_golfs!=0 OR count($tab_roadbook)==0){

					for($golf_boucle=0; $golf_boucle<$nb_golfs; $golf_boucle++){
						$resultat_golf = mysqli_fetch_array($requete_golfs);
						$golf_id = $resultat_golf[0];
						$golf_nom = strtoupper_max($resultat_golf[1]);
				?>

						<div id="formulaire_ligne_intertitre" style="width: 890px; font-size: 14px; color: #9C9A8C;"><b><?=$golf_nom?></b></div>

						<table border="0" id="carte_score">
							<tr>
								<td class="carte_entete_ligne">Trou</td>
								<td class="carte_entete">1</td>
								<td class="carte_entete">2</td>
								<td class="carte_entete">3</td>
								<td class="carte_entete">4</td>
								<td class="carte_entete">5</td>
								<td class="carte_entete">6</td>
								<td class="carte_entete">7</td>
								<td class="carte_entete">8</td>
								<td class="carte_entete">9</td>
								<td class="carte_entete">10</td>
								<td class="carte_entete">11</td>
								<td class="carte_entete">12</td>
								<td class="carte_entete">13</td>
								<td class="carte_entete">14</td>
								<td class="carte_entete">15</td>
								<td class="carte_entete">16</td>
								<td class="carte_entete">17</td>
								<td class="carte_entete">18</td>
								<td class="carte_fin_ligne">Retour</td>
								<td class="carte_fin_ligne">Aller</td>
								<td class="carte_fin_ligne">Total</td>
							</tr>
							<tr>
								<td class="carte_entete_ligne">Par</td>
								<?php foreach($tab_par[$golf_id] as $tab_trou_cle=>$tab_trou){ ?>
									<td class="carte_ligne" style="font-weight: bold;"><input type="text" name="tab_par[<?=$golf_id?>][<?=$tab_trou_cle+1?>]" value="<?=$tab_par[$golf_id][$tab_trou_cle]?>" maxlength="2" class="score_2"></td>
								<?php } ?>
								<td class="carte_fin_ligne"><input type="text" name="tab_par_retour[<?=$golf_id?>]" value="<?=$tab_par_retour[$golf_id]?>" maxlenght="2" class="score_2" style="background-color: #FFFFFF; border: 0px; font-size: 12px; font-weight: bold;" readonly></td>
								<td class="carte_fin_ligne"><input type="text" name="tab_par_aller[<?=$golf_id?>]" value="<?=$tab_par_aller[$golf_id]?>" maxlenght="2" class="score_2" style="background-color: #FFFFFF; border: 0px; font-size: 12px; font-weight: bold;" readonly></td>
								<td class="carte_fin_ligne"><input type="text" name="tab_par_total[<?=$golf_id?>]" value="<?=$tab_par_total[$golf_id]?>" maxlenght="2" class="score_2" style="background-color: #FFFFFF; border: 0px; font-size: 12px; font-weight: bold;" readonly></td>
							</tr>
							<tr>
								<td class="carte_entete_ligne">Handicap</td>
								<?php foreach($tab_handicap[$golf_id] as $tab_trou_cle=>$tab_trou){ ?>
									<td class="carte_ligne"><input type="text" name="tab_handicap[<?=$golf_id?>][<?=$tab_trou_cle+1?>]" value="<?=$tab_handicap[$golf_id][$tab_trou_cle]?>" maxlength="2" class="score_2"></td>
								<?php } ?>
							</tr>
						</table>
						<table border="0" id="carte_score">
							<tr>
								<td class="carte_entete_ligne">Blanches</td>
								<?php foreach($tab_blanches[$golf_id] as $tab_trou_cle=>$tab_trou){ ?>
									<td class="carte_ligne_petit"><input type="text" name="tab_blanches[<?=$golf_id?>][<?=$tab_trou_cle+1?>]" value="<?=$tab_blanches[$golf_id][$tab_trou_cle]?>" maxlength="3" class="score_2"></td>
								<?php } ?>
							</tr>
							<tr>
								<td class="carte_entete_ligne">Jaunes</td>
								<?php foreach($tab_jaunes[$golf_id] as $tab_trou_cle=>$tab_trou){ ?>
									<td class="carte_ligne_petit"><input type="text" name="tab_jaunes[<?=$golf_id?>][<?=$tab_trou_cle+1?>]" value="<?=$tab_jaunes[$golf_id][$tab_trou_cle]?>" maxlength="3" class="score_2"></td>
								<?php } ?>
							</tr>
							<tr>
								<td class="carte_entete_ligne">Rouges</td>
								<?php foreach($tab_rouges[$golf_id] as $tab_trou_cle=>$tab_trou){ ?>
									<td class="carte_ligne_petit"><input type="text" name="tab_rouges[<?=$golf_id?>][<?=$tab_trou_cle+1?>]" value="<?=$tab_rouges[$golf_id][$tab_trou_cle]?>" maxlength="3" class="score_2"></td>
								<?php } ?>
							</tr>
						</table>
						<br clear="all">
				<?php 
					}
	
				}else{
					echo '<div id="ligne">aucun parcours dans le roadbook.</div>'."\n";
				}
				?>

				<br>

				<div id="formulaire_boutons"><input type="image" src="<?=$admin_img?>btn_enregistrer.png" width="150" height="32" align="absmiddle" style="margin: 15px 5px 20px 0px;"> ou&nbsp; <a href="./" class="lien_annuler">annuler</a></div>

			</form>

		</div>

	</div>
	<br clear="all">

</div></div>

<?php include $general_path_relatif.'sources/pied_page.inc'; ?>

</body>
</html>
