<?php
require_once '../../../lib/configuration.inc';
require_once '../../libs/fpdf.php';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND in_array(7, $_SESSION['SessionADMIN_compte_acces_modules'])==false){
	header('Location: ../../');
	exit;
}


define('ESPACE', chr(32));		// Remplace le caractère Espace (&nbsp;)
$where = '';

if(isset($gp) AND strlen(trim($gp))!=0){
	$critere_groupes = explode('|', $gp);
	$where .= ' AND planning_groupe IN ("'.implode('","', $critere_groupes).'")';
}

if(!isset($classement)){ $classement = 'equipe_libelle'; }


// Sélection de la dernière compétition enregistrée
$requete_competition = mysqli_query($connexion_mysql, 'SELECT competition_id, competition_annee, competition_nb_golfs, competition_nb_groupes, competition_intervalle_departs FROM competitions WHERE competition_active=1 AND competition_archive=0 ORDER BY competition_annee DESC');
$nb_competitions = mysqli_num_rows($requete_competition);
if($nb_competitions!=0){
	$resultat_competition = mysqli_fetch_array($requete_competition);
	$competition_id = $resultat_competition[0];
	$competition_annee = $resultat_competition[1];
	$competition_nb_golfs = $resultat_competition[2];
	$competition_nb_groupes = $resultat_competition[3];
	$competition_intervalle_departs = $resultat_competition[4];
}else{
	header('Location: ../../');
}

// Sélection des départs du calendrier de la dernière compétition
$requete_groupes = mysqli_query($connexion_mysql, 'SELECT DISTINCT(planning_groupe) FROM planning WHERE competition_id="'.$competition_id.'"'.$where.' ORDER BY planning_groupe');
$nb_groupes = mysqli_num_rows($requete_groupes);

/**************************************************************************************************************************************/

class PDF extends FPDF {

	// Entête des colonnes (dates, golfs)
	function Dates_Golfs($connexion_mysql, $competition_annee, $planning_groupe, $competition_nb_golfs){

		global $tab_groupe_golfs;

		$tab_groupe_golfs = array();

		$this->Image('../../img/logo_proamcoteopale_noirblanc_bis.png', 8, 8.8, -300);		// Image de l'entête

		$this->SetFont('Arial', 'B', 34);
		$this->SetTextColor(0,0,0);
		$this->Cell(23, 1, '', 0, 0, 'L', false);
		$this->Cell(30, 9, $competition_annee, 0, 0, 'L', false);

		$this->SetFont('Arial', 'B', 20);
		$this->SetTextColor(248,149,38);
		$this->Cell(130, 1, 'GROUPE '.$planning_groupe, 0, 0, 'C', false);

		$this->Ln(7);

		for($k=0; $k<2; $k++){

			// Sélection des dates et des golfs correspondants
			$requete_dates_golfs = mysqli_query($connexion_mysql, 'SELECT DISTINCT(DATE_FORMAT(planning_depart_date, "%d/%m/%y")), golf_id, (SELECT golf_nom FROM golfs WHERE golf_id=planning.golf_id) FROM planning WHERE planning_groupe="'.$planning_groupe.'" ORDER BY planning_depart_date');
			$nb_dates_golfs = mysqli_num_rows($requete_dates_golfs);
			for($date_golf_boucle=0; $date_golf_boucle<$nb_dates_golfs; $date_golf_boucle++){
				$resultat_date_golf = mysqli_fetch_array($requete_dates_golfs);
				$planning_date = $resultat_date_golf[0];
				$planning_golf_id = $resultat_date_golf[1];
				$planning_golf = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_date_golf[2]))));

				array_push($tab_groupe_golfs, $planning_golf_id);	// Tableau contenant l'ordre des golfs classé par date croissante

				if($date_golf_boucle==0){
					$this->Cell(50, 3, '', 0, 0, 'L', false);
				}

				if($date_golf_boucle!=($nb_dates_golfs-1)){ $retour_ligne = 0; }else{ $retour_ligne = 1; }

				$this->SetFont('Arial', 'B', 10);
				if($k==0){
					$this->SetTextColor(0,0,0);
					$this->Cell(35, 7, $planning_date, 0, $retour_ligne, 'C', false);
				}else{
					$this->SetTextColor(24,157,179);
					$this->Cell(35, 5, $planning_golf, 0, $retour_ligne, 'C', false);
				}
			}

		}

		$this->Ln(4);

		$this->Cell(190, 0, '', 'T', 1, 'L', false);

	}


	// Planning
	function Planning($connexion_mysql, $competition_id, $planning_groupe, $classement){

		global $tab_groupe_golfs;

		// Sélection des horaires de départ
		$requete_planning = mysqli_query($connexion_mysql, 'SELECT planning_id, equipe_id AS equipe_identifiant, (SELECT equipe_nom FROM equipes WHERE equipe_id=equipe_identifiant) AS equipe_libelle, (SELECT planning_depart_heure FROM planning WHERE equipe_id=equipe_identifiant AND golf_id='.$tab_groupe_golfs[0].') AS date_1, (SELECT planning_depart_heure FROM planning WHERE equipe_id=equipe_identifiant AND golf_id='.$tab_groupe_golfs[1].') AS date_2, (SELECT planning_depart_heure FROM planning WHERE equipe_id=equipe_identifiant AND golf_id='.$tab_groupe_golfs[2].') AS date_3, (SELECT planning_depart_heure FROM planning WHERE equipe_id=equipe_identifiant AND golf_id='.$tab_groupe_golfs[3].') AS date_4 FROM planning WHERE planning_groupe="'.$planning_groupe.'" GROUP BY equipe_identifiant ORDER BY '.$classement);
		$nb_planning = mysqli_num_rows($requete_planning);
		if($nb_planning!=0){
			for($planning_boucle=0; $planning_boucle<$nb_planning; $planning_boucle++){
				$resultat_planning = mysqli_fetch_array($requete_planning);
				$planning_id = $resultat_planning[0];
				$equipe_id = $resultat_planning[1];
				$equipe_nom = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_planning[2]))));
				$planning_depart_heure_1 = preg_replace('/:/', ' H ', substr($resultat_planning[3], 0, -3));
				$planning_depart_heure_2 = preg_replace('/:/', ' H ', substr($resultat_planning[4], 0, -3));
				$planning_depart_heure_3 = preg_replace('/:/', ' H ', substr($resultat_planning[5], 0, -3));
				$planning_depart_heure_4 = preg_replace('/:/', ' H ', substr($resultat_planning[6], 0, -3));

				// Suppression du 0 devant l'heure s'il y a
				if(substr($planning_depart_heure_1, 0, 1)=='0'){ $planning_depart_heure_1 = substr($planning_depart_heure_1, 1); }
				if(substr($planning_depart_heure_2, 0, 1)=='0'){ $planning_depart_heure_2 = substr($planning_depart_heure_2, 1); }
				if(substr($planning_depart_heure_3, 0, 1)=='0'){ $planning_depart_heure_3 = substr($planning_depart_heure_3, 1); }
				if(substr($planning_depart_heure_4, 0, 1)=='0'){ $planning_depart_heure_4 = substr($planning_depart_heure_4, 1); }

				$this->Ln(0.2);

				$this->SetFont('Arial', '', 9);
				$this->SetTextColor(0,0,0);
				$this->SetFillColor(238, 238, 238);
				$this->Cell(13, 4, utf8_decode('ÉQUIPE '), 0, 0, 'L', true);
				$this->SetFont('Arial', 'B', 9);
				$this->Cell(42, 4, $equipe_nom, 0, 0, 'L', true);

				// Sélection des joueurs amateurs de l'équipe
				$requete_amateurs = mysqli_query($connexion_mysql, 'SELECT joueur_nom, joueur_prenom FROM equipes_joueurs A INNER JOIN joueurs B ON A.ej_joueur=B.joueur_id WHERE ej_equipe="'.$equipe_id.'" AND (joueur_profil="pro" OR joueur_profil="am") ORDER BY joueur_profil DESC, joueur_nom, joueur_prenom');
				$nb_amateurs = mysqli_num_rows($requete_amateurs);
				if($nb_amateurs!=0){
					$equipe_joueurs = '';
					for($amateur_boucle=0; $amateur_boucle<$nb_amateurs; $amateur_boucle++){
						$resultat_amateur = mysqli_fetch_array($requete_amateurs);
						$amateur_nom = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_amateur[0]))));
						$amateur_prenom = substr($resultat_amateur[1], 0, 1).'.';

						if($amateur_boucle!=($nb_amateurs-1)){ $retour_ligne = 0; }else{ $retour_ligne = 1; }

						$equipe_joueurs .= $amateur_nom.' '.$amateur_prenom.ESPACE.ESPACE.' / '.ESPACE.ESPACE;

					}
					$equipe_joueurs = substr($equipe_joueurs, 0, -7);

					$this->SetFont('Arial', '', 8);
					$this->SetTextColor(102,102,102);
					$this->MultiCell(135.1, 4, $equipe_joueurs, 0, 'L', true);
				}


				$this->Ln(0.5);

				$this->Cell(50, 5, '', 0, 0, 'C', false);

				$this->SetFont('Arial', '', 10);
				$this->SetTextColor(24,157,179);
				$this->Cell(35, 5, $planning_depart_heure_1, 0, 0, 'C', false);
				$this->Cell(35, 5, $planning_depart_heure_2, 0, 0, 'C', false);
				$this->Cell(35, 5, $planning_depart_heure_3, 0, 0, 'C', false);
				$this->Cell(35, 5, $planning_depart_heure_4, 0, 1, 'C', false);

				$this->Ln(0.4);

				$this->Cell(190, 0, '', 'T', 1, 'L', false);

			}
		}

	}


	// Pied de page
	function Footer(){

		$this->SetXY(0, -10);															// Positionnement à 0 cm à gauche et à 1,5 cm du bas

		$this->SetFont('Arial', '', 9);
		$this->SetTextColor(0,0,0);
		$this->Cell(205, 4, $this->PageNo().' / {nb}', 0, 1, 'R', false);				// Numéro de page

	}

}

/**************************************************************************************************************************************/

// Instanciation de la classe dérivée
$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->SetMargins(8, 10, 8);

if($nb_groupes!=0){

	for($groupe_boucle=0; $groupe_boucle<$nb_groupes; $groupe_boucle++){
		$resultat_groupe = mysqli_fetch_array($requete_groupes);
		$planning_groupe = $resultat_groupe[0];

		$pdf->AddPage();

		$pdf->Dates_Golfs($connexion_mysql, $competition_annee, $planning_groupe, $competition_nb_golfs);
		$pdf->Planning($connexion_mysql, $competition_id, $planning_groupe, $classement);
	}

}

if(isset($archive) AND $archive==1){
	$pdf->Output('../../archives/archive_'.$competition_annee.'_planning.pdf', 'F');
	header('Location: ../resultats/cartes_score/exporter.php?archive=1');	// Ancienne redirection : ../competitions/competitions/archiver.php?process=cartes_score
	exit;
}else{
	$pdf->Output('Planning_'.$competition_annee.'.pdf', 'I');
}

?>