<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])) {
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(8, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(10, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)) {
	header('Location: ../../../');
	exit;
}


if(isset($action) AND $action=='modifier') {

	/******************************/
	/**  Traitement des erreurs  **/
	/******************************/
	if(strlen(trim($competition_date_debut))==0) {
		$erreur_message .= "- la date de début est manquante<br>";
	}
	if(strlen(trim($competition_heure_debut))==0) {
		$erreur_message .= "- l'heure de début est manquante<br>";
	}else{
		if(preg_match('/:/', $competition_heure_debut)==false) {
			$erreur_message .= "- l'heure de début est incorrecte<br>";
		}
	}
	if(strlen(trim($competition_sponsor_1))==0) {
		$erreur_message .= "- le sponsor du 1er jour est manquant<br>";
	}
	if(strlen(trim($competition_sponsor_2))==0) {
		$erreur_message .= "- le sponsor du 2ème jour est manquant<br>";
	}
	if(strlen(trim($competition_sponsor_3))==0) {
		$erreur_message .= "- le sponsor du 3ème jour est manquant<br>";
	}
	if(strlen(trim($competition_sponsor_4))==0) {
		$erreur_message .= "- le sponsor du 4ème jour est manquant<br>";
	}

	/******************************/
	/**  Traitement des données  **/
	/******************************/
	$competition_sponsor_1 = htmlentities(strtoupper($competition_sponsor_1), ENT_QUOTES);
	$competition_sponsor_2 = htmlentities(strtoupper($competition_sponsor_2), ENT_QUOTES);
	$competition_sponsor_3 = htmlentities(strtoupper($competition_sponsor_3), ENT_QUOTES);
	$competition_sponsor_4 = htmlentities(strtoupper($competition_sponsor_4), ENT_QUOTES);
	//if(!isset($competition_active)){ $competition_active = 0; }

	/****************************************/
	/**  Enregistrement des modifications  **/
	/****************************************/
	if($erreur_message=='') {

		$tab_date_debut = explode('/', $competition_date_debut);
		$competition_date_debut_jour = $tab_date_debut[0];
		$competition_date_debut_mois = $tab_date_debut[1];
		$competition_date_debut_annee = $tab_date_debut[2];

		//$competition_date_fin = date('d/m/Y', mktime(0, 0, 0, $competition_date_debut_mois, $competition_date_debut_jour+($competition_nb_jours-1), $competition_date_debut_annee));

		if(isset($competition_sponsors_classement)){ $competition_sponsors_classement = implode(',', $competition_sponsors_classement); }


		// Requête de mise à jour de la compétition
		$requete_maj = mysqli_query($connexion_mysql, 'UPDATE competitions SET competition_annee="'.$competition_date_debut_annee.'", competition_date_debut=STR_TO_DATE("'.$competition_date_debut.'", "%d/%m/%Y"), competition_date_fin=STR_TO_DATE("'.$competition_date_fin.'", "%d/%m/%Y"), competition_heure_debut=STR_TO_DATE("'.$competition_heure_debut.'", "%H:%i"), competition_sponsor_1="'.$competition_sponsor_1.'", competition_sponsor_2="'.$competition_sponsor_2.'", competition_sponsor_3="'.$competition_sponsor_3.'", competition_sponsor_4="'.$competition_sponsor_4.'", competition_sponsors_classement="'.$competition_sponsors_classement.'", competition_active="'.(int)$competition_active.'", prix_forfait="'.$prix_forfait.'", single_no_pisc="'.$single_no_pisc.'", single_pisc="'.$single_pisc.'", no_heb_pro_no_hotel="'.$no_heb_pro_no_hotel.'", no_heb_pro_hotel="'.$no_heb_pro_hotel.'", text_heb="'.$text_heb.'", text_heb_pro="'.$text_heb_pro.'", date_debut_hotel=STR_TO_DATE("'.$date_debut_hotel.'", "%d/%m/%Y"), date_fin_hotel=STR_TO_DATE("'.$date_fin_hotel.'", "%d/%m/%Y"), double_no_pisc = "'.$double_no_pisc.'", double_pisc = "'.$double_pisc.'", acc_double_pisc = "'.$acc_double_pisc.'", acc_single_pisc = "'.$acc_single_pisc.'", acc_double_no_pisc = "'.$acc_double_no_pisc.'", acc_single_no_pisc = "'.$acc_single_no_pisc.'", text_heb_acc = "'.$text_heb_acc.'", text_heb_2 = "'.$text_heb_2.'", text_heb_3 = "'.$text_heb_3.'", text_heb_4 = "'.$text_heb_4.'", text_heb_pro_2 = "'.$text_heb_pro_2.'", text_heb_pro_3 = "'.$text_heb_pro_3.'", text_heb_2_en = "'.$text_heb_2_en.'", text_heb_3_en = "'.$text_heb_3_en.'", text_heb_4_en = "'.$text_heb_4_en.'", text_heb_pro_2_en = "'.$text_heb_pro_2_en.'", text_heb_pro_3_en = "'.$text_heb_pro_3_en.'", text_acc_final_FR = "'.$text_acc_final_FR.'", text_acc_final_EN = "'.$text_acc_final_EN.'", text_heb_en = "'.$text_heb_en.'", text_heb_pro_en = "'.$text_heb_pro_en.'", text_heb_acc_en = "'.$text_heb_acc_en.'" WHERE competition_id="'.$compet_id.'"');

		//header('Location: ./');
		//exit;
		// text_acc_final_FR

	} else {
		$competition_sponsor_1 = stripslashes($competition_sponsor_1);
		$competition_sponsor_2 = stripslashes($competition_sponsor_2);
		$competition_sponsor_3 = stripslashes($competition_sponsor_3);
		$competition_sponsor_4 = stripslashes($competition_sponsor_4);
		$competition_sponsors_classement = explode(',', $competition_sponsors_classement);
	}
}


if(isset($erreur_message) AND $erreur_message==''){

	// Sélection de la compétition
	$requete_competition = mysqli_query($connexion_mysql, 'SELECT DATE_FORMAT(competition_date_debut, "%d/%m/%Y"), TIME_FORMAT(competition_heure_debut, "%H:%i"), competition_sponsor_1, competition_sponsor_2, competition_sponsor_3, competition_sponsor_4, competition_sponsors_classement, competition_active, prix_forfait, single_no_pisc, single_pisc, no_heb_pro_no_hotel, no_heb_pro_hotel, DATE_FORMAT(competition_date_fin, "%d/%m/%Y"), text_heb, text_heb_pro, DATE_FORMAT(date_debut_hotel, "%d/%m/%Y"), DATE_FORMAT(date_fin_hotel, "%d/%m/%Y"), double_no_pisc, double_pisc, acc_double_pisc, acc_single_pisc, acc_double_no_pisc, acc_single_no_pisc, text_heb_acc, text_heb_2, text_heb_3, text_heb_4, text_heb_pro_2, text_heb_pro_3, text_heb_2_en, text_heb_3_en, text_heb_4_en, text_heb_pro_2_en, text_heb_pro_3_en, text_acc_final_FR, text_acc_final_EN, text_heb_en, text_heb_pro_en, text_heb_acc_en FROM competitions WHERE competition_id="'.$compet_id.'"');
	$resultat_competition = mysqli_fetch_array($requete_competition);
	$competition_date_debut = $resultat_competition[0];
	$competition_heure_debut = $resultat_competition[1];
	$competition_sponsor_1 = decodage_apostrophe(html_entity_decode(stripslashes($resultat_competition[2])));
	$competition_sponsor_2 = decodage_apostrophe(html_entity_decode(stripslashes($resultat_competition[3])));
	$competition_sponsor_3 = decodage_apostrophe(html_entity_decode(stripslashes($resultat_competition[4])));
	$competition_sponsor_4 = decodage_apostrophe(html_entity_decode(stripslashes($resultat_competition[5])));
	$competition_sponsors_classement = explode(',', $resultat_competition[6]);
	$competition_active = $resultat_competition[7];
	$prix_forfait = $resultat_competition[8];
	$single_no_pisc = $resultat_competition[9];
	$single_pisc = $resultat_competition[10];
	$no_heb_pro_no_hotel = $resultat_competition[11];
	$no_heb_pro_hotel = $resultat_competition[12];
	$competition_date_fin = $resultat_competition[13];
	$text_heb = $resultat_competition[14];
	$text_heb_pro = $resultat_competition[15];
	$date_debut_hotel = $resultat_competition[16];
	$date_fin_hotel = $resultat_competition[17];
	$double_no_pisc = $resultat_competition[18];
	$double_pisc = $resultat_competition[19];
	$acc_double_pisc = $resultat_competition[20];
	$acc_single_pisc = $resultat_competition[21];
	$acc_double_no_pisc = $resultat_competition[22];
	$acc_single_no_pisc = $resultat_competition[23];
	$text_heb_acc = $resultat_competition[24];
	$text_heb_2 = $resultat_competition[25];
	$text_heb_3 = $resultat_competition[26];
	$text_heb_4 = $resultat_competition[27];
	$text_heb_pro_2 = $resultat_competition[28];
	$text_heb_pro_3 = $resultat_competition[29];
	$text_heb_2_en = $resultat_competition[30];
	$text_heb_3_en = $resultat_competition[31];
	$text_heb_4_en = $resultat_competition[32];
	$text_heb_pro_2_en = $resultat_competition[33];
	$text_heb_pro_3_en = $resultat_competition[34];
	$text_acc_final_FR = $resultat_competition[35];
	$text_acc_final_EN = $resultat_competition[36];
	$text_heb_en = $resultat_competition[37];
	$text_heb_pro_en = $resultat_competition[38];
	$text_heb_acc_en = $resultat_competition[39];
}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none">
</head>

<body>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2">

	<div id="contenu_3" align="left" style="width: 650px;">

		<div id="titres">
			<span class="titre_1"><a href="./">Compétitions</a> <span class="separateur">/</span> <span class="titre_2">Modifier</span></span>
		</div>
		<br clear="all">

		<div id="bloc_bis">

			<?php if(isset($erreur_message) AND $erreur_message!=''){ ?>
				<div align="center"><div id="message_erreur" align="left"><b><?=$erreur_message_introduction.'</b><br>'.$erreur_message?></div></div>
			<?php } ?>

			<form name="modifier" action="<?=$PHP_SELF?>" method="post" enctype="multipart/form-data">

				<input type="hidden" name="action" value="modifier">
				<input type="hidden" name="compet_id" value="<?=$compet_id?>">

				<div id="formulaire_ligne">
					<div id="formulaire_libelle">Activation</div>
					<div id="formulaire_champ" style="width: 500px;"> <input type="checkbox" name="competition_active" value="1" <?php if($competition_active==1){ echo 'checked'; } ?>> </div>

					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Date de début</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="competition_date_debut" value="<?=$competition_date_debut?>" class="input" style="width: 80px;">&nbsp;&nbsp;&nbsp; (format: dd/mm/aaaa)</div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Date de fin</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="competition_date_fin" value="<?=$competition_date_fin?>" class="input" style="width: 80px;">&nbsp;&nbsp;&nbsp; (format: dd/mm/aaaa)</div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Heure de début</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="competition_heure_debut" value="<?=$competition_heure_debut?>" class="input" style="width: 40px;">&nbsp;&nbsp;&nbsp; (format: hh:mm)</div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne_intertitre">SPONSORS JOURNALIERS</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">1er jour</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="competition_sponsor_1" value="<?=$competition_sponsor_1?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">2ème jour</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="competition_sponsor_2" value="<?=$competition_sponsor_2?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">3ème jour</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="competition_sponsor_3" value="<?=$competition_sponsor_3?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">4ème jour</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="competition_sponsor_4" value="<?=$competition_sponsor_4?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne_intertitre">SPONSORS DU CLASSEMENT</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Sponsors</div>
					<div id="formulaire_champ" style="width: 500px;">
						<?php 
						// Sélection des sponsors enregistrées pour le classement
						$requete_sponsors_classement = mysqli_query($connexion_mysql, 'SELECT sponsor_id, sponsor_nom FROM sponsors WHERE sponsor_actif=1 ORDER BY sponsor_classement');
						$nb_sponsors_classement = mysqli_num_rows($requete_sponsors_classement);
						if($nb_sponsors_classement!=0){
							for($sponsor_classement_boucle=0; $sponsor_classement_boucle<$nb_sponsors_classement; $sponsor_classement_boucle++){
								$resultat_sponsor_classement = mysqli_fetch_array($requete_sponsors_classement);
								$sponsor_classement_id = $resultat_sponsor_classement[0];
								$sponsor_classement_nom = $resultat_sponsor_classement[1];

								if(in_array($sponsor_classement_id, $competition_sponsors_classement)==true){ $sponsor_classement_selection = ' checked'; }else{ $sponsor_classement_selection = ''; }

								echo '<input type="checkbox" id="sponsor_classement_'.$sponsor_classement_id.'" name="competition_sponsors_classement[]" value="'.$sponsor_classement_id.'" class="checbox"'.$sponsor_classement_selection.'> <label for="sponsor_classement_'.$sponsor_classement_id.'">'.$sponsor_classement_nom.'</label><br>'."\n";

							}
						}else{
							echo 'Aucun sponsor disponible pour le classement.';
						}
						?>
					</div>
					<br clear="all">
				</div>


				<div id="formulaire_ligne_intertitre">Prix forfait</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Prix standard</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="prix_forfait" value="<?=$prix_forfait?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Ajout single</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="single_no_pisc" value="<?=$single_no_pisc?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Ajout single + piscine</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="single_pisc" value="<?=$single_pisc?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Ajout double , pas de piscine</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="double_no_pisc" value="<?=$double_no_pisc?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Ajout double + piscine</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="double_pisc" value="<?=$double_pisc?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>


				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Prix sans hébergement, professionnel non logé</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="no_heb_pro_no_hotel" value="<?=$no_heb_pro_no_hotel?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>


				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Prix sans hébergement, professionnel logé</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="no_heb_pro_hotel" value="<?=$no_heb_pro_hotel?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Prix acc double + piscine</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="acc_double_pisc" value="<?=$acc_double_pisc?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>


				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Prix acc single + piscine</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="acc_single_pisc" value="<?=$acc_single_pisc?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>


				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Prix acc double no piscine</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="acc_double_no_pisc" value="<?=$acc_double_no_pisc?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Prix acc single no piscine</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="acc_single_no_pisc" value="<?=$acc_single_no_pisc?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>


				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Texte hebergement</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="text_heb" value="<?=$text_heb?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>



				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Texte hebergement EN</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="text_heb_en" value="<?=$text_heb_en?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>












				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">text_heb_2</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="text_heb_2" value="<?=$text_heb_2?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>


				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">text_heb_2_en</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="text_heb_2_en" value="<?=$text_heb_2_en?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>


				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">text_heb_3</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="text_heb_3" value="<?=$text_heb_3?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>


				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">text_heb_3_en</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="text_heb_3_en" value="<?=$text_heb_3_en?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>


				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">text_heb_4</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="text_heb_4" value="<?=$text_heb_4?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>


				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">text_heb_4_en</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="text_heb_4_en" value="<?=$text_heb_4_en?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>






				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">text_heb_pro_2</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="text_heb_pro_2" value="<?=$text_heb_pro_2?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>


				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">text_heb_pro_2_en</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="text_heb_pro_2_en" value="<?=$text_heb_pro_2_en?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>


				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">text_heb_pro_3</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="text_heb_pro_3" value="<?=$text_heb_pro_3?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>


				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">text_heb_pro_3_en</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="text_heb_pro_3_en" value="<?=$text_heb_pro_3_en?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>











				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Texte hébergement pro</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="text_heb_pro" value="<?=$text_heb_pro?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>


				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Texte hébergement pro EN</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="text_heb_pro_en" value="<?=$text_heb_pro_en?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>


				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Texte hébergement acc</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="text_heb_acc" value="<?=$text_heb_acc?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>



				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Texte hébergement acc EN</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="text_heb_acc_en" value="<?=$text_heb_acc_en?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>



				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Texte final acc FR</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="text_acc_final_FR" value="<?=$text_acc_final_FR?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>


				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Texte final acc EN</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="text_acc_final_EN" value="<?=$text_acc_final_EN?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>






				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Date de début hôtel</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="date_debut_hotel" value="<?=$date_debut_hotel?>" class="input" style="width: 80px;">&nbsp;&nbsp;&nbsp; (format: dd/mm/aaaa)</div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Date de fin hôtel</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="date_fin_hotel" value="<?=$date_fin_hotel?>" class="input" style="width: 80px;">&nbsp;&nbsp;&nbsp; (format: dd/mm/aaaa)</div>
					<br clear="all">
				</div>

				

				<div id="formulaire_boutons"><input type="image" src="<?=$admin_img?>btn_enregistrer.png" width="150" height="32" align="absmiddle" style="margin: 15px 5px 20px 0px;"> ou&nbsp; <a href="./" class="lien_annuler">annuler</a></div>

			</form>

		</div>

	</div>
	<br clear="all">

</div></div>

<?php include $general_path_relatif.'sources/pied_page.inc'; ?>

<script language="Javascript">
	<!-- 
	document.modifier.competition_date_debut.focus();
	//-->
</script>

</body>
</html>
