<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(1, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(1, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none">
</head>

<body>

<script language="Javascript">
	<!-- 
	function supprimer(identifiant, libelle){
		resultat = confirm("Désirez-vous réellement supprimer le compte ' " + libelle + " ' ?");
		if(resultat == true){
			window.location = './supprimer.php?compte_id=' + identifiant;
		}
	}
	//-->
</script>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2">

	<div id="contenu_3" align="left" style="width: 450px;">

		<div id="titres">
			<span class="titre_1">Comptes</span>
			<span class="ajouter"><a href="./ajouter.php">Ajouter</a></span>
		</div>
		<br clear="all">

		<div id="bloc">

			<?php 
			$tableau_compte_types = array('superviseur', 'administrateur', 'utilisateur');

			foreach($tableau_compte_types as $compte_type){

				// Sélection des comptes ADMIN enregistrées
				$requete_comptes = mysqli_query($connexion_mysql, 'SELECT compte_id, compte_type, compte_nom, compte_prenom FROM admin_comptes WHERE compte_type="'.$compte_type.'" ORDER BY compte_nom, compte_prenom');
				$nb_comptes = mysqli_num_rows($requete_comptes);
				if($nb_comptes!=0){

					for($compte_boucle=0; $compte_boucle<$nb_comptes; $compte_boucle++){
						$resultat_compte = mysqli_fetch_array($requete_comptes);
						$compte_id = $resultat_compte[0];
						$compte_type = ucfirst($resultat_compte[1]);
						$compte_nom = strtoupper_max(decodage_apostrophe(html_entity_decode(stripslashes($resultat_compte[2]))));
						$compte_prenom = ucfirst(decodage_apostrophe(html_entity_decode(stripslashes($resultat_compte[3]))));
			?>

						<div id="ligne">
							<div style="float: left; width: 205px;"><a href="./modifier.php?compte_id=<?=$compte_id?>"><?=$compte_nom.' '.$compte_prenom?></a></div>
							<div align="center" style="float: left; width: 130px; border-left: 1px solid #CCCCCC;"><?=$compte_type?></div>
							<?php if($compte_type=='Utilisateur'){ ?>
								<div align="center" style="float: left; width: 50px; border-left: 1px solid #CCCCCC;"><a href="./droits_acces.php?compte_id=<?=$compte_id?>" title="Modifier les droits d'accès"><img src="<?=$admin_img?>picto_securiser.png" width="16" height="15" style="margin: 5px 0px 5px 0px;"></a></div>
							<?php }else{ ?>
								<div align="center" style="float: left; width: 50px; border-left: 1px solid #CCCCCC;"><img src="<?=$admin_img?>picto_securiser.png" width="16" height="15" style="margin: 5px 0px 5px 0px; filter: alpha(opacity=5); -moz-opacity: 0.5; opacity: 0.5;"></div>
							<?php } ?>
							<?php if(($_SESSION['SessionADMIN_compte_type']=='superviseur' AND $compte_type=='Superviseur') OR $compte_type!='Superviseur'){ ?>
								<div id="ligne_icone"><a href="./modifier.php?compte_id=<?=$compte_id?>" title="Modifier"><img src="<?=$admin_img?>picto_modifier.png" width="10" height="10"></a></div>
								<div id="ligne_icone"><a href="Javascript:void(0);" onclick="supprimer('<?=$compte_id?>', '<?=$compte_prenom.' '.$compte_nom?>')" title="Supprimer"><img src="<?=$admin_img?>picto_supprimer.png" width="10" height="10"></a></div>
							<?php } ?>
						</div>

			<?php 
					}
				}
			}
			?>

		</div>

	</div>
	<br clear="all">

</div></div>

<?php include $general_path_relatif.'sources/pied_page.inc'; ?>

</body>
</html>
