<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(6, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(5, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


// Sélection des factures enregistrées
$requete_factures = mysqli_query($connexion_mysql, 'SELECT facture_id, DATE_FORMAT(facture_date, "%d/%m/%y"), facture_numero, facture_package, A.joueur_id, joueur_nom, joueur_prenom, facture_prix_ht, facture_prix_ttc, facture_envoyee, facture_payee FROM factures A INNER JOIN joueurs B ON A.joueur_id=B.joueur_id ORDER BY facture_numero DESC, facture_date DESC, joueur_nom, joueur_prenom');
//$requete_factures = mysqli_query($connexion_mysql, 'SELECT facture_id, DATE_FORMAT(facture_date, "%d/%m/%y"), facture_numero, facture_package, joueur_id, joueur_nom, joueur_prenom, facture_prix_ht, facture_prix_ttc, facture_envoyee, facture_payee FROM factures ORDER BY facture_numero DESC, facture_date DESC, joueur_nom, joueur_prenom') or die(mysqli_error($connexion_mysql));
$nb_factures = mysqli_num_rows($requete_factures);
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none">
</head>

<body>

<script language="Javascript">
	<!-- 
	function supprimer(identifiant, libelle){
		resultat = confirm("Désirez-vous réellement supprimer la facture n° " + libelle + " ?");
		if(resultat == true){
			window.location = './supprimer.php?facture_id=' + identifiant;
		}
	}
	//-->
</script>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2" style="width: 1220px;">

	<div id="contenu_3" align="left" style="width: 952px;">

		<div id="titres">
			<span class="titre_1" style="width: 250px;">Facturation</span>
			<span class="ajouter" style="margin-right: 30px;"><a href="./modifier_facture.php">Modifier facture</a></span>
			<span class="ajouter" style="width: 180px; margin-right: 30px;"><a href="./modifier_email_facture.php">E-mail de la facture</a></span>
			<span class="ajouter" style="width: 120px; margin-right: 30px;"><a href="./exporter.php">Exporter</a></span>
			<span class="ajouter" style="width: 120px;"><a href="./ajouter.php">Ajouter</a></span>
		</div>
		<br clear="all">

		<?php 
		if($nb_factures==1){
			echo '<div id="ligne_compteur"><b>1</b> facture sélectionnée</div>';
		}elseif($nb_factures>1){
			echo '<div id="ligne_compteur"><b>'.$nb_factures.'</b> factures sélectionnées</div>';
		}
		?>

		<div id="bloc">

			<?php if($nb_factures!=0){ ?>

				<div id="ligne_entete">
					<div style="float: left; width: 100px;" title="Facture N°">N°</div>
					<div align="center" style="float: left; width: 70px; border-left: 1px solid #CCCCCC;" title="Date">DATE</div>
					<div style="float: left; width: 80px; padding-left: 10px; border-left: 1px solid #CCCCCC;" title="Package">PACKAGE</div>
					<div style="float: left; width: 180px; padding-left: 10px; border-left: 1px solid #CCCCCC;" title="Nom Prénom">NOM & PRÉNOM</div>
					<div align="center" style="float: left; width: 90px; border-left: 1px solid #CCCCCC;" title="Montant HT">MONTANT HT</div>
					<div align="center" style="float: left; width: 90px; border-left: 1px solid #CCCCCC;" title="Montant TTC">MONTANT TTC</div>
					<div align="center" style="float: left; width: 70px; border-left: 1px solid #CCCCCC;" title="Statut du paiement">PAIEMENT</div>
					<div align="center" style="float: left; width: 100px; border-left: 1px solid #CCCCCC;" title="Téléchargement de la Facture PDF">FACTURE PDF</div>
					<div align="center" style="float: left; width: 80px; border-left: 1px solid #CCCCCC;" title="Envoi par e-mail">ENVOI MAIL</div>
				</div>

				<?php 
				$facture_total_ht = 0;
				$facture_total_ttc = 0;

				for($facture_boucle=0; $facture_boucle<$nb_factures; $facture_boucle++){
					$resultat_facture = mysqli_fetch_array($requete_factures);
					$facture_id = $resultat_facture[0];
					$facture_date = $resultat_facture[1];
					$facture_numero = $resultat_facture[2];
					$facture_package = ucfirst($resultat_facture[3]);
					$joueur_id = $resultat_facture[4];
					$joueur_nom = strtoupper_max(decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture[5]))));
					$joueur_prenom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture[6])));
					$facture_prix_ht = $resultat_facture[7];
					$facture_prix_ttc = $resultat_facture[8];
					$facture_envoyee = $resultat_facture[9];
					$facture_payee = $resultat_facture[10];

					if(strlen(trim($joueur_nom))>17){ $joueur_nom = substr($joueur_nom, 0, 14).'...'; }

					while(strlen(trim($facture_numero)) < 3){
						$facture_numero = '0'.$facture_numero;
					}
					$facture_numero = 'PAB-20'.substr($facture_date, -2).'-'.$facture_numero;

					$facture_total_ht = $facture_total_ht + $facture_prix_ht;
					$facture_total_ttc = $facture_total_ttc + $facture_prix_ttc;

					$facture_prix_ht = number_format($facture_prix_ht, 2, ',', ' ').' &euro;';
					$facture_prix_ttc = number_format($facture_prix_ttc, 2, ',', ' ').' &euro;';

					if($facture_package=='Accompagnateur'){ $facture_package = 'Accomp.'; }
					if($facture_payee==0){ $facture_payee = '<span style="color:orange; font-size:11px;">EN COURS</span>'; }else{ $facture_payee = '<span style="color:green; font-size:11px; font-weight:bold;">PAYÉ</span>'; }
				?>

					<div id="ligne">
						<div style="float: left; width: 100px;" title="Facture N°"><a href="./modifier.php?facture_id=<?=$facture_id?>"><?=$facture_numero?></a></div>
						<div align="center" style="float: left; width: 70px; border-left: 1px solid #CCCCCC;" title="Package"><a href="./modifier.php?facture_id=<?=$facture_id?>"><?=$facture_date?></a></div>
						<?php if(strlen(trim($facture_package))!=0){ ?>
							<div style="float: left; width: 80px; padding-left: 10px; border-left: 1px solid #CCCCCC;" title="Package"><a href="./modifier.php?facture_id=<?=$facture_id?>"><?=$facture_package?></a></div>
						<?php }else{ ?>
							<div style="float: left; width: 80px; padding-left: 10px; border-left: 1px solid #CCCCCC;" title="Package">-</div>
						<?php } ?>
						<div style="float: left; width: 180px; padding-left: 10px; border-left: 1px solid #CCCCCC;text-overflow: ellipsis;white-space: nowrap;overflow: hidden;" title="Nom Prénom"><a href="./modifier.php?facture_id=<?=$facture_id?>"><?=$joueur_nom.' '.$joueur_prenom?></a></div>
						<div align="right" style="float: left; width: 78px; padding-right: 12px; border-left: 1px solid #CCCCCC;" title="Montant HT"><?=$facture_prix_ht?></div>
						<div align="right" style="float: left; width: 78px; padding-right: 12px; border-left: 1px solid #CCCCCC;" title="Montant TTC"><?=$facture_prix_ttc?></div>
						<div align="center" style="float: left; width: 70px; border-left: 1px solid #CCCCCC;" title="Statut"><?=$facture_payee?></div>
						<div align="center" style="float: left; width: 100px; border-left: 1px solid #CCCCCC;" title="Facture"><a href="./facture.php?facture_id=<?=$facture_id?>" target="_blank" style="font-size: 10px; color: #777777;">TÉLÉCHARGEZ</a></div>
						<div align="center" style="float: left; width: 80px; border-left: 1px solid #CCCCCC;" title="Facture"><a href="./envoyer.php?facture_id=<?=$facture_id?>" style="font-size: 10px; color: <?php if($facture_envoyee==1){ echo '#5CB341; font-weight: bold;'; }else{ echo '#777777'; } ?>"><?php if($facture_envoyee==1){ echo 'ENVOYÉE'; }else{ echo 'ENVOYEZ'; } ?></a></div>
						<div id="ligne_icone"><a href="./modifier.php?facture_id=<?=$facture_id?>" title="Modifier"><img src="<?=$admin_img?>picto_modifier.png" width="10" height="10"></a></div>
						<div id="ligne_icone"><a href="Javascript:void(0);" onclick="supprimer('<?=$facture_id?>', '<?=$facture_numero?> du <?=$facture_date?>');" title="Supprimer"><img src="<?=$admin_img?>picto_supprimer.png" width="10" height="10"></a></div>
					</div>

			<?php 
				}

				$facture_total_ht = number_format($facture_total_ht, 2, ',', ' ').' &euro;';
				$facture_total_ttc = number_format($facture_total_ttc, 2, ',', ' ').' &euro;';
			?>

				<div id="ligne">
					<div align="right" style="float: left; width: 443px; padding-right: 10px;"><b>TOTAL</b></div>
					<div align="right" style="float: left; width: 78px; padding-right: 12px; border-left: 1px solid #CCCCCC;" title="Montant total HT"><b><?=$facture_total_ht?></b></div>
					<div align="right" style="float: left; width: 78px; padding-right: 12px; border-left: 1px solid #CCCCCC;" title="Montant total TTC"><b><?=$facture_total_ttc?></b></div>
					<div style="float: left; width: 90px; border-left: 1px solid #CCCCCC;">&nbsp;</div>
				</div>

			<?php 
			}else{
				echo '<div id="ligne">aucune facture enregistrée</div>'."\n";
			}
			?>

		</div>

	</div>
	<br clear="all">

</div></div>


<?php include $general_path_relatif.'sources/pied_page.inc'; ?>

</body>
</html>
