<?php
require_once '../../../../lib/configuration.inc';
require_once '../../../libs/fpdf.php';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(5, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(7, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


define('ESPACE', chr(32));		// Remplace le caractère Espace (&nbsp;)


// Sélection de la compétition
$requete_competition = mysqli_query($connexion_mysql, 'SELECT competition_annee, competition_date_debut, competition_date_fin, competition_golfs FROM competitions WHERE competition_active=1 AND competition_archive=0 ORDER BY competition_annee DESC');
$nb_competitions = mysqli_num_rows($requete_competition);
if($nb_competitions!=0){
	$resultat_competition = mysqli_fetch_array($requete_competition);
	$competition_annee = $resultat_competition[0];
	$competition_date_debut = $resultat_competition[1];
	$competition_date_fin = $resultat_competition[2];
	$competition_golfs = explode(',', $resultat_competition[3]);
}else{
	header('Location: ../../../');
}

$tab_competition_date_debut = explode('-', $competition_date_debut);
$competition_date_debut_annee = $tab_competition_date_debut[0];
$competition_date_debut_mois = $tab_competition_date_debut[1];
$competition_date_debut_jour = $tab_competition_date_debut[2];

$competition_date_jour2 = date('Y-m-d', mktime(0, 0, 0, $competition_date_debut_mois, $competition_date_debut_jour+1, $competition_date_debut_annee));
$competition_date_jour3 = date('Y-m-d', mktime(0, 0, 0, $competition_date_debut_mois, $competition_date_debut_jour+2, $competition_date_debut_annee));
$competition_date_jour4 = date('Y-m-d', mktime(0, 0, 0, $competition_date_debut_mois, $competition_date_debut_jour+3, $competition_date_debut_annee));

$titre_complement_libelle = $sous_titre_libelle = $sous_titre_libelle_2 = '';

// Sélection de la date la plus grande
$requete_date_max = mysqli_query($connexion_mysql, 'SELECT MAX(planning_depart_date) FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id');
$nb_date_max = mysqli_num_rows($requete_date_max);
if($nb_date_max!=0){
	$resultat_date_max = mysqli_fetch_array($requete_date_max);
	$date_max = $resultat_date_max[0];
}

// Critères par défaut
if(!isset($critere_type_classement)){ $critere_type_classement = 'brut'; }
if(!isset($critere_dates)){ $critere_dates = array('cumul'); }else{ $critere_dates = explode(',', $critere_dates); }
if(strlen(trim($critere_groupes))!=0){ $critere_groupes = explode(',', $critere_groupes); }else{ unset($critere_groupes); }
if(strlen(trim($critere_golfs))!=0){ $critere_golfs = explode(',', $critere_golfs); }else{ unset($critere_golfs); }

if($critere_type_classement=='brut'){
	$ordre = 'score_joueur_brut_total';
	$ordre_9derniers = 'score_joueur_brut_retour';
	$ordre_6derniers = 'score_joueur_brut_total';
	$ordre_3derniers = 'score_joueur_brut_total';
}else{
	$ordre = 'score_joueur_net_total';
	$ordre_9derniers = 'score_joueur_net_retour';
	$ordre_6derniers = 'score_joueur_net_total';
	$ordre_3derniers = 'score_joueur_net_total';
}

if(isset($critere_dates) AND in_array('cumul', $critere_dates)==false){

	$where = ' AND (';
	foreach($critere_dates as $date_cle=>$date_selection){
		if($date_cle==0){ $date_debut = $date_selection; }elseif($date_cle==count($critere_date)-1){ $date_fin = $date_selection; }
		$where .= 'planning_depart_date="'.$date_selection.'" OR ';

		$tab_date_selection = explode('-', $date_selection);
		$tab_date_selection_libelle = $tab_date_selection[2].'/'.$tab_date_selection[1];

		$sous_titre_libelle .= $tab_date_selection_libelle.' - ';

		$date_max = $date_selection;

	}
	$where = substr($where, 0, -4).')';
	$sous_titre_libelle = substr($sous_titre_libelle, 0, -3);


}else{

	$critere_dates = array('cumul');

	// Sélection des dates enregistrées
	$requete_dates = mysqli_query($connexion_mysql, 'SELECT DISTINCT(planning_depart_date) FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id ORDER BY planning_depart_date');
	$nb_dates = mysqli_num_rows($requete_dates);
	if($nb_dates!=0){
		for($date_boucle=0; $date_boucle<$nb_dates; $date_boucle++){
			$resultat_date = mysqli_fetch_array($requete_dates);
			$date_competition = $resultat_date[0];

			$tab_date_competition = explode('-', $date_competition);
			$date_competition_libelle = $tab_date_competition[2].'/'.$tab_date_competition[1];

			$sous_titre_libelle .= $date_competition_libelle.ESPACE.' - '.ESPACE;

		}
	}

	$sous_titre_libelle = trim(substr(trim($sous_titre_libelle), 0, -1));

}

if(isset($critere_groupes)){

	if(count($critere_groupes)>1){
		$titre_complement_libelle .= ' - GROUPES ';
	}else{
		$titre_complement_libelle .= ' - GROUPE ';
	}

	$where .= ' AND (';
	foreach($critere_groupes as $groupe_cle=>$groupe_selection){
		$where .= 'planning_groupe="'.$groupe_selection.'" OR ';
		$titre_complement_libelle .= $groupe_selection.' ';
	}
	$where = substr($where, 0, -4).')';
	$titre_complement_libelle = trim($titre_complement_libelle);

}

if(isset($critere_golfs)){

	if(count($critere_golfs)>1){
		$sous_titre_libelle_2 .= 'GOLFS ';
	}else{
		$sous_titre_libelle_2 .= 'GOLF ';
	}

	$where .= ' AND (';
	foreach($critere_golfs as $golf_cle=>$golf_selection){
		$where .= 'golf_id='.$golf_selection.' OR ';

		// Sélection des dates enregistrées
		$requete_golf = mysqli_query($connexion_mysql, 'SELECT golf_nom FROM golfs WHERE golf_id="'.$golf_selection.'"');
		$resultat_golf = mysqli_fetch_array($requete_golf);
		$golf_nom = strtoupper_max($resultat_golf[0]);

		$sous_titre_libelle_2 .= $golf_nom.' - ';
	}
	$where = substr($where, 0, -4).')';
	$sous_titre_libelle_2 = trim(substr(trim($sous_titre_libelle_2), 0, -1));

}else{

	if(isset($critere_groupes) AND count($critere_groupes)==1 AND isset($critere_dates) AND in_array('cumul', $critere_dates)==false AND count($critere_dates)==1){

		// Sélection du nom du golf en fonction du groupe et de la date
		$requete_golf = mysqli_query($connexion_mysql, 'SELECT golf_nom FROM planning A INNER JOIN golfs B ON A.golf_id=B.golf_id WHERE planning_depart_date="'.$critere_dates[0].'" AND planning_groupe="'.$critere_groupes[0].'"');
		$resultat_golf = mysqli_fetch_array($requete_golf);
		$golf_nom = $resultat_golf[0];

		$sous_titre_libelle .= ESPACE.' - '.ESPACE.'Golf '.$golf_nom;

	}

}


// Sélection des joueurs enregistrés
$requete_scores = mysqli_query($connexion_mysql, 'SELECT A.equipe_id AS equipe_selection, SUM('.$ordre.'), planning_groupe FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE A.equipe_id!=""'.$where.' GROUP BY A.equipe_id ORDER BY SUM('.$ordre.'), (SELECT '.$ordre_9derniers.' FROM scores C INNER JOIN planning D ON C.planning_id=D.planning_id WHERE C.equipe_id=equipe_selection AND D.golf_id=1), (SELECT '.$ordre_6derniers.' FROM scores E INNER JOIN planning F ON E.planning_id=F.planning_id WHERE E.equipe_id=equipe_selection AND F.golf_id=1), (SELECT '.$ordre_3derniers.' FROM scores G INNER JOIN planning H ON G.planning_id=H.planning_id WHERE G.equipe_id=equipe_selection AND H.golf_id=1)');
$nb_scores = mysqli_num_rows($requete_scores);


/**************************************************************************************************************************************/

class PDF extends FPDF {

	function Header(){

		global $competition_annee;
		global $critere_type_classement;
		global $titre_complement_libelle;
		global $sous_titre_libelle;
		global $sous_titre_libelle_2;
/*
		$this->Image('../../../img/logo_proamcoteopale_noirblanc.png', 8, 8.4, -300);		// Image de l'entête

		$this->SetFont('Arial', 'B', 38);
		$this->SetTextColor(0,0,0);
		$this->Cell(24.5, 1, '', 0, 0, 'L', false);
		$this->Cell(30, 9, $competition_annee, 0, 0, 'L', false);

*/


		$this->Image('../biarritzlogo.png', 8, 3, -300);		// Image de l'entête

		$this->SetFont('Arial', 'B', 38);
		$this->SetTextColor(0,0,0);
		$this->Cell(24.5, 1, '', 0, 0, 'L', false);
		$this->Cell(15);
		$this->Cell(30, 30, $competition_annee, 0, 0, 'L', false);
		

		$this->SetFont('Arial', '', 20);
		$this->Cell(130, 9, 'Classement '.strtoupper($critere_type_classement).' '.$titre_complement_libelle, 0, 2, 'C', false);
		$this->SetFont('Arial', '', 16);
		$this->Cell(130, 8, $sous_titre_libelle, 0, 1, 'C', false);
		if(strlen(trim($sous_titre_libelle_2))!=0){
			$this->Cell(57, 1, '', 0, 0, 'L', false);
			$this->Cell(130, 8, $sous_titre_libelle_2, 0, 1, 'C', false);
		}else{
			$this->ln(8);
		}

		$this->SetFont('Arial', 'B', 8);
		$this->Cell(12, 8, '', 0, 0, 'L', false);
		$this->Cell(43, 8, 'PROFESSIONNEL', 0, 0, 'L', false);
		$this->Cell(104, 8, 'AMATEURS', 0, 0, 'L', false);
		$this->Cell(18, 8, 'GROUPE', 0, 0, 'L', false);
		$this->Cell(15, 8, 'CUMUL', 0, 1, 'L', false);

	}


	function Lignes($connexion_mysql, $requete_scores, $nb_scores){

		$this->SetLineWidth(0.5);

//		$score_numero_affichage = 0;

		for($score_boucle=0; $score_boucle<$nb_scores; $score_boucle++){
			$resultat_score = mysqli_fetch_array($requete_scores);
			$equipe_id = $resultat_score[0];
			$score_joueur_total = $resultat_score[1];
			$planning_groupe = $resultat_score[2];

//			if(!isset($score_joueur_total_precedent) OR (isset($score_joueur_total_precedent) AND $score_joueur_total_precedent!=$score_joueur_total)){
//				$score_numero_affichage = $score_numero_affichage + 1;
//			}

			$score_joueur_total_precedent = $score_joueur_total;

			$liste_joueurs = '';

			// Sélection l'équipe du joueur
			$requete_equipe = mysqli_query($connexion_mysql, 'SELECT equipe_nom FROM equipes_joueurs A INNER JOIN equipes B ON A.ej_equipe=B.equipe_id WHERE ej_equipe="'.$equipe_id.'"');
			$resultat_equipe = mysqli_fetch_array($requete_equipe);
			$equipe_nom = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_equipe[0]))));

			// Sélection des joueurs de l'équipe
			$requete_joueurs = mysqli_query($connexion_mysql, 'SELECT joueur_nom, joueur_prenom, joueur_handicap, joueur_profil FROM joueurs A INNER JOIN equipes_joueurs B ON A.joueur_id=B.ej_joueur WHERE ej_equipe="'.$equipe_id.'" AND joueur_profil<>"acc"');
			$nb_joueurs = mysqli_num_rows($requete_joueurs);
			if($nb_joueurs!=0){
				for($joueur_boucle=0; $joueur_boucle<$nb_joueurs; $joueur_boucle++){
					$resultat_joueur = mysqli_fetch_array($requete_joueurs);
					$joueur_nom = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[0]))));
					$joueur_prenom = utf8_decode(ucwords(strtolower(decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[1]))))));
					// $joueur_prenom = substr(decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[1]))), 0, 1).'.';
					$joueur_handicap = number_format($resultat_joueur[2], 1, ',', '');
					$joueur_profil = $resultat_joueur[3];

					// Permet de mettre la 1ere lettre en majuscule si le prénom est composé (avec -)
					if(preg_match('/-/', $joueur_prenom)==true){
						$joueur_prenom_tab = explode('-', $joueur_prenom);
						$joueur_prenom = '';
						foreach($joueur_prenom_tab as $joueur_prenom_morceau){
							$joueur_prenom .= ucwords(strtolower($joueur_prenom_morceau)).'-';
						}
						$joueur_prenom = substr($joueur_prenom, 0, -1);
					}

					$joueur_nom_prenom = $joueur_nom.' '.$joueur_prenom;
					if(strlen($joueur_nom_prenom)>20){  $joueur_nom_prenom = substr($joueur_nom_prenom, 0, 20).'.'; }

					if(substr($joueur_handicap, -2)==',0'){ $joueur_handicap = preg_replace('/,0/', '', $joueur_handicap); }

					if($joueur_profil=='am'){
						$liste_joueurs .= $joueur_nom_prenom.' ('.$joueur_handicap.')'.ESPACE.' - '.ESPACE;
					}elseif($joueur_profil=='pro'){
						$joueur_professionnel = $joueur_nom_prenom;
					}
				}
				$liste_joueurs = substr($liste_joueurs, 0, -3);
			}

			$this->SetFont('Arial', 'B', 10);
			$this->SetFillColor(241);
			$this->Cell(10, 8, $score_boucle+1, 'TB', 0, 'C', true);
			$this->SetFont('Arial', 'B', 9);
			$this->Cell(45, 8, ESPACE.ESPACE.$joueur_professionnel, 'TB', 0, 'L', false);
			$this->SetFont('Arial', '', 7);
			$this->Cell(105, 8, $liste_joueurs, 'TB', 0, 'L', false);
			$this->SetFont('Arial', '', 9);
			$this->Cell(15, 8, $planning_groupe, 'TB', 0, 'C', false);
			$this->SetFont('Arial', 'B', 13);
			$this->Cell(17, 8, $score_joueur_total, 'TB', 1, 'C', false);

		}

	}


	// Pied de page
	function Footer(){

		$this->SetXY(0, -10);															// Positionnement à 0 cm à gauche et à 1,5 cm du bas

		$this->SetFont('Arial', '', 9);
		$this->SetTextColor(0,0,0);
		$this->Cell(205, 4, $this->PageNo().' / {nb}', 0, 1, 'R', false);				// Numéro de page

	}

}

/**************************************************************************************************************************************/

// Instanciation de la classe dérivée
$pdf = new PDF();
$pdf->AliasNbPages();

$pdf->SetMargins(8, 10, 8);
$pdf->AddPage();

$pdf->Lignes($connexion_mysql, $requete_scores, $nb_scores);

$pdf->Output('Classement_cumulé_'.strtolower($critere_type_classement).'_'.$competition_date_debut_annee.'.pdf', 'I');
?>
