<?php



require_once '../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(6, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(3, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../');
	exit;
}




if(isset($action) AND $action=='rechercher'){

	$requete_where = 'WHERE ID<>""';
	$export_parametres = '';

	if(strlen(trim($recherche_motcle))!=0){
		$recherche_motcle = htmlentities($recherche_motcle, ENT_QUOTES);
		$requete_where .= ' AND (ID LIKE "%'.$recherche_motcle.'%" OR joueur_nom LIKE "%'.$recherche_motcle.'%" OR joueur_prenom LIKE "%'.$recherche_motcle.'%")';
		$export_parametres .= 'export_joueur_motcle='.$recherche_motcle.'&';
	}

	if($recherche_equipe!='0'){
		$requete_where .= ' AND ID IN (SELECT ej_joueur FROM equipes_joueurs WHERE ej_equipe="'.$recherche_equipe.'")';
		$export_parametres .= 'export_equipe='.$recherche_equipe.'&';
	}

	if((isset($critere_actif) AND $critere_actif==1) OR (isset($critere_inactif) AND $critere_inactif==1)){
		$requete_where .= ' AND (';
		if(isset($critere_actif) AND $critere_actif==1){
			$requete_where .= 'joueur_actif="1" OR ';
			$export_parametres .= 'export_joueur_actif=1&';
		}
		if(isset($critere_inactif) AND $critere_inactif==1){
			$requete_where .= 'joueur_actif="0" OR ';
			$export_parametres .= 'export_joueur_inactif=1&';
		}
		$requete_where = substr($requete_where, 0, -4).')';
	}

	if(isset($critere_langues) AND count($critere_langues)!=0){
		$requete_where .= ' AND (';
		foreach($critere_langues as $critere_langue){
			$requete_where .= 'joueur_langue="'.$critere_langue.'" OR ';
		}
		$requete_where = substr($requete_where, 0, -4).')';
		$export_parametres .= 'export_joueur_langues='.implode('|', $critere_langues).'&';
	}

	if($critere_equipe=='avec'){
		$requete_where .= ' AND ID IN (SELECT ej_joueur FROM equipes_joueurs)';
	}elseif($critere_equipe=='sans'){
		$requete_where .= ' AND ID NOT IN (SELECT ej_joueur FROM equipes_joueurs)';
	}
	$export_parametres .= 'export_joueur_equipe='.$critere_equipe.'&';

	if(isset($critere_profils) AND count($critere_profils)!=0){
		$requete_where .= ' AND (';
		foreach($critere_profils as $critere_profil){
			$requete_where .= 'joueur_profil="'.$critere_profil.'" OR ';
		}
		$requete_where = substr($requete_where, 0, -4).')';
		$export_parametres .= 'export_joueur_profils='.implode('|', $critere_profils).'&';
	}

	if($classement=='nom'){
		$requete_orderby = 'joueur_nom '.$ordre.', joueur_prenom, joueur_datetime_creation';
	}elseif($classement=='profil'){
		$requete_orderby = 'joueur_profil '.$ordre.', joueur_nom, joueur_prenom, joueur_datetime_creation';
	}elseif($classement=='equipe'){
		$requete_orderby = '(SELECT equipe_nom FROM equipes A INNER JOIN equipes_joueurs B ON A.equipe_id=B.ej_equipe WHERE B.ej_joueur=ID) '.$ordre.', joueur_profil DESC, joueur_nom, joueur_prenom, joueur_datetime_creation';
	}elseif($classement=='date'){
		$requete_orderby = 'joueur_datetime_creation '.$ordre.', joueur_nom, joueur_prenom';
	}elseif($classement=='statut'){
		$requete_orderby = 'joueur_actif '.$ordre.', joueur_nom, joueur_prenom';
	}
	$export_parametres .= 'classement='.$classement.'&ordre='.$ordre.'&';

	if(strlen(trim($export_parametres))!=0){
		$export_parametres = '?'.substr($export_parametres, 0, -1);
	}

} else {

	$requete_where = 'WHERE ID<>""';
	$requete_orderby = 'joueur_nom ASC, joueur_prenom';

	$export_parametres = '?classement=nom&ordre=ASC';

}

// Sélection des joueurs enregistrés
$requete_joueurs = mysqli_query($connexion_mysql, 'SELECT ID, hotel, prix, chambre_double, vue_piscine, qtte FROM hebergements');


$nb_joueurs = mysqli_num_rows($requete_joueurs);



?>



<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none">
</head>

<body>


<script language="Javascript">
	<!-- 
	function supprimer(identifiant){
		//resultat = confirm("Désirez-vous réellement supprimer le joueur ' " + nom + " ' ?");
		//if(resultat == true){
		window.location = './supprimer.php?ID=' + identifiant + '';
		//}
	}
	//-->
</script>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>



<div id="contenu_1"<?=$correction_contenu_1?>>
	<div id="contenu_2" style="width: 1200px;">
		<div id="contenu_3" align="left" style="width: 900px;">

			<div id="titres">
				<span class="titre_1" style="width: 504px;">Hébergements</span>
			
				<span class="ajouter" style="width: 90px;"><a href="./ajouter.php">Ajouter</a></span>
			</div>
			<br clear="all">


			<?php 
			if($nb_joueurs==1){
				echo '<div id="ligne_compteur"><b>1</b> joueur sélectionné</div>';
			}elseif($nb_joueurs>1){
				echo '<div id="ligne_compteur"><b>'.$nb_joueurs.'</b> joueurs sélectionnés</div>';
			}
			?>





			<div id="bloc">

				<?php if($nb_joueurs!=0){ ?>

					<div id="ligne_entete" style="display: flex;">
						<div style="flex:1;" title="Nom Prénom">ID</div>
						<div style="flex:1; padding-left: 10px; border-left: 1px solid #CCCCCC;" title="Profil">hotel</div>
						<div align="center" style="flex:1; border-left: 1px solid #CCCCCC;" title="Envoi par e-mail">prix</div>
						<div align="center" style="flex:1; border-left: 1px solid #CCCCCC;" title="Chambre double">chambre double</div>
						<div align="center" style="flex:1; border-left: 1px solid #CCCCCC;" title="Vue piscine">vue piscine</div>
						<div align="center" style="flex:1; border-left: 1px solid #CCCCCC;" title="qtte">quantité</div>
						<div align="center" style="flex:1; border-left: 1px solid #CCCCCC;" title="Supprimer">Supprimer</div>
					</div>


					<?php 
						for($joueur_boucle=0; $joueur_boucle<$nb_joueurs; $joueur_boucle++) {
							$resultat_joueur = mysqli_fetch_array($requete_joueurs);
							$ID = $resultat_joueur[0];
							$hotel = $resultat_joueur[1];
							$prix = $resultat_joueur[2];
							$chambre_double = $resultat_joueur[3];
							$vue_piscine = $resultat_joueur[4];
							$qtte = $resultat_joueur[5];


							if($joueur_admin==1){ $joueur_admin_libelle = ' (admin)'; }else{ $joueur_admin_libelle = ''; }

							if($hotel!='acc' AND $chambre!='-' AND $date1==0){ $chambre_css = ' color: orange;'; }else{ $chambre_css = ''; }
							if($joueur_actif==1){ $joueur_ligne_css = 'ligne'; }else{ $joueur_ligne_css = 'ligne_inactive'; }


							// Sélection l'équipe du joueur
							$requete_equipe = mysqli_query($connexion_mysql, 'SELECT equipe_id, equipe_nom FROM equipes_joueurs A INNER JOIN equipes B ON A.ej_equipe=B.equipe_id WHERE ej_joueur="'.$ID.'"');
							$nb_equipe = mysqli_num_rows($requete_equipe);
							if($nb_equipe!=0){
								$resultat_equipe = mysqli_fetch_array($requete_equipe);
								$equipe_id = $resultat_equipe[0];
								$equipe_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_equipe[1])));
							}else{
								$equipe_id = 0;
								$equipe_nom = '-';
							}

							if($hotel=='pro'){
								// Vérification du nombre de joueurs dans l'équipe du joueur sélectionné
								$requete_verif_equipe = mysqli_query($connexion_mysql, 'SELECT ej_id FROM equipes_joueurs WHERE ej_equipe="'.$equipe_id.'"');
								$nb_verif_equipe = mysqli_num_rows($requete_verif_equipe);
							}


							?>



							<div id="<?=$joueur_ligne_css?>" style="display:flex;">
								<div style="flex:1;" title="ID"><a href="./modifier.php?ID=<?=$ID?>"><?=$ID?></a></div>
								<div style="flex:1;padding-left: 10px; border-left: 1px solid #CCCCCC;" title="Hotel"><a href="./modifier.php?ID=<?=$ID?>"><?=$hotel?></a></div>
							
								<div align="center" style="flex:1; border-left: 1px solid #CCCCCC;" title="Prix"><?=$prix?></div>

								<div align="center" style="flex:1; border-left: 1px solid #CCCCCC;" title="Chambre double"><? if($chambre_double == 1){echo "oui";}else{echo "non";}?></div>

								<div align="center" style="flex:1; border-left: 1px solid #CCCCCC;" title="Vue piscine"><? if($vue_piscine == 1){echo "oui";}else{echo "non";}?></div>

								<div align="center" style="flex:1; border-left: 1px solid #CCCCCC;" title="Quantité"><? echo $qtte; ?></div>

								<div style="flex:1">

									<div id="ligne_icone"><a href="./modifier.php?ID=<?=$ID?>" title="Modifier"><img src="<?=$admin_img?>picto_modifier.png" width="10" height="10"></a></div>

									<div id="ligne_icone"><a href="Javascript:void(0);" onclick="supprimer('<?=$ID?>')" title="Supprimer"><img src="<?=$admin_img?>picto_supprimer.png" width="10" height="10"></a></div>

								</div>


							</div>



							<?php
						}

					}

					?>

			</div>



















		</div>
	</div>
</div>



</body>

</html>
