<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(8, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(13, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


if(isset($action) AND $action=='ajouter'){

	$sponsor_logo_temp = $_FILES['sponsor_logo']['tmp_name'];
	$sponsor_logo_name = $_FILES['sponsor_logo']['name'];
	$sponsor_logo_type = $_FILES['sponsor_logo']['type'];
	$sponsor_logo_size = $_FILES['sponsor_logo']['size'];

	/******************************/
	/**  Traitement des erreurs  **/
	/******************************/
	if(strlen(trim($sponsor_nom))==0){
		$erreur_message .= "- le nom est manquant<br>";
	}
	if(strlen(trim($sponsor_logo_name))==0){
		$erreur_message .= "- le logo est manquant<br>";
		$erreur_css[] = 'sponsor_logo';
	}elseif($fichier_selection_0=='ajouter_remplacer' AND strlen(trim($sponsor_logo_name))==0){
		$erreur_message .= "- le logo est manquant<br>";
		$erreur_css[] = 'sponsor_logo';
	}elseif($fichier_selection_0=='ajouter_remplacer' AND verification_image($sponsor_logo_type, $sponsor_logo_size, '500000')==false){
		$erreur_message .= "- le format ou le poids du logo est incorrect<br>";
		$erreur_css[] = 'sponsor_logo';
	}

	/******************************/
	/**  Traitement des données  **/
	/******************************/
	$sponsor_nom = htmlentities(ucfirst(trim($sponsor_nom)), ENT_QUOTES);
	if(!isset($sponsor_actif)){ $sponsor_actif = 0; }

	/****************************************/
	/**  Enregistrement des modifications  **/
	/****************************************/
	if($erreur_message==''){

		$sponsor_logo_paysage = array(200, '', 'largeur');
		$sponsor_logo_portrait = array('', 100, 'hauteur');

		// Chargement et redimensionnement
		if($fichier_selection_0=='ajouter_remplacer'){
			$sponsor_logo = chargement_fichier('ajouter', $sponsor_logo_temp, $sponsor_logo_name, $general_path.'/admin/', 'sponsors', '');
			$sponsor_logo = redimensionnement_image($sponsor_logo, $sponsor_logo, $general_path.'/admin/', 'sponsors', $sponsor_logo_paysage, $sponsor_logo_portrait);
		}else{
			$sponsor_logo = '';
		}

		// Requête d'insertion du sponsor
		$requete_insertion = mysqli_query($connexion_mysql, 'INSERT INTO sponsors (sponsor_nom, sponsor_logo, sponsor_classement, sponsor_actif) VALUES("'.$sponsor_nom.'", "'.$sponsor_logo.'", 100, "'.$sponsor_actif.'")');

		// Mise à jour du classement après ajout
		mise_a_jour_classement($connexion_mysql, 'sponsors', 'sponsor_id', 'sponsor_classement', '');

		header('Location: ./');
		exit;

	}else{
		$sponsor_nom = stripslashes($sponsor_nom);
	}

}


if(isset($erreur_message) AND $erreur_message==''){

	// Initialisation des champs
	$sponsor_actif = 1;
	$sponsor_nom = '';

}else{

	// Si le formulaire comporte des erreurs, alors traitement des données
	$sponsor_nom = stripslashes(trim($sponsor_nom));

}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<script type="text/javascript" src="<?=$admin_js?>scriptaculous/prototype.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>scriptaculous/scriptaculous.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>scriptaculous/prototip.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery-ui-personalized-1.6rc6.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none">
	<script type="text/javascript">
		jQuery.noConflict();
		document.observe('dom:loaded', function() {
			new Tip('colonne_logo', 'Formats acceptés : JPEG, GIF ou PNG<br>Poids maximum : 500 Ko<br>Largeur maximum : 200 pixels<br>Hauteur maximum : 100 pixels.<br>Redimenssionnement automatique.', {
				className: 'infobulle_information', title: 'informations', effect: 'appear', hook: { target: 'bottomMiddle', tip: 'topLeft'}
			});
		});
	</script>
</head>

<body>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2">

	<div id="contenu_3" align="left" style="width: 650px;">

		<div id="titres">
			<span class="titre_1"><a href="./">Sponsors</a> <span class="separateur">/</span> <span class="titre_2">Ajouter</span></span>
		</div>
		<br clear="all">

		<div id="bloc_bis">

			<?php if(isset($erreur_message) AND $erreur_message!=''){ ?>
				<div align="center"><div id="message_erreur" align="left"><b><?=$erreur_message_introduction.'</b><br>'.$erreur_message?></div></div>
			<?php } ?>

			<form name="ajouter" action="<?=$PHP_SELF?>" method="post" enctype="multipart/form-data">

				<input type="hidden" name="action" value="ajouter">
				<input type="hidden" id="fichier_selection_0" name="fichier_selection_0" value="<?=$fichier_selection_0?>">

				<div id="formulaire_ligne">
					<div id="formulaire_libelle">Activation</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="checkbox" name="sponsor_actif" value="1" <?php if($sponsor_actif==1){ echo 'checked'; } ?>></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Nom</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="sponsor_nom" value="<?=$sponsor_nom?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire"><span id="colonne_logo" class="formulaire_libelle_aide">Logo</span></div>
					<div id="formulaire_champ" style="width: 500px;">
			    	<div id="fichier_bloc_lien_ajouter"><img src="<?=$admin_img?>fleche_droite.png" width="5" height="5" style="margin-right: 5px;"><a href="Javascript:void(0);" id="fichier_lien_ajouter_0" onclick="slideMe('fichier_bloc_selection_0', 1, 'fichier_lien_ajouter_0', 'ajouter', 'annuler l\'ajout', 'inconnu', '_0'); return false;" class="fichier_bloc_lien">ajouter</a><br></div><br clear="all">
		    		<div id="fichier_bloc_selection_0" style="display: none;">Sélectionner :<br><input type="file" name="sponsor_logo"></div>
					</div>
					<br clear="all">
				</div>

				<div id="formulaire_boutons"><input type="image" src="<?=$admin_img?>btn_enregistrer.png" width="150" height="32" align="absmiddle" style="margin: 15px 5px 20px 0px;"> ou&nbsp; <a href="./" class="lien_annuler">annuler</a></div>

			</form>

		</div>

	</div>
	<br clear="all">

</div></div>

<?php include $general_path_relatif.'sources/pied_page.inc'; ?>

<script language="Javascript">
	<!-- 
	document.ajouter.sponsor_nom.focus();
	//-->
</script>

</body>
</html>
