<?php 
require_once '../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND in_array(7, $_SESSION['SessionADMIN_compte_acces_modules'])==false){
	header('Location: ../../');
	exit;
}


// Initialisation
$tab_groupes = array('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H');
$tab_nb_equipes_groupe = array();
$golf_precedent = '';
$tab_dates = array();
$tab_golfs = array();
$tab_dates_golfs = array();
$decalage = 0;


// Sélection de la dernière compétition enregistrée
$requete_competition = mysqli_query($connexion_mysql, 'SELECT competition_id, competition_date_debut, competition_heure_debut, competition_heure_fin, competition_golfs, competition_nb_groupes, competition_intervalle_departs FROM competitions ORDER BY competition_annee DESC LIMIT 1');
$resultat_competition = mysqli_fetch_array($requete_competition);
$competition_id = $resultat_competition[0];
$competition_date_debut = $resultat_competition[1];
$competition_heure_debut = $resultat_competition[2];
$competition_heure_fin = $resultat_competition[3];
$tab_golfs_origine = explode(',', $resultat_competition[4]);
$competition_nb_groupes = $resultat_competition[5];
$competition_intervalle_departs = $resultat_competition[6];

// Sélection des départs du calendrier de la dernière compétition
$requete_nb_equipes = mysqli_query($connexion_mysql, 'SELECT equipe_id FROM equipes WHERE equipe_active="1"');
$nb_equipes = mysqli_num_rows($requete_nb_equipes);


/**********************************************************************************************************/

// Répartition du nombre d'équipes par groupe
while(array_sum($tab_nb_equipes_groupe)<$nb_equipes){
	for($i=0; $i<$competition_nb_groupes; $i++) {
		if(array_sum($tab_nb_equipes_groupe)<$nb_equipes){
			$tab_nb_equipes_groupe[$i]++;
		}
	}
}

/**********************************************************************************************************/

foreach($tab_nb_equipes_groupe as $groupe_cle=>$nb_equipes_groupe){

	$tab_equipes[$tab_groupes[$groupe_cle]] = array();
	if(!isset($requete_start)){ $requete_start = 0; }

	// Sélection des équipes selon le nombre d'équipes par groupe
	$requete_equipes = mysqli_query($connexion_mysql, 'SELECT equipe_id FROM equipes WHERE equipe_active="1" LIMIT '.$requete_start.','.$nb_equipes_groupe);
	$nb_equipes = mysqli_num_rows($requete_equipes);
	for($equipe_boucle=0; $equipe_boucle<$nb_equipes; $equipe_boucle++){
		$resultat_equipe = mysqli_fetch_array($requete_equipes);
		$equipe_id = $resultat_equipe[0];

		array_push($tab_equipes[$tab_groupes[$groupe_cle]], $equipe_id);

	}

	$requete_start = $requete_start + $nb_equipes_groupe;
	shuffle($tab_equipes[$tab_groupes[$groupe_cle]]);

}

echo '<br><hr><br>';
echo '<pre>';

	print_r($tab_equipes);

echo '</pre>';

/***************************************************************************************************/

for($d=0; $d<10; $d++){

	foreach($tab_golfs_origine as $golf_cle=>$golf){

		$tab_competition_date = explode('-', $competition_date_debut);
		$date_depart = date("Y-m-d", mktime(0, 0, 0, $tab_competition_date[1], $tab_competition_date[2]+$golf_cle, $tab_competition_date[0]));
		$tab_date_temp = array('date'=>$date_depart);

		array_push($tab_dates, $tab_date_temp);

	}

}

echo '<br><hr><br>';
echo '<pre>';

print_r($tab_dates);

echo '</pre>';

/***************************************************************************************************/

for($g=0; $g<10; $g++){

	foreach($tab_golfs_origine as $golf_cle=>$golf){

		if($g==count($tab_golfs_origine) OR $g==(count($tab_golfs_origine)*2)){ $decalage = 0; }

		$golf_id = $tab_golfs_origine[$golf_cle+$decalage];

		if($golf_id=='' AND $golf_precedent==4){
			$golf_id = $tab_golfs_origine[0];
		}elseif($golf_id=='' AND $golf_precedent!=4){
			$golf_id = $tab_golfs_origine[$golf_precedent];
		}

		$tab_golfs_temp = array('golf'=>$golf_id);

		array_push($tab_golfs, $tab_golfs_temp);

		$golf_precedent = $golf_id;

	}

	$decalage++;

}

echo '<br><hr><br>';
echo '<pre>';

print_r($tab_golfs);

echo '</pre>';

/***************************************************************************************************/

for($dg=0; $dg<count($tab_dates); $dg++){

	$tab_date_golf_temp = array('date'=>$tab_dates[$dg]['date'], 'golf'=>$tab_golfs[$dg]['golf']);

	array_push($tab_dates_golfs, $tab_date_golf_temp);

}

echo '<br><hr><br>';
echo '<pre>';

print_r($tab_dates_golfs);

echo '</pre>';

/***************************************************************************************************/

echo '<br><hr><br>';
echo '<pre>';

echo "COMPETITION\tGROUPE\tEQUIPE\t\tGOLF\tDATE\n\n";

// Suppression du calendrier
$requete_suppression = mysqli_query($connexion_mysql, 'DELETE FROM planning');

// Défragmentation de la table
$requete_defragmentation_1 = mysqli_query($connexion_mysql, 'ALTER TABLE planning TYPE=InnoDB');
$requete_defragmentation_2 = mysqli_query($connexion_mysql, 'OPTIMIZE TABLE planning');

	$date_golf_compteur = 0;


for($gp=0; $gp<$competition_nb_groupes; $gp++){

	$groupe_lettre = $tab_groupes[$gp];

	$tab_dates_golfs_extrait = array_slice($tab_dates_golfs, $date_golf_compteur, count($tab_golfs_origine));

	for($dg=0; $dg<count($tab_golfs_origine); $dg++){

		$golf_id = $tab_dates_golfs_extrait[$dg]['golf'];
		$date = $tab_dates_golfs_extrait[$dg]['date'];

		foreach($tab_equipes[$groupe_lettre] as $equipe_cle=>$equipe_id){

			echo $competition_id."\t".$groupe_lettre."\t".$equipe_id."\t".$golf_id."\t".$date."\n";

			// Requête d'insertion
			$requete_insertion = mysqli_query($connexion_mysql, 'INSERT INTO planning (competition_id, planning_groupe, golf_id, equipe_id, planning_depart_date) VALUES("'.$competition_id.'", "'.$groupe_lettre.'", "'.$golf_id.'", "'.$equipe_id.'", "'.$date.'")');

		}

		$date_golf_compteur++;

		echo '<hr style="height: 1px; color: #999999;">';

	}

	echo '<hr style="height: 1px; color: #999999;">';

}

echo '</pre>';


// header('Location: ./');
exit;






/*
// Calcul de la date et heure du départ
$tab_competition_date_debut	= explode('-', $competition_date_debut);
$tab_competition_heure_debut = explode(':', $competition_heure_debut);

if(!isset($depart_heures) OR $equipe_precedente!=$equipe_id){
	$depart_heures = $tab_competition_heure_debut[0];
	$depart_minutes = $tab_competition_heure_debut[1];
}else{
	if($depart_minutes>=50){
		$depart_heures++;
		$depart_minutes = 0;
	}else{
		$depart_minutes = $depart_minutes + $competition_intervalle_departs;
	}
}
*/

?>
