<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(1, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(2, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<script type="text/javascript" src="<?=$admin_js?>scriptaculous/prototype.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>scriptaculous/scriptaculous.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>scriptaculous/prototip.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<script type="text/javascript">
		jQuery.noConflict();
		document.observe('dom:loaded', function() {
			new Tip('colonne_logo', 'Formats acceptés : JPEG, GIF ou PNG<br>Poids maximum : 500 Ko<br>Hauteur maximum : 55 pixels', {
				className: 'infobulle_information', title: 'informations', effect: 'appear', hook: { target: 'bottomMiddle', tip: 'topLeft'}
			});
		});
	</script>
	<meta name="robots" content="none">
</head>

<body>

<?php 
if(isset($action) AND $action=='modifier'){

	/******************************/
	/**  Traitement des erreurs  **/
	/******************************/
	if($rubrique_module==0){
		$erreur_message .= "- le module est manquant<br>";
	}
	if(strlen(trim($rubrique_libelle))==0){
		$erreur_message .= "- le libellé est manquant<br>";
	}
	if(strlen(trim($rubrique_repertoire))==0){
		$erreur_message .= "- le répertoire est manquant<br>";
	}

	/******************************/
	/**  Traitement des données  **/
	/******************************/
	$rubrique_libelle = htmlentities(ucfirst($rubrique_libelle), ENT_QUOTES);
	$rubrique_repertoire = htmlentities(strtolower($rubrique_repertoire), ENT_QUOTES);
	if(!isset($rubrique_activation)){ $rubrique_activation = 0; }

	/****************************************/
	/**  Enregistrement des modifications  **/
	/****************************************/
	if($erreur_message==''){

		// Requête de mise à jour du module
		$requete_maj = mysqli_query($connexion_mysql, 'UPDATE admin_rubriques SET rubrique_module="'.$rubrique_module.'", rubrique_libelle="'.$rubrique_libelle.'", rubrique_repertoire="'.$rubrique_repertoire.'", rubrique_activation="'.$rubrique_activation.'" WHERE rubrique_id='.$rubrique_id);

		echo '<meta http-equiv="refresh" content="0; url=./">';
		exit;

	}else{
		$module_libelle = stripslashes($module_libelle);
		$module_repertoire = stripslashes($module_repertoire);
	}

}


if(isset($erreur_message) AND $erreur_message==''){

	// Sélection de la rubrique
	$requete_rubrique = mysqli_query($connexion_mysql, 'SELECT rubrique_module, rubrique_libelle, rubrique_repertoire, rubrique_activation FROM admin_rubriques WHERE rubrique_id='.$rubrique_id);
	$resultat_rubrique = mysqli_fetch_array($requete_rubrique);
	$rubrique_module = $resultat_rubrique[0];
	$rubrique_libelle = ucfirst(decodage_apostrophe(html_entity_decode(stripslashes($resultat_rubrique[1]))));
	$rubrique_repertoire = $resultat_rubrique[2];
	$rubrique_activation = $resultat_rubrique[3];

}


include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2">

	<div id="contenu_3" align="left" style="width: 450px;">

		<div id="titres">
			<span class="titre_1"><a href="./">Arborescence</a> <span class="separateur">/</span> <span class="titre_2">Modifier</span></span>
		</div>
		<br clear="all">

		<div id="bloc_bis">

			<?php if(isset($erreur_message) AND $erreur_message!=''){ ?>
				<div align="center"><div id="message_erreur" align="left"><b><?=$erreur_message_introduction.'</b><br>'.$erreur_message?></div></div>
			<?php } ?>

			<form name="modifier" action="<?=$PHP_SELF?>" method="post" enctype="multipart/form-data">

				<input type="hidden" name="action" value="modifier">
				<input type="hidden" name="rubrique_id" value="<?=$rubrique_id?>">

				<div id="formulaire_ligne">
					<div id="formulaire_libelle">Activation</div>
					<div id="formulaire_champ"><input type="checkbox" name="rubrique_activation" value="1" <?php if($rubrique_activation==1){ echo 'checked'; } ?>></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Module</div>
					<div id="formulaire_champ">
						<select name="rubrique_module" size="1" class="select">
							<option value="0">Sélectionnez
							<?php 
							// Sélection des modules enregistrés
							$requete_modules = mysqli_query($connexion_mysql, 'SELECT module_id, module_libelle FROM admin_modules ORDER BY module_classement');
							$nb_modules = mysqli_num_rows($requete_modules);
							if($nb_modules!=0){
								for($module_boucle=0; $module_boucle<$nb_modules; $module_boucle++){
									$resultat_module = mysqli_fetch_array($requete_modules);
									$module_id = $resultat_module[0];
									$module_libelle = ucfirst(decodage_apostrophe(html_entity_decode(stripslashes($resultat_module[1]))));
									if($module_id==$rubrique_module){ $module_selection = 'selected'; }else{ $module_selection = ''; }

									echo '<option value="'.$module_id.'"'.$module_selection.'>'.$module_libelle."\n";
								}
							}
							?>
						</select>
					</div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Libellé</div>
					<div id="formulaire_champ"><input type="text" name="rubrique_libelle" value="<?=$rubrique_libelle?>" class="input" style="width: 270px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Répertoire</div>
					<div id="formulaire_champ"><input type="text" name="rubrique_repertoire" value="<?=$rubrique_repertoire?>" class="input" style="width: 270px;"></div>
					<br clear="all">
				</div>

				<div id="formulaire_boutons"><input type="image" src="<?=$admin_img?>btn_enregistrer.png" width="150" height="32" align="absmiddle" style="margin: 15px 5px 20px 0px;"> ou&nbsp; <a href="./" class="lien_annuler">annuler</a></div>

			</form>

		</div>

	</div>
	<br clear="all">

</div></div>

<?php include $general_path_relatif.'sources/pied_page.inc'; ?>


<script language="Javascript">
	<!-- 
	document.modifier.rubrique_libelle.focus();
	//-->
</script>

</body>
</html>
