<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(1, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(1, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


if(isset($action) AND $action=='modifier'){

	$compte_acces_modules = $compte_acces_rubriques = '';

	foreach($droits_acces as $droits_acces_cle=>$droits_acces_item){

		if(preg_match('/module_/', $droits_acces_item)==true){

			$compte_acces_modules .= preg_replace('/module_/', '', $droits_acces_item).',';

		}elseif(preg_match('/rubrique_/', $droits_acces_item)==true){

			$compte_acces_rubriques .= preg_replace('/rubrique_/', '', $droits_acces_item).',';

		}

	}

	$compte_acces_modules = substr($compte_acces_modules, 0, -1);
	$compte_acces_rubriques = substr($compte_acces_rubriques, 0, -1);

	// Requête de mise à jour du compte
	$requete_maj = mysqli_query($connexion_mysql, 'UPDATE admin_comptes SET compte_acces_modules="'.$compte_acces_modules.'", compte_acces_rubriques="'.$compte_acces_rubriques.'" WHERE compte_id="'.$compte_id.'"');

	header('Location: ./droits_acces.php?compte_id='.$compte_id);
	exit;

}else{

	// Requête de vérification si le module est dans les droits d'accès du compte
	$requete_droits_acces = mysqli_query($connexion_mysql, 'SELECT compte_acces_modules, compte_acces_rubriques FROM admin_comptes WHERE compte_id="'.$compte_id.'"');
	$resultat_droits_acces = mysqli_fetch_array($requete_droits_acces);
	$compte_acces_modules = explode(',', $resultat_droits_acces[0]);
	$compte_acces_rubriques = explode(',', $resultat_droits_acces[1]);

}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none">
</head>

<body>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2">

	<div id="contenu_3" align="left" style="width: 450px;">

		<div id="titres">
			<span class="titre_1"><a href="./">Comptes</a> <span class="separateur">/</span> <span class="titre_2">Modifier les droits d'accès</span></span>
		</div>
		<br clear="all">

		<div id="bloc">

			<form name="ajouter" action="<?=$PHP_SELF?>" method="post" enctype="multipart/form-data">

				<input type="hidden" name="action" value="modifier">
				<input type="hidden" name="compte_id" value="<?=$compte_id?>">

				<?php 
				// Sélection des modules enregistrés
				$requete_modules = mysqli_query($connexion_mysql, 'SELECT module_id, module_libelle, module_classement, module_activation FROM admin_modules ORDER BY module_classement');
				$nb_modules = mysqli_num_rows($requete_modules);
				if($nb_modules!=0){

					for($module_boucle=0; $module_boucle<$nb_modules; $module_boucle++){
						$resultat_module = mysqli_fetch_array($requete_modules);
						$module_id = $resultat_module[0];
						$module_libelle = strtoupper_max(decodage_apostrophe(html_entity_decode(stripslashes($resultat_module[1]))));
						$module_classement = $resultat_module[2];
						$module_activation = $resultat_module[3];

						// Vérification si le module est dans les droits d'accès du compte
						if(in_array($module_id, $compte_acces_modules)==true){ $module_selection = ' checked'; }else{ $module_selection = ''; }

						// Sélection des rubriques enregistrées du module
						$requete_rubriques = mysqli_query($connexion_mysql, 'SELECT rubrique_id, rubrique_libelle, rubrique_classement, rubrique_activation FROM admin_rubriques WHERE rubrique_module='.$module_id.' ORDER BY rubrique_classement');
						$nb_rubriques = mysqli_num_rows($requete_rubriques);
				?>

						<div id="ligne">
							<div style="float: left; width: 30px;"><input type="checkbox" id="module_<?=$module_id?>_id" name="droits_acces[]" value="module_<?=$module_id?>"<?=$module_selection?> style="margin-top: 5px;"></div>
							<div style="float: left; width: 235px;"><label for="module_<?=$module_id?>_id"><b><?=$module_libelle?></b></label></div>
						</div>

				<?php 
						if($nb_rubriques!=0){

							for($rubrique_boucle=0; $rubrique_boucle<$nb_rubriques; $rubrique_boucle++){
								$resultat_rubrique = mysqli_fetch_array($requete_rubriques);
								$rubrique_id = $resultat_rubrique[0];
								$rubrique_libelle = ucfirst(decodage_apostrophe(html_entity_decode(stripslashes($resultat_rubrique[1]))));
								$rubrique_classement = $resultat_rubrique[2];
								$rubrique_activation = $resultat_rubrique[3];

								// Vérification si la rubrique est dans les droits d'accès du compte
								if(in_array($rubrique_id, $compte_acces_rubriques)==true){ $rubrique_selection = ' checked'; }else{ $rubrique_selection = ''; }
				?>

								<div id="ligne_secondaire">
									<div style="float: left; width: 30px; padding-left: 26px;"><input type="checkbox" id="rubrique_<?=$rubrique_id?>_id" name="droits_acces[]" value="rubrique_<?=$rubrique_id?>"<?=$rubrique_selection?> style="margin-top: 5px;"></div>
									<div style="float: left; width: 215px;"><label for="rubrique_<?=$rubrique_id?>_id"><?=$rubrique_libelle?></label></div>
								</div>

				<?php 
							}

						}

					}

				}else{
					echo '<div id="ligne">aucun module disponible</div>'."\n";
				}
				?>

				<br>
				<div id="formulaire_boutons"><input type="image" src="<?=$admin_img?>btn_enregistrer.png" width="150" height="32" align="absmiddle" style="margin: 15px 5px 20px 0px;"> ou&nbsp; <a href="./" class="lien_annuler">annuler</a></div>

			</form>

		</div>

	</div>
	<br clear="all">

</div></div>

<?php include $general_path_relatif.'sources/pied_page.inc'; ?>

</body>
</html>
