<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(5, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(6, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}




// Sélection des scores
$requete_scores = mysqli_query($connexion_mysql, 'SELECT score_id, score_joueur_brut, score_joueur_net FROM scores');
$nb_scores = mysqli_num_rows($requete_scores);
if($nb_scores!=0){
	for($score_boucle=0; $score_boucle<$nb_scores; $score_boucle++){
		$resultat_score = mysqli_fetch_array($requete_scores);
		$score_id = $resultat_score[0];
		$resultat_brut = explode(',', $resultat_score[1]);
		$resultat_net = explode(',', $resultat_score[2]);


		/******************************/
		/**  Traitement des données  **/
		/******************************/

		$resultat_brut_6derniers = 0;
		$resultat_brut_3derniers = 0;

		for($b6=12; $b6<=17; $b6++){
			$resultat_brut_6derniers = $resultat_brut_6derniers + $resultat_brut[$b6];
		}

		for($b3=15; $b3<=17; $b3++){
			$resultat_brut_3derniers = $resultat_brut_3derniers + $resultat_brut[$b3];
		}

		$resultat_net_6derniers = 0;
		$resultat_net_3derniers = 0;

		for($n6=12; $n6<=17; $n6++){
			$resultat_net_6derniers = $resultat_net_6derniers + $resultat_net[$n6];
		}

		for($n3=15; $n3<=17; $n3++){
			$resultat_net_3derniers = $resultat_net_3derniers + $resultat_net[$n3];
		}


		$score_joueur_brut = implode(',', $resultat_brut);
		$score_joueur_net = implode(',', $resultat_net);


		/****************************************/
		/**  Enregistrement des modifications  **/
		/****************************************/

		echo 'UPDATE scores SET score_joueur_brut_6derniers='.$resultat_brut_6derniers.', score_joueur_brut_3derniers='.$resultat_brut_3derniers.', score_joueur_net_6derniers='.$resultat_net_6derniers.', score_joueur_net_3derniers='.$resultat_net_3derniers.' WHERE score_id='.$score_id.'<br><br>';

		// Requête de mise à jour des résultats
		$requete_maj = mysqli_query($connexion_mysql, 'UPDATE scores SET score_joueur_brut_6derniers='.$resultat_brut_6derniers.', score_joueur_brut_3derniers='.$resultat_brut_3derniers.', score_joueur_net_6derniers='.$resultat_net_6derniers.', score_joueur_net_3derniers='.$resultat_net_3derniers.' WHERE score_id='.$score_id);

	}
}
?>