<?php 
include '../lib/configuration.inc';


// Si le nom du joueur pro n'est pas connu, alors retour à l'inscription
if(!isset($_SESSION['SessionWeb_joueurs_acc'])){
	header('Location: ./inscription_1.php');
	exit;
}


if(isset($autorisation) AND $autorisation=='inscription'){

	if(!isset($_SESSION['SessionWeb_joueur']) OR (isset($_SESSION['SessionWeb_joueur']) AND strlen(trim($_SESSION['SessionWeb_joueur']['id']))==0)){
		if(strlen(trim($joueur_nom))==0 AND strlen(trim($joueur_email))==0){
			$formulaire_erreur[] = 'joueur';
		}
		if(strlen(trim($joueur_nom))!=0 AND strlen(trim($joueur_email))==0){
			$formulaire_erreur[] = 'joueur';
		}
		if(strlen(trim($joueur_nom))==0 AND strlen(trim($joueur_email))!=0){
			$formulaire_erreur[] = 'joueur';
		}

		if(count($formulaire_erreur)==0 OR (count($formulaire_erreur)!=0 AND in_array('joueur', $formulaire_erreur)==false)){
			// Vérification si l'adresse e-mail du joueur existe
			$requete_verification_joueur = mysqli_query($connexion_mysql, 'SELECT joueur_id, joueur_nom, joueur_prenom FROM joueurs WHERE joueur_email="'.$joueur_email.'"');
			$nb_verification_joueur = mysqli_num_rows($requete_verification_joueur);
			if($nb_verification_joueur==0){
				$formulaire_erreur[] = 'joueur_inconnu';
			}else{
				$resultat_verification_joueur = mysqli_fetch_array($requete_verification_joueur);
				$joueur_id = $resultat_verification_joueur[0];
				$joueur_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_verification_joueur[1])));
				$joueur_prenom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_verification_joueur[2])));
			}
		}
	}elseif(isset($etape_suivante)){
		header('Location: ./inscription_6_acc.php');		// Redirection vers la 6e page d'inscription (choix du package)
		exit;
	}

	if(count($formulaire_erreur)==0){

		// Traitement des informations pour enregistrement en base de données
		$joueur_nom = htmlentities(strtoupper_max(stripslashes($joueur_nom)), ENT_QUOTES);
		$joueur_prenom = preg_replace('/-/', ' ', $joueur_prenom);
		$joueur_prenom = htmlentities(ucwords(strtolower_max(stripslashes($joueur_prenom))), ENT_QUOTES);
		$joueur_email = strtolower($joueur_email);

		// Enregistrement en session du joueur
		if(strlen(trim($joueur_id))!=0){
			$_SESSION['SessionWeb_joueur']['id'] = $joueur_id;
			$_SESSION['SessionWeb_joueur']['nom'] = $joueur_nom;
			$_SESSION['SessionWeb_joueur']['prenom'] = $joueur_prenom;
			$_SESSION['SessionWeb_joueur']['email'] = $joueur_email;
		}

	}else{
		// Traitement d'affichage en cas d'erreur dans le formulaire
		$joueur_nom = stripslashes($joueur_nom);
		$joueur_email = stripslashes($joueur_email);
	}

}


if(!isset($autorisation) OR (isset($autorisation) AND $autorisation!='inscription')){

	// Valeurs par défaut lorsque le formulaire est vierge
	$joueur_nom = '';
	$joueur_email = '';

}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="<?=$_SESSION['SessionWeb_langue']?>" xml:lang="<?=strtolower($_SESSION['SessionWeb_langue'])?>">
<head>
	<title><?=$txt_page_titre?></title>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=8">
	<meta name="language" content="<?=strtolower($_SESSION['SessionWeb_langue'])?>">
	<meta name="robots" content="index, follow">
	<link rel="shortcut icon" type="image/x-icon" href="/favicon.ico">
	<link rel="shortcut icon" href="/favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$web_commun?>commun.css">
</head>

<body scroll="auto">

<div id="page" align="center">

	<div id="contenu">

		<?php include './commun/entete.inc'; ?>

		<div id="formulaire">

			<form action="<?=$REQUEST_URI?>" method="post">

				<input type="hidden" name="autorisation" value="inscription">

				<h1><?=$txt_acc_etape3_titre?></h1>

				<div class="separateur"></div>

				<?php if(!isset($_SESSION['SessionWeb_joueur']) OR (isset($_SESSION['SessionWeb_joueur']) AND strlen(trim($_SESSION['SessionWeb_joueur']['id']))==0)){ ?>

					<b><?=$txt_acc_etape3_saisir_nom_prenom_email?></b><br><br>

					<div class="colonne_gauche" style="width: 110px; color: #1EA2B7;"><?=$txt_acc_etape_3_nom_prenom?></div>
					<div class="colonne_droite" style="width: 220px;"><input type="text" name="joueur_nom" value="<?=$joueur_nom?>" style="width: 170px;"></div>
					<div class="colonne_gauche" style="width: 60px; color: #1EA2B7;"><?=$txt_acc_etape_3_email?></div>
					<div class="colonne_droite" style="width: 200px;"><input type="text" name="joueur_email" value="<?=$joueur_email?>" style="width: 170px;"></div>
					<?php if(count($formulaire_erreur)!=0 AND in_array('joueur', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_acc_etape_3_joueur_incorrect.'</div>'; }elseif(count($formulaire_erreur)!=0 AND in_array('joueur_inconnu', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_acc_etape_3_joueur_inconnu.'</div>'; } ?>
					<br clear="all">

				<?php }else{ ?>

					<b><?=$txt_acc_etape_3_joueur_accompagne?></b>&nbsp; <?=$_SESSION['SessionWeb_joueur']['nom'].' '.$_SESSION['SessionWeb_joueur']['prenom']?><br><br>

				<?php } ?>

				<?php 
				echo '<div class="separateur"></div>'."\n";

				echo '<b>'.$txt_acc_etape_3_vous.'</b>&nbsp; '.$_SESSION['SessionWeb_joueurs_acc'][0]['nom'].' '.$_SESSION['SessionWeb_joueurs_acc'][0]['prenom'].'&nbsp;&nbsp;&nbsp; <span style="color: #189DB3; font-size: 11px;">[&nbsp; <a href="./inscription_5.php?jacc=0">'.$txt_modifier.'</a> &nbsp;]</span><br><br>';

				echo '<div class="separateur"></div>'."\n";

				$jacc = 1;

				if(isset($_SESSION['SessionWeb_joueurs_acc']) AND count($_SESSION['SessionWeb_joueurs_acc'])>=2){

					echo '<b>'.$txt_acc_etape3_liste_autres_accompagnateurs.'</b><br><br>'."\n";

					echo '<ul style="margin-top: 0px;">'."\n";

						$jacc = 0;
						foreach($_SESSION['SessionWeb_joueurs_acc'] as $joueur_acc_cle=>$joueur_acc){
							if($joueur_acc_cle!=0){
								echo '<li style="padding-bottom: 10px;">'.$joueur_acc['nom'].' '.$joueur_acc['prenom'].'&nbsp;&nbsp;&nbsp; <span style="color: #189DB3; font-size: 11px;">[&nbsp; <a href="./inscription_5.php?jacc='.$joueur_acc_cle.'">'.$txt_modifier.'</a> &nbsp;|&nbsp; <a href="./inscription_suppression_joueur.php?joueur_profil=acc&joueur_cle='.$joueur_acc_cle.'">'.$txt_supprimer.'</a> ]</span></li>';
							}							
							$jacc++;
						}

					echo '</ul>'."\n";

					echo '<br>'."\n";

				}
				?>

				<?=$txt_acc_etape3_inscrire_nouvel_accompagnateur?> <a href="./inscription_5.php?jacc=<?=$jacc?>"><?=$txt_acc_etape3_completez_fichier_inscription?></a>.<br><br>

				<div class="separateur"></div>

				<div style="float: left; width: 200px;"><input type="button" value="<?=$txt_bouton_annuler_inscription?>" onclick="window.location='./inscription_annulation.php';" class="bouton_annuler"></div>
				<?php if(!isset($_SESSION['SessionWeb_joueur']) OR (isset($_SESSION['SessionWeb_joueur']) AND strlen(trim($_SESSION['SessionWeb_joueur']['id']))==0)){ ?>				
					<div align="right" style="margin-right: 130px;"><input type="submit" value="<?=$txt_acc_etape3_bouton_valider_joueur?>"></div>
				<?php }else{ ?>
					<div align="right" style="margin-right: 130px;"><input type="submit" name="etape_suivante" value="<?=$txt_bouton_etape_suivante?>"></div>
				<?php } ?>

			</form>

		</div>

	</div>

</div>

</body>
</html>
