<?php 
require_once '../lib/configuration.inc';

if(isset($action) AND $action=='authentification'){

	if(strlen(trim($compte_nom_utilisateur))==0){
		$erreur_message .= "Le nom d'utilisateur est manquant.<br>";
		$erreur_css[] = 'compte_nom_utilisateur';
	}
	if(strlen(trim($compte_mot_passe))==0){
		$erreur_message .= "Le mot de passe est manquant.<br>";
		$erreur_css[] = 'compte_mot_passe';
	}

	if(strlen($erreur_message)==0){

		// Suppression des caractères inutiles en début et fin de chaîne
		$compte_nom_utilisateur = trim($compte_nom_utilisateur);
		$compte_mot_passe = trim($compte_mot_passe);

		// Vérification des paramètres de connexion
		$compte_identification = admin_identification($connexion_mysql, $compte_nom_utilisateur, $compte_mot_passe);

		// Si les paramètres de connexion sont correctes, alors la connexion est autorisée et redirection automatique vers l'interface
		if($compte_identification== true){
			header('Location: ./');
			exit;
		} 
	}

}elseif(isset($action) AND $action=='motdepasse_validation'){

	if(strlen(trim($compte_email))==0){
		$erreur_message .= "L'adresse e-mail est manquante.";
		$erreur_css[] = 'compte_email';
	}

	if(strlen($erreur_message)==0){

		// Vérification si l'adresse e-mail existe et récupération des paramètres d'accès
		$compte_parametres = admin_parametres_acces($connexion_mysql, $compte_email);

		if($compte_parametres==true){

			// Récupération du template de l'e-mailing
			$emailing_contenu_vierge = @join('', @file($general_path.'/admin/sources/emailing.htm'));

			// Paramètres pour l'envoi
			$emailing_expediteur_nom = mb_encode_mimeheader('Pro Am Agadir');
			$emailing_expediteur_email = $admin_email_info;
			$emailing_expediteur_domaine = 'proamdecotedopale.com';
			$emailing_sujet = mb_encode_mimeheader('[ Pro Am Agadir ]  Votre mot de passe oublié');

			$cle = substr($compte_nom_utilisateur, 2, 4);
			$lien_remplacement_motdepasse = $admin_domaine.'motdepasse_oublie.php?k='.$cle.'&c='.$compte_id;

			$emailing_titre = 'votre mot de passe oublié';

			$emailing_message  = "Bonjour,<br><br>\n\n";
			$emailing_message .= "Vous avez demandé à changer votre mot de passe pour accéder à l'outil d'administration<br>de l'application <i>« Pro Am d'Agadir »</i>.<br><br>\n\n";
			$emailing_message .= "Votre nom d'utilisateur est :&nbsp; <b>".$compte_nom_utilisateur."</b><br><br>\n\n";
			$emailing_message .= "Pour modifier votre mot de passe :&nbsp; <a href=\"".$lien_remplacement_motdepasse."\" target=\"_blank\"><b>cliquez ici</b></a><br><br><br>\n\n";
			$emailing_message .= "Cordialement.<br>\n";

			// Traitement pour insertion du contenu
			$emailing_contenu = preg_replace("/{TITRE}/", $emailing_titre, $emailing_contenu_vierge);
			$emailing_contenu = preg_replace("/{TEXTE}/", $emailing_message, $emailing_contenu);
			$emailing_contenu = preg_replace("/{IMG}/", $admin_domaine.'img/', $emailing_contenu);

			// Construction de l'entete de l'e-mailing
			$emailing_entete  = "MIME-Version: 1.0\r\n";
			$emailing_entete .= "Content-type: text/html; charset=UTF-8\r\n";
			$emailing_entete .= "From: ".$emailing_expediteur_nom." <".$emailing_expediteur_email.">\r\n";
			$emailing_entete .= "Reply-To: <".$emailing_expediteur_email.">\r\n";
			$emailing_entete .= "Return-Path: <".$emailing_expediteur_email.">\r\n";
			$emailing_entete .= "Message-ID: <".time().rand(1,1000)."@".$emailing_expediteur_domaine.">\r\n";
			$emailing_entete .= "Sender: <".$emailing_expediteur_email.">\r\n";
			$emailing_entete .= "X-Mailer: PHP v".phpversion()."\r\n";
			$emailing_entete .= "X-Sender: ".$emailing_expediteur_email."\r\n";
			$emailing_entete .= "X-auth-smtp-user: ".$emailing_expediteur_email."\r\n";
			$emailing_entete .= "X-abuse-contact: abuse@".$emailing_expediteur_domaine;
			$emailing_entete_plus = "-f ".$emailing_expediteur_email;

			// Envoi de la confirmation par e-mail
			mail($compte_email, $emailing_sujet, $emailing_contenu, $emailing_entete, $emailing_entete_plus);

			$confirmation_message = "Un message vous a été envoyé à votre adresse e-mail,<br>veuillez cliquer sur le lien dans celui-ci pour remplacer votre mot de passe.";

		}

	}

}


if(isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: /');
	exit;
}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_authentification?>">
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<meta name="robots" content="none">
</head>

<body bgcolor="#EDEDE5">

<?php include 'sources/entete.inc'; ?>

<div id="contenu_1" align="center">
	<div id="contenu_2">

		<div id="authentification_box" align="left">

			<?php if(isset($action) AND ($action=='motdepasse' OR $action=='motdepasse_validation')){ ?>

				<span class="titre">mot de passe oublié</span><br><br>

				<?php 
				if(isset($erreur_message) AND strlen($erreur_message)!=0){
					echo '<div align="center"><div id="authentification_erreur" align="left">'.$erreur_message.'</div></div>'."\n";
				}elseif(isset($confirmation_message) AND strlen($confirmation_message)!=0){
					echo '<div align="center"><div id="authentification_confirmation" align="center">'.$confirmation_message.'</div></div>'."\n";
				}
				?>

				<form name="motdepasse" action="<?=$PHP_SELF?>" method="post">

					<input type="hidden" name="action" value="motdepasse_validation">

					<table width="550" border="0" cellpadding="0" cellspacing="0">
						<tr><td colspan="2"><img src="<?=$admin_img?>p.gif" width="1" height="20"></td></tr>
						<tr>
							<td align="right" style="padding-right: 20px;">Adresse E-mail</td>
							<td width="340"><input type="text" name="compte_email" value="<?php if(isset($compte_email)){ echo $compte_email; } ?>" class="input" style="width: 300px;"></td>
						</tr>
						<tr><td colspan="2"><img src="<?=$admin_img?>p.gif" width="1" height="20"></td></tr>
						<tr>
							<td>&nbsp;</td>
							<td width="340"><input type="image" src="<?=$admin_img?>btn_valider.png" width="123" height="40" border="0" class="input_bouton"></td>
						</tr>
						<tr><td colspan="2"><img src="<?=$admin_img?>p.gif" width="1" height="10"></td></tr>
						<tr><td colspan="2"><a href="<?=$PHP_SELF?>">retour à l'identification</a></td></tr>
					</table>

				</form>

			<?php }else{ ?>

				<span class="titre">identifiez-vous</span><br><br>

				<?php 
				if(isset($erreur_message) AND strlen($erreur_message)!=0){
					echo '<div align="center"><div id="authentification_erreur" align="left">'.$erreur_message.'</div></div>'."\n";
				}
				?>

				<form name="authentification" action="<?=$PHP_SELF?>" method="post">

					<input type="hidden" name="action" value="authentification">
					<input type="hidden" name="c" value="<?=$c?>">

					<table width="550" border="0" cellpadding="0" cellspacing="0">
						<tr>
							<td align="right" style="padding-right: 20px;">Nom d'utilisateur</td>
							<td width="340"><input type="text" name="compte_nom_utilisateur" value="<?php if(isset($compte_nom_utilisateur)){ echo $compte_nom_utilisateur; } ?>" tabindex="1" class="input" style="width: 300px;"></td>
						</tr>
						<tr><td colspan="2"><img src="<?=$admin_img?>p.gif" width="1" height="20"></td></tr>
						<tr>
							<td align="right" style="padding-right: 20px;">
								Mot de passe<br>
								<img src="<?=$admin_img?>p.gif" width="1" height="5"><br>
								<a href="<?=$PHP_SELF?>?action=motdepasse">vous l'avez oublié ?</a>
							</td>
							<td><input type="password" name="compte_mot_passe" tabindex="2" class="input" style="width: 300px;"></td>
						</tr>
						<tr><td colspan="2"><img src="<?=$admin_img?>p.gif" width="1" height="20"></td></tr>
						<tr>
							<td>&nbsp;</td>
							<td width="340"><input type="image" src="<?=$admin_img?>btn_se-connecter.png" width="175" height="40" border="0" tabindex="3" class="input_bouton"></td>
						</tr>
					</table>

				</form>

			<?php } ?>

		</div>

	</div>
</div>

<?php include 'sources/pied_page.inc'; ?>


<script language="Javascript">
	<!-- 
	<?php 
	if(isset($action) AND ($action=='motdepasse' OR $action=='motdepasse_validation')){
		echo "document.motdepasse.compte_email.focus();\n";
	}else{
		if(isset($erreur_css) AND in_array('compte_nom_utilisateur', $erreur_css)){
			echo "document.authentification.compte_nom_utilisateur.focus();\n";
		}elseif(isset($erreur_css) AND in_array('compte_mot_passe', $erreur_css)){
			echo "document.authentification.compte_mot_passe.focus();\n";
		}else{
			echo "document.authentification.compte_nom_utilisateur.focus();\n";
		}
	}
	?>
	//-->
</script>

</body>
</html>
