<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(6, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(5, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


if(isset($action) AND $action=='modifier'){

	/******************************/
	/**  Traitement des erreurs  **/
	/******************************/
	if(strlen(trim($texte_facture_objet_FR))==0){
		$erreur_message .= "- l'objet FR est manquant<br>";
	}
	if(strlen(trim($texte_facture_message_FR))==0){
		$erreur_message .= "- le message FR est manquant<br>";
	}
	if(strlen(trim($texte_facture_objet_EN))==0){
		$erreur_message .= "- l'objet EN est manquant<br>";
	}
	if(strlen(trim($texte_facture_message_EN))==0){
		$erreur_message .= "- le message EN est manquant<br>";
	}

	/******************************/
	/**  Traitement des données  **/
	/******************************/
	$texte_facture_objet_FR = htmlentities($texte_facture_objet_FR, ENT_QUOTES);
	$texte_facture_message_FR = htmlentities($texte_facture_message_FR, ENT_QUOTES);
	$texte_facture_objet_EN = htmlentities($texte_facture_objet_EN, ENT_QUOTES);
	$texte_facture_message_EN = htmlentities($texte_facture_message_EN, ENT_QUOTES);

	/****************************************/
	/**  Enregistrement des modifications  **/
	/****************************************/
	if($erreur_message==''){


		// Requête de mise à jour des textes
		$requete_maj = mysqli_query($connexion_mysql, 'UPDATE parametres SET texte_facture_objet_FR="'.$texte_facture_objet_FR.'", texte_facture_message_FR="'.$texte_facture_message_FR.'", texte_facture_objet_EN="'.$texte_facture_objet_EN.'", texte_facture_message_EN="'.$texte_facture_message_EN.'"');

		$contenu_modifie = 1;

	}

}


if((isset($erreur_message) AND $erreur_message=='') OR (isset($contenu_modifie) AND $contenu_modifie==1)){

	// Sélection de la facture
	$requete_texte = mysqli_query($connexion_mysql, 'SELECT texte_facture_objet_FR, texte_facture_message_FR, texte_facture_objet_EN, texte_facture_message_EN FROM parametres');
	$resultat_texte = mysqli_fetch_array($requete_texte);
	$texte_facture_objet_FR = decodage_apostrophe(html_entity_decode(stripslashes($resultat_texte[0])));
	$texte_facture_message_FR = decodage_apostrophe(html_entity_decode(stripslashes($resultat_texte[1])));
	$texte_facture_objet_EN = decodage_apostrophe(html_entity_decode(stripslashes($resultat_texte[2])));
	$texte_facture_message_EN = decodage_apostrophe(html_entity_decode(stripslashes($resultat_texte[3])));

}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<script type="text/javascript" src="<?=$admin_js?>scriptaculous/prototype.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>scriptaculous/scriptaculous.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>scriptaculous/prototip.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery-ui-personalized-1.6rc6.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none">
</head>

<body>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2">

	<div id="contenu_3" align="left" style="width: 650px;">

		<div id="titres">
			<span class="titre_1"><a href="./">Facturation</a> <span class="separateur">/</span> <span class="titre_2">Modifier le contenu de l'e-mail facturation</span></span>
		</div>
		<br clear="all">

		<div id="bloc_bis">

			<?php if(isset($erreur_message) AND $erreur_message!=''){ ?>
				<div align="center"><div id="message_erreur" align="left"><b><?=$erreur_message_introduction.'</b><br>'.$erreur_message?></div></div>
			<?php } ?>

			<?php if(isset($contenu_modifie) AND $contenu_modifie==1){ ?>
				<div align="center"><div id="message_confirmation" style="color: green;"><b>Les textes ont été mis à jour.</b><br></div></div>
				<div id="formulaire_boutons" style="text-align: center;"><a href="./" class="lien_annuler">retour à la liste</a></div>
			<?php } ?>

			<form name="modifier" action="<?=$PHP_SELF?>" method="post" enctype="multipart/form-data">

				<input type="hidden" name="action" value="modifier">

				<div id="formulaire_ligne_intertitre">VERSION FRANCAISE</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Objet</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="texte_facture_objet_FR" value="<?=$texte_facture_objet_FR?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Texte</div>
					<div id="formulaire_champ" style="width: 500px;"><textarea name="texte_facture_message_FR" class="textarea" style="width: 470px; height: 550px; overflow: auto;"><?=$texte_facture_message_FR?></textarea></div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne_intertitre">VERSION ANGLAISE</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Objet</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="texte_facture_objet_EN" value="<?=$texte_facture_objet_EN?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Texte</div>
					<div id="formulaire_champ" style="width: 500px;"><textarea name="texte_facture_message_EN" class="textarea" style="width: 470px; height: 550px; overflow: auto;"><?=$texte_facture_message_EN?></textarea></div>
					<br clear="all">
				</div>

				<div id="formulaire_boutons"><input type="image" src="<?=$admin_img?>btn_valider.png" width="123" height="40" align="absmiddle" style="margin: 15px 5px 20px 0px;"> ou&nbsp; <a href="./" class="lien_annuler">annuler</a></div>

			</form>

		</div>

	</div>
	<br clear="all">

</div></div>

<?php include $general_path_relatif.'sources/pied_page.inc'; ?>

<script language="Javascript">
	<!-- 
	document.modifier.texte_facture_objet_FR.focus();
	//-->
</script>

</body>
</html>
