<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(6, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(5, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


$contenu_excel  = "<html>\n";
$contenu_excel .= "<head>\n";
	$contenu_excel .= "<meta http-equiv=Content-Type content='text/html; charset=UTF-8'>\n";
	$contenu_excel .= "<style>\n";
		$contenu_excel .= ".tableau_1 { font-family:arial; color:black; font-size:14.0pt; font-weight:700; text-decoration:underline; text-underline-style:single; text-align:left; vertical-align:middle; background:white; }\n";
		$contenu_excel .= ".tableau_2 { font-family:arial; color:black; font-size:12.0pt; font-weight:700; text-underline-style:single; text-align:left; vertical-align:middle; background:white; }\n";
		$contenu_excel .= ".colonnes_titre { font-family:arial; color:black; font-size:10.0pt; font-weight:700; text-underline-style:single; text-align:center; vertical-align:middle; background:white; border: 1px solid black; }\n";
		$contenu_excel .= ".cellules_standard_1 { font-family:arial; color:black; font-size:10.0pt; font-weight:200; text-underline-style:single; text-align:center; vertical-align:middle; background:white; border: 1px solid black; }\n";
		$contenu_excel .= ".cellules_standard_2 { font-family:arial; color:black; font-size:10.0pt; font-weight:200; text-underline-style:single; text-align:left; vertical-align:middle; background:white; border: 1px solid black; }\n";
	$contenu_excel .= "</style>\n";
$contenu_excel .= "</head>\n";
$contenu_excel .= "<body>\n\n";

$contenu_excel .= "<table width=1940 border=0 cellpadding=0 cellspacing=0 style='border-collapse: collapse;table-layout:fixed'>\n";
	$contenu_excel .= "<col width=120>\n";				// Colonne du numéro de facture
	$contenu_excel .= "<col width=80>\n";				// Colonne de la date
	$contenu_excel .= "<col width=100>\n";				// Colonne du package
	$contenu_excel .= "<col width=200>\n";				// Colonne du nom / prénom
	$contenu_excel .= "<col width=250>\n";				// Colonne de la société
	$contenu_excel .= "<col width=200>\n";				// Colonne de l'adresse
	$contenu_excel .= "<col width=200>\n";				// Colonne de l'adresse suite
	$contenu_excel .= "<col width=100>\n";				// Colonne du code postal
	$contenu_excel .= "<col width=200>\n";				// Colonne de la ville
	$contenu_excel .= "<col width=60>\n";				// Colonne du pays
	$contenu_excel .= "<col width=100>\n";				// Colonne du montant HT
	$contenu_excel .= "<col width=100>\n";				// Colonne du montant TTC
	$contenu_excel .= "<col width=100>\n";				// Colonne du statut
	$contenu_excel .= "<col width=130>\n";				// Colonne du mode de paiement

	$contenu_excel .= "<tr height=30><td height=30 colspan=13 class=tableau_1>LISTE DES FACTURES AU ".date('d/m/Y H\hi')."</td></tr>\n";
	$contenu_excel .= "<tr height=20><td height=20 colspan=13 class=tableau_2>&nbsp;</td></tr>\n";
	$contenu_excel .= "<tr height=30>\n";
		$contenu_excel .= "<td width=120 height=30 class=colonnes_titre>NUMERO</td>\n";
		$contenu_excel .= "<td width=80 height=30 class=colonnes_titre>DATE</td>\n";
		$contenu_excel .= "<td width=100 height=30 class=colonnes_titre>PACKAGE</td>\n";
		$contenu_excel .= "<td width=200 height=30 class=colonnes_titre>NOM - PRÉNOM</td>\n";

		$contenu_excel .= "<td width=250 height=30 class=colonnes_titre>SOCIÉTÉ</td>\n";
		$contenu_excel .= "<td width=200 height=30 class=colonnes_titre>ADRESSE</td>\n";
		$contenu_excel .= "<td width=200 height=30 class=colonnes_titre>ADRESSE SUITE</td>\n";
		$contenu_excel .= "<td width=100 height=30 class=colonnes_titre>CODE POSTAL</td>\n";
		$contenu_excel .= "<td width=200 height=30 class=colonnes_titre>VILLE</td>\n";
		$contenu_excel .= "<td width=60 height=30 class=colonnes_titre>PAYS</td>\n";

		$contenu_excel .= "<td width=100 height=30 class=colonnes_titre>MONTANT HT</td>\n";
		$contenu_excel .= "<td width=100 height=30 class=colonnes_titre>MONTANT TTC</td>\n";
		$contenu_excel .= "<td width=100 height=30 class=colonnes_titre>STATUT</td>\n";
		$contenu_excel .= "<td width=130 height=30 class=colonnes_titre>MODE DE PAIEMENT</td>\n";
	$contenu_excel .= "</tr>\n";


	// Sélection des factures enregistrées
	$requete_factures = mysqli_query($connexion_mysql, 'SELECT facture_id, DATE_FORMAT(facture_date, "%d/%m/%y"), facture_numero, facture_package, A.joueur_id, joueur_nom, joueur_prenom, facture_entreprise_nom, facture_entreprise_adresse_1, facture_entreprise_adresse_2, facture_entreprise_code_postal, facture_entreprise_ville, facture_entreprise_pays, facture_prix_ht, facture_prix_ttc, facture_payee, facture_mode_paiement FROM factures A INNER JOIN joueurs B ON A.joueur_id=B.joueur_id ORDER BY facture_numero DESC, facture_date DESC, joueur_nom, joueur_prenom');
	$nb_factures = mysqli_num_rows($requete_factures);
	if($nb_factures!=0){

		for($facture_boucle=0; $facture_boucle<$nb_factures; $facture_boucle++){
			$resultat_facture = mysqli_fetch_array($requete_factures);
			$facture_id = $resultat_facture[0];
			$facture_date = $resultat_facture[1];
			$facture_numero = $resultat_facture[2];
			$facture_package = ucfirst($resultat_facture[3]);
			$joueur_id = $resultat_facture[4];
			$joueur_nom = strtoupper_max(decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture[5]))));
			$joueur_prenom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture[6])));
			$facture_entreprise_nom = strtoupper_max(decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture[7]))));
			$facture_entreprise_adresse_1 = ucfirst(decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture[8]))));
			$facture_entreprise_adresse_2 = ucfirst(decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture[9]))));
			$facture_entreprise_code_postal = $resultat_facture[10];
			$facture_entreprise_ville = strtoupper_max(decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture[11]))));
			$facture_entreprise_pays = $resultat_facture[12];
			$facture_prix_ht = number_format($resultat_facture[13], 2, ',', ' ').' &euro;';
			$facture_prix_ttc = number_format($resultat_facture[14], 2, ',', ' ').' &euro;';
			$facture_payee = $resultat_facture[15];
			$facture_mode_paiement = $resultat_facture[16];

			while(strlen(trim($facture_numero)) < 3){
				$facture_numero = '0'.$facture_numero;
			}
			$facture_numero = 'PAB-20'.substr($facture_date, -2).'-'.$facture_numero;

			if($facture_entreprise_pays=='-'){ $facture_entreprise_pays = ''; }

			if($facture_payee==0){ $facture_payee = 'EN COURS'; }else{ $facture_payee = 'PAYÉ'; }
			if($facture_mode_paiement=='CHQ'){
				$facture_mode_paiement = 'CHÈQUE';
			}elseif($facture_mode_paiement=='VIR'){
				$facture_mode_paiement = 'VIREMENT';
			}elseif($facture_mode_paiement=='ESP'){
				$facture_mode_paiement = 'ESPÈCES';
			}

			$contenu_excel .= "<tr height=18>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_1>".$facture_numero."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_1>".$facture_date."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_2>".$facture_package."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_2>".$joueur_nom.' '.$joueur_prenom."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_2>".$facture_entreprise_nom."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_2>".$facture_entreprise_adresse_1."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_2>".$facture_entreprise_adresse_2."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_1>".$facture_entreprise_code_postal."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_2>".$facture_entreprise_ville."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_1>".$facture_entreprise_pays."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_1>".$facture_prix_ht."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_1>".$facture_prix_ttc."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_1>".$facture_payee."</td>\n";
				$contenu_excel .= "<td height=18 class=cellules_standard_1>".$facture_mode_paiement."</td>\n";
			$contenu_excel .= "</tr>\n";

		}

	}

$contenu_excel .= "</table>\n";

$contenu_excel .= "\n</body>\n";
$contenu_excel .= "</html>\n";

/*********************************************************************************************************************/

if(!isset($archive)){

	$fichier_excel = 'Export_facturation_'.date('Y-m-d').'.xls';
	$path_temp = '../../../temp/';
	$path_temp_fichier_excel = $path_temp.$fichier_excel;

	$fichier_extraction = fopen($path_temp_fichier_excel, 'w+');
	if($fichier_extraction){
		fputs($fichier_extraction, $contenu_excel);		// Ecriture dans le fichier d'extraction
	}else{
		echo 'Impossible de créer le fichier Excel pour l\'exportation de la liste des joueurs.';
	}
	fclose($fichier_extraction);

	// Sortie du document Excel
	header("Content-Type: application/vnd.ms-excel");
	header("Content-Disposition: attachment; filename=$fichier_excel");
	header("Pragma: no-cache");
	header("Expires: 0");
	$document = fopen($path_temp_fichier_excel , 'r');
	fpassthru($document);
	exit;

}else{

	$path_archive_fichier_excel = '../../../archives/archive_'.$annee.'_facturation.xls';

	$fichier_extraction = fopen($path_archive_fichier_excel, 'w+');
	if($fichier_extraction){
		fputs($fichier_extraction, $contenu_excel);		// Ecriture dans le fichier d'extraction
	}else{
		echo 'Impossible de créer le fichier Excel pour l\'archivage de la facturation.';
	}
	fclose($fichier_extraction);

	header('Location: ../../competitions/competitions/archiver.php?process=factures&compet_annee='.$annee);
	exit;

}

?>