<?php 
require_once '../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND in_array(7, $_SESSION['SessionADMIN_compte_acces_modules'])==false){
	header('Location: ../../');
	exit;
}


if(isset($action) AND $action=='rechercher'){

	$export_parametres = $where = '';

	if((isset($critere_groupes) AND count($critere_groupes)!=0) OR (isset($gp) AND strlen(trim($gp))!=0)){

		if(isset($gp)){ $critere_groupes = explode('|', $gp); }

		$where = ' AND planning_groupe IN ("'.implode('","', $critere_groupes).'")';
		$export_parametres .= 'gp='.implode('|', $critere_groupes).'&';
	}

	$export_parametres = '?'.$export_parametres.'classement='.$classement;

}else{
	$classement = 'equipe_libelle';
	$export_parametres = $where = '';
}


// Sélection de la dernière compétition enregistrée
$requete_competition = mysqli_query($connexion_mysql, 'SELECT competition_id, competition_date_debut, competition_nb_groupes, competition_intervalle_departs FROM competitions WHERE competition_active=1 AND competition_archive=0 ORDER BY competition_annee DESC LIMIT 1');
$nb_competitions = mysqli_num_rows($requete_competition);
if($nb_competitions!=0){
	$resultat_competition = mysqli_fetch_array($requete_competition);
	$competition_id = $resultat_competition[0];
	$competition_date_debut = $resultat_competition[1];
	$competition_nb_groupes = $resultat_competition[2];
	$competition_intervalle_departs = $resultat_competition[3];
}

// Sélection des départs du calendrier de la dernière compétition
$requete_groupes = mysqli_query($connexion_mysql, 'SELECT DISTINCT(planning_groupe) FROM planning WHERE competition_id="'.$competition_id.'"'.$where.' ORDER BY planning_groupe');
$nb_groupes = mysqli_num_rows($requete_groupes);
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none">
	<script language="Javascript">
		<!-- 
		function generer(){
			resultat = confirm("Désirez-vous réellement générer le planning ?\n\nAttention : si un planning est déjà généré, il sera supprimé\nentièrement et remplacé par le nouveau.");
			if(resultat == true){
				window.location = './generer_1.php';
			}
		}
		//-->
	</script>
</head>

<body>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2">

	<div id="contenu_3" align="left" style="width: 665px;">

		<div id="titres">
			<span class="titre_1" style="width: 140px;">Planning</span>
			<?php if($nb_groupes!=0){ ?>
				<span class="ajouter" style="width: 110px; margin-right: 20px;"><a href="./exporter_leader_board.php" target="_blank">Leader Board</a></span>
				<span class="ajouter" style="width: 65px; margin-right: 20px;"><a href="./ajouter.php">Ajouter</a></span>
				<span class="ajouter" style="width: 70px; margin-right: 20px;"><a href="./modifier.php<?=$export_parametres?>">Modifier</a></span>
				<span class="ajouter" style="width: 70px; margin-right: 20px;"><a href="./exporter.php<?=$export_parametres?>" target="_blank">Exporter</a></span>
			<?php }else{ ?>
				<span style="float: left; width: 396px;">&nbsp;</span>
			<?php } ?>
			<span class="ajouter" style="width: 70px;"><a href="Javascript:void(0);" onclick="generer();">Générer</a></span>
		</div>
		<br clear="all">

		<div id="bloc">

		<?php 
		if($nb_groupes!=0){

			for($groupe_boucle=0; $groupe_boucle<$nb_groupes; $groupe_boucle++){
				$resultat_groupe = mysqli_fetch_array($requete_groupes);
				$planning_groupe = $resultat_groupe[0];

				if($groupe_boucle!=0){ $ligne_entete_complement = ' border-top: 1px solid #E9E8DF;'; }else{ $ligne_entete_complement = ''; }

				$tab_groupe_golfs = array();

				echo '<div id="ligne" style="height: 44px; padding-left: 0px;'.$ligne_entete_complement.'">'."\n";
					echo '<div align="center" style="float: left; width: 212px; background-color: #F6F6F6; font-size: 20px; font-weight: bold; color: #999999; line-height: 44px;">GROUPE '.$planning_groupe.'</div>'."\n";

					// Sélection des dates et des golfs correspondants
					$requete_dates_golfs = mysqli_query($connexion_mysql, 'SELECT DISTINCT(DATE_FORMAT(planning_depart_date, "%d/%m/%y")), golf_id, (SELECT golf_nom FROM golfs WHERE golf_id=planning.golf_id) FROM planning WHERE planning_groupe="'.$planning_groupe.'" ORDER BY planning_depart_date');
					$nb_dates_golfs = mysqli_num_rows($requete_dates_golfs);
					for($date_golf_boucle=0; $date_golf_boucle<$nb_dates_golfs; $date_golf_boucle++){
						$resultat_date_golf = mysqli_fetch_array($requete_dates_golfs);
						$planning_date = $resultat_date_golf[0];
						$planning_golf_id = $resultat_date_golf[1];
						$planning_golf = $resultat_date_golf[2];

						array_push($tab_groupe_golfs, $planning_golf_id);	// Tableau contenant l'ordre des golfs classé par date croissante

						echo '<div align="center" style="float: left; width: 112px; padding: 4px 0px 4px 0px; border-left: 1px solid #E6E5DA; background-color: #F6F6F6; color: #666666; line-height: 18px;">'.$planning_date.'<br>'.$planning_golf.'</div>'."\n";

					}

				echo '</div>'."\n\n";

				// Sélection des horaires de départ
				$requete_planning = mysqli_query($connexion_mysql, 'SELECT planning_id, equipe_id AS equipe_identifiant, (SELECT equipe_nom FROM equipes WHERE equipe_id=equipe_identifiant) AS equipe_libelle, (SELECT planning_depart_heure FROM planning WHERE equipe_id=equipe_identifiant AND golf_id='.$tab_groupe_golfs[0].') AS date_1, (SELECT planning_depart_heure FROM planning WHERE equipe_id=equipe_identifiant AND golf_id='.$tab_groupe_golfs[1].') AS date_2, (SELECT planning_depart_heure FROM planning WHERE equipe_id=equipe_identifiant AND golf_id='.$tab_groupe_golfs[2].') AS date_3, (SELECT planning_depart_heure FROM planning WHERE equipe_id=equipe_identifiant AND golf_id='.$tab_groupe_golfs[3].') AS date_4 FROM planning WHERE planning_groupe="'.$planning_groupe.'" GROUP BY equipe_identifiant ORDER BY '.$classement);
				$nb_planning = mysqli_num_rows($requete_planning);
				if($nb_planning!=0){
					for($planning_boucle=0; $planning_boucle<$nb_planning; $planning_boucle++){
						$resultat_planning = mysqli_fetch_array($requete_planning);
						$planning_id = $resultat_planning[0];
						$equipe_id = $resultat_planning[1];
						$equipe_nom = $resultat_planning[2];
						$planning_depart_heure_1 = preg_replace('/:/', ' H ', substr($resultat_planning[3], 0, -3));
						$planning_depart_heure_2 = preg_replace('/:/', ' H ', substr($resultat_planning[4], 0, -3));
						$planning_depart_heure_3 = preg_replace('/:/', ' H ', substr($resultat_planning[5], 0, -3));
						$planning_depart_heure_4 = preg_replace('/:/', ' H ', substr($resultat_planning[6], 0, -3));

						if(strlen(trim($equipe_nom))==0){ $equipe_nom = '<span style="color: #999999;"><i>inconnue ('.$equipe_id.')</i></span>'; }

						// Suppression du 0 devant l'heure s'il y a
						if(substr($planning_depart_heure_1, 0, 1)=='0'){ $planning_depart_heure_1 = substr($planning_depart_heure_1, 1); }
						if(substr($planning_depart_heure_2, 0, 1)=='0'){ $planning_depart_heure_2 = substr($planning_depart_heure_2, 1); }
						if(substr($planning_depart_heure_3, 0, 1)=='0'){ $planning_depart_heure_3 = substr($planning_depart_heure_3, 1); }
						if(substr($planning_depart_heure_4, 0, 1)=='0'){ $planning_depart_heure_4 = substr($planning_depart_heure_4, 1); }

						echo '<div id="ligne">'."\n";
							echo '<div style="float: left; width: 202px;" title="Nom de l\'équipe"><a href="./deplacer.php?planning_id='.$planning_id.'">'.$equipe_nom.'</a></div>'."\n";
							echo '<div align="center" style="float: left; width: 112px; border-left: 1px solid #E6E5DA;">'.$planning_depart_heure_1.'</div>'."\n";
							echo '<div align="center" style="float: left; width: 112px; border-left: 1px solid #E6E5DA;">'.$planning_depart_heure_2.'</div>'."\n";
							echo '<div align="center" style="float: left; width: 112px; border-left: 1px solid #E6E5DA;">'.$planning_depart_heure_3.'</div>'."\n";
							echo '<div align="center" style="float: left; width: 112px; border-left: 1px solid #E6E5DA;">'.$planning_depart_heure_4.'</div>'."\n";
						echo '</div>'."\n\n";

					}

				}

				echo '<br><br>'."\n\n";

			}
	
		}else{
			echo '<div id="ligne">le planning n\'a pas encore été généré.</div>'."\n";
		}
		?>

		</div>

	</div>
	<div id="contenu_secondaire">

		<form action="<?=$PHP_SELF?>" method="post">

			<input type="hidden" name="action" value="rechercher">

			<div class="titre">afficher un groupe</div>

			<?php 
			$requete_groupes = mysqli_query($connexion_mysql, 'SELECT DISTINCT(planning_groupe) FROM planning ORDER BY planning_groupe');
			$nb_groupes = mysqli_num_rows($requete_groupes);
			if($nb_groupes!=0){
				for($groupe_boucle=0; $groupe_boucle<$nb_groupes; $groupe_boucle++){
					$resultat_groupe = mysqli_fetch_array($requete_groupes);
					$competition_groupe = $resultat_groupe[0];

					if(isset($critere_groupes) AND in_array($competition_groupe, $critere_groupes)==true){ $competition_groupe_checked = ' checked'; }else{ $competition_groupe_checked = ''; }

					echo '<input type="checkbox" id="affichage_groupe_'.$competition_groupe.'" name="critere_groupes[]" value="'.$competition_groupe.'"'.$competition_groupe_checked.'> <label for="affichage_groupe_'.$competition_groupe.'">Groupe '.$competition_groupe.'</label><br>'."\n";
					if($groupe_boucle!=($nb_groupes-1)){ echo '<img src="'.$admin_img.'p.gif" width="1" height="3"><br>'."\n"; }

				}
			}else{
				echo 'aucun groupe';
			}
			?>

			<div class="titre">classer le planning</div>

			<input type="radio" id="classement_equipe" name="classement" value="equipe_libelle" <?php if(isset($classement) AND $classement=='equipe_libelle'){ echo 'checked'; } ?>> <label for="classement_equipe">par équipe</label><br>
			<img src="<?=$admin_img?>p.gif" width="1" height="3"><br>

			<?php 
			if(isset($competition_date_debut)){
				$tab_competition_date_debut = explode('-', $competition_date_debut);
				$tab_competition_date_debut_annee = $tab_competition_date_debut[0];
				$tab_competition_date_debut_mois = $tab_competition_date_debut[1];
				$tab_competition_date_debut_jour = $tab_competition_date_debut[2];
				for($bdate=0; $bdate<=3; $bdate++){

					$competition_date = date('Y-m-d', mktime(0, 0, 0, $tab_competition_date_debut_mois, $tab_competition_date_debut_jour+$bdate, $tab_competition_date_debut_annee));
					$competition_date_libelle = date('d/m/y', mktime(0, 0, 0, $tab_competition_date_debut_mois, $tab_competition_date_debut_jour+$bdate, $tab_competition_date_debut_annee));

					if(isset($classement) AND $classement=='date_'.($bdate+1)){ $classement_date_checked = ' checked'; }else{ $classement_date_checked = ''; }

					echo '<input type="radio" id="affichage_date_'.$bdate.'" name="classement" value="date_'.($bdate+1).'"'.$classement_date_checked.'> <label for="affichage_date_'.$bdate.'">par horaire du '.$competition_date_libelle.'</label><br>'."\n";
					echo '<img src="'.$admin_img.'p.gif" width="1" height="3"><br>'."\n";

				}
			}
			?>

			<img src="<?=$admin_img?>p.gif" width="100%" height="1" style="background-color: #807D73; margin: 10px 0px 20px 0px;"><br>

			<center><input type="submit" value="valider" style="width: 100px;"></center>

		</form>

	</div>
	<br clear="all">

</div></div>


<?php include $general_path_relatif.'sources/pied_page.inc'; ?>

</body>
</html>
