<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(6, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(3, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


if(isset($action) AND $action=='ajouter'){

	/******************************/
	/**  Traitement des erreurs  **/
	/******************************/
	if(!isset($joueur_profil)){
		$erreur_message .= "- le profil est manquant<br>";
	}
	if(isset($joueur_profil) AND $joueur_profil!='acc' AND $joueur_taille_polo=='0'){
		$erreur_message .= "- la taille du polo est manquante<br>";
	}
	if(isset($joueur_profil) AND $joueur_profil!='acc' AND $joueur_equipe_choix==1 AND $joueur_equipe_id=='0'){
		$erreur_message .= "- le nom de l'équipe est manquant<br>";
	}
	if(isset($joueur_profil) AND $joueur_profil=='acc' AND $joueur_equipe_id=='0'){
		$erreur_message .= "- le nom de l'équipe est manquant<br>";
	}
	if(isset($joueur_profil) AND $joueur_profil=='acc' AND $joueur_acc_accompagnant=='0'){
		$erreur_message .= "- le joueur accompagnant est manquant<br>";
	}
	if(!isset($joueur_sexe)){
		$erreur_message .= "- le sexe est manquant<br>";
	}
	if(strlen(trim($joueur_nom))==0){
		$erreur_message .= "- le nom est manquant<br>";
	}
	if(strlen(trim($joueur_prenom))==0){
		$erreur_message .= "- le prénom est manquant<br>";
	}
	if(!isset($joueur_profil) OR (isset($joueur_profil) AND $joueur_profil!='acc')){
		if(strlen(trim($joueur_adresse_1))==0){
			$erreur_message .= "- l'adresse est manquante<br>";
		}
		if(strlen(trim($joueur_code_postal))==0){
			$erreur_message .= "- le code postal est manquant<br>";
		}
		if(strlen(trim($joueur_ville))==0){
			$erreur_message .= "- la ville est manquante<br>";
		}
		if(strlen(trim($joueur_email))==0){
			$erreur_message .= "- l'adresse e-mail est manquante<br>";
		}
	}
	if(!isset($joueur_package)){
		$erreur_message .= "- le package pour la facturation est manquant<br>";
	}elseif($joueur_package=='entreprise'){
		if(strlen(trim($joueur_package_entreprise_nom))==0){
			$erreur_message .= "- le nom de l'entreprise est manquant<br>";
		}
		if(strlen(trim($joueur_package_entreprise_adresse_1))==0){
			$erreur_message .= "- l'adresse de l'entreprise est manquante<br>";
		}
		if(strlen(trim($joueur_package_entreprise_code_postal))==0){
			$erreur_message .= "- le code postal de l'entreprise est manquant<br>";
		}
		if(strlen(trim($joueur_package_entreprise_ville))==0){
			$erreur_message .= "- la ville de l'entreprise est manquante<br>";
		}
		if(strlen(trim($joueur_package_entreprise_ville))==0){
			$erreur_message .= "- la ville de l'entreprise est manquante<br>";
		}
	}

	/******************************/
	/**  Traitement des données  **/
	/******************************/
	$joueur_prenom = preg_replace('/-/', ' ', $joueur_prenom);
	$joueur_telephone = enregistrement_telephone($joueur_telephone);
	$joueur_mobile = enregistrement_telephone($joueur_mobile);
	$joueur_code_postal = enregistrement_telephone($joueur_code_postal);

	$joueur_licence = htmlentities(strtoupper_max($joueur_licence), ENT_QUOTES);
	$joueur_club = htmlentities(ucfirst($joueur_club), ENT_QUOTES);
	if(!isset($joueur_membre_club_competition)){ $joueur_membre_club_competition = 0; }
	if(preg_match('/,/', $joueur_handicap)==true){ $joueur_handicap = preg_replace('/,/', '.', $joueur_handicap); }
	if(!isset($joueur_handicap_validation)){ $joueur_handicap_validation = 0; }
	$joueur_nom = htmlentities(strtoupper_max($joueur_nom), ENT_QUOTES);
	$joueur_prenom = htmlentities(ucwords(strtolower_max($joueur_prenom)), ENT_QUOTES);
	$joueur_adresse_1 = htmlentities(ucfirst($joueur_adresse_1), ENT_QUOTES);
	$joueur_adresse_2 = htmlentities(ucfirst($joueur_adresse_2), ENT_QUOTES);
	$joueur_code_postal = htmlentities(strtolower_max($joueur_code_postal), ENT_QUOTES);
	$joueur_ville = htmlentities(strtoupper_max($joueur_ville), ENT_QUOTES);
	$joueur_email = htmlentities(strtolower_max($joueur_email), ENT_QUOTES);
	$joueur_mobile = htmlentities(strtolower_max($joueur_mobile), ENT_QUOTES);
	$joueur_telephone = htmlentities(strtolower_max($joueur_telephone), ENT_QUOTES);
	$joueur_package_entreprise_nom = htmlentities(strtoupper_max($joueur_package_entreprise_nom), ENT_QUOTES);
	$joueur_package_entreprise_adresse_1 = htmlentities(ucfirst($joueur_package_entreprise_adresse_1), ENT_QUOTES);
	$joueur_package_entreprise_adresse_2 = htmlentities(ucfirst($joueur_package_entreprise_adresse_2), ENT_QUOTES);
	$joueur_package_entreprise_code_postal = htmlentities(strtolower_max($joueur_package_entreprise_code_postal), ENT_QUOTES);
	$joueur_package_entreprise_ville = htmlentities(strtoupper_max($joueur_package_entreprise_ville), ENT_QUOTES);

	if($joueur_profil=='acc'){
		$joueur_licence = $joueur_club = $joueur_handicap = '';
		$joueur_membre_club_competition = $joueur_handicap_validation = 0;
		$joueur_date_naissance = $joueur_adresse_1 = $joueur_adresse_2 = $joueur_code_postal = $joueur_ville = $joueur_email = $joueur_mobile = $joueur_telephone = '';
	}

	/****************************************/
	/**  Enregistrement des modifications  **/
	/****************************************/
	if($erreur_message==''){


		/*****  JOUEUR  ********************************************************/

		$joueur_id = uniqid();
		if(($joueur_profil=='pro' OR $joueur_profil=='am') AND $joueur_equipe_choix==0){
			$equipe_id = uniqid();
		}elseif($joueur_profil=='pro' AND $joueur_equipe_choix==1){
			$equipe_id = $joueur_pro_equipe_id;
		}elseif($joueur_profil=='am' AND $joueur_equipe_choix==1){
			$equipe_id = $joueur_am_equipe_id;
		}else{
			$equipe_id = $joueur_acc_equipe_id;
		}
		$ej_id = uniqid();

		if($joueur_handicap!=''){ $requete_handicap = '"'.$joueur_handicap.'"'; }else{ $requete_handicap = 'NULL'; }
		if($joueur_profil!='acc'){ $requete_taille_polo = '"'.$joueur_taille_polo.'"'; }else{ $requete_taille_polo = 'NULL'; }


		// Requête d'insertion du joueur
		$requete_insertion = mysqli_query($connexion_mysql, 'INSERT INTO joueurs (joueur_id, competition_id, joueur_profil, joueur_licence, joueur_club, joueur_handicap, joueur_handicap_validation, joueur_membre_club_competition, joueur_taille_polo, joueur_sexe, joueur_nom, joueur_prenom, joueur_date_naissance, joueur_adresse_1, joueur_adresse_2, joueur_code_postal, joueur_ville, joueur_pays, joueur_email, joueur_mobile, joueur_telephone, joueur_langue, joueur_datetime_creation, joueur_admin, joueur_actif) VALUES("'.$joueur_id.'", "'.$competition_id.'", "'.$joueur_profil.'", "'.$joueur_licence.'", "'.$joueur_club.'", '.$requete_handicap.', "'.$joueur_handicap_validation.'", "'.$joueur_membre_club_competition.'", '.$requete_taille_polo.', "'.$joueur_sexe.'", "'.$joueur_nom.'", "'.$joueur_prenom.'", STR_TO_DATE("'.$joueur_date_naissance.'", "%d/%m/%Y"), "'.$joueur_adresse_1.'", "'.$joueur_adresse_2.'", "'.$joueur_code_postal.'", "'.$joueur_ville.'", "'.$joueur_pays.'", "'.$joueur_email.'", "'.$joueur_mobile.'", "'.$joueur_telephone.'", "'.$joueur_langue.'", "'.date('Y-m-d H:i:s').'", "1", "'.$joueur_actif.'")');


		/*****  EQUIPE  ********************************************************/

		if($joueur_profil=='pro' OR $joueur_profil=='am'){

			$equipe_motdepasse = md5('proamcoteopale');
			$joueur_acc_accompagnant = '0';

			if($joueur_equipe_choix==0){

				if($joueur_profil=='pro'){
					$equipe_nom = htmlentities($joueur_nom, ENT_QUOTES);
				}else{
					$equipe_nom = 'EQUIPE_TEMP_'.date('m').date('d').date('s');
				}

				// Requête d'insertion de l'équipe
				$requete_insertion_2 = mysqli_query($connexion_mysql, 'INSERT INTO equipes (equipe_id, competition_id, equipe_nom, equipe_motdepasse, equipe_active) VALUES("'.$equipe_id.'", "'.$competition_id.'", "'.$equipe_nom.'", "'.$equipe_motdepasse.'", "1")');

			}

		}


		// Requête d'insertion de la liaison équipe / joueur
		$requete_insertion_3 = mysqli_query($connexion_mysql, 'INSERT INTO equipes_joueurs (ej_id, ej_equipe, ej_joueur, ej_joueur_accompagnant) VALUES("'.$ej_id.'", "'.$equipe_id.'", "'.$joueur_id.'", "'.$joueur_acc_accompagnant.'")');


		/*****  FACTURATION  ****************************************************/

		if($joueur_package!='gratuit'){

			$facture_id = uniqid();
			$facture_libelle_id = uniqid();

			// Création du numéro de facture
			$requete_facture_numero_max = mysqli_query($connexion_mysql, 'SELECT MAX(facture_numero) FROM factures');
			$resultat_facture_numero_max = mysqli_fetch_array($requete_facture_numero_max);
			$facture_numero = $resultat_facture_numero_max[0] + 1;

			// Sélection des dates de la compétition
			$requete_competition = mysqli_query($connexion_mysql, 'SELECT DATE_FORMAT(competition_date_debut, "%d/%m/%Y"), DATE_FORMAT(competition_date_fin, "%d/%m/%Y") FROM competitions WHERE competition_id="'.$competition_id.'"');
			$resultat_competition = mysqli_fetch_array($requete_competition);
			$competition_date_debut = $resultat_competition[0];
			$competition_date_fin = $resultat_competition[1];

			if($joueur_package=='golfeur' AND $joueur_membre_club_competition==0){
				$facture_libelle_description = "Participation aux Duos du golf de Biarritz\ndu ".$competition_date_debut." au ".$competition_date_fin."\nPackage Golfeur\n".$joueur_nom." ".$joueur_prenom;
				$facture_prix_ht = $facture_prix_golfeur_pasmembre_ht;
				$facture_prix_tva = $facture_prix_golfeur_pasmembre_tva;
				$facture_prix_ttc = $facture_prix_golfeur_pasmembre_ttc;
			}elseif($joueur_package=='golfeur' AND $joueur_membre_club_competition==1){
				$facture_libelle_description = "Participation aux Duos du golf de Biarritz\ndu ".$competition_date_debut." au ".$competition_date_fin."\nPackage Golfeur - Membre de l'un des 4 clubs : Belle Dune,\nHardelot, Le Touquet ou Wimereux\n".$joueur_nom." ".$joueur_prenom;
				$facture_prix_ht = $facture_prix_golfeur_membre_ht;
				$facture_prix_tva = $facture_prix_golfeur_membre_tva;
				$facture_prix_ttc = $facture_prix_golfeur_membre_ttc;
			}elseif($joueur_package=='entreprise'){
				$facture_libelle_description = "Participation aux Duos du golf de Biarritz\ndu ".$competition_date_debut." au ".$competition_date_fin."\nPackage Entreprise";
				$facture_prix_ht = $facture_prix_entreprise_ht;
				$facture_prix_tva = $facture_prix_entreprise_tva;
				$facture_prix_ttc = $facture_prix_entreprise_ttc;
			}else{
				$facture_libelle_description = "Participation aux Duos du golf de Biarritz\ndu ".$competition_date_debut." au ".$competition_date_fin."\nPackage Accompagnateur\nQuantité : 1\n".$joueur_nom." ".$joueur_prenom;
				$facture_prix_ht = $facture_prix_accompagnateur_ht;
				$facture_prix_tva = $facture_prix_accompagnateur_tva;
				$facture_prix_ttc = $facture_prix_accompagnateur_ttc;

				$joueur_id = $joueur_acc_accompagnant;
			}

			if($joueur_package=='golfeur' AND strlen(trim($joueur_package_entreprise_1_nom))!=0){
				$facture_entreprise_nom = $joueur_package_entreprise_nom;
				$facture_entreprise_adresse_1 = $joueur_package_entreprise_adresse_1;
				$facture_entreprise_adresse_2 = $joueur_package_entreprise_adresse_2;
				$facture_entreprise_code_postal = $joueur_package_entreprise_code_postal;
				$facture_entreprise_ville = $joueur_package_entreprise_ville;
				$facture_entreprise_pays = $joueur_package_entreprise_pays;
			}else{
				$facture_entreprise_nom = $facture_entreprise_adresse_1 = $facture_entreprise_adresse_2 = $facture_entreprise_code_postal = $facture_entreprise_ville = $facture_entreprise_pays = '';
			}

			if($joueur_package=='entreprise'){
				$facture_entreprise_nom = $joueur_package_entreprise_nom;
				$facture_entreprise_adresse_1 = $joueur_package_entreprise_adresse_1;
				$facture_entreprise_adresse_2 = $joueur_package_entreprise_adresse_2;
				$facture_entreprise_code_postal = $joueur_package_entreprise_code_postal;
				$facture_entreprise_ville = $joueur_package_entreprise_ville;
				$facture_entreprise_pays = $joueur_package_entreprise_pays;
			}

			// Requête d'insertion de la facturation
			$requete_insertion_4 = mysqli_query($connexion_mysql, 'INSERT INTO factures (facture_id, joueur_id, facture_numero, facture_package, facture_entreprise_nom, facture_entreprise_adresse_1, facture_entreprise_adresse_2, facture_entreprise_code_postal, facture_entreprise_ville, facture_entreprise_pays, facture_prix_ht, facture_prix_tva, facture_prix_ttc, facture_date) VALUES("'.$facture_id.'", "'.$joueur_id.'", "'.$facture_numero.'", "'.$joueur_package.'", "'.$facture_entreprise_nom.'", "'.$facture_entreprise_adresse_1.'", "'.$facture_entreprise_adresse_2.'", "'.$facture_entreprise_code_postal.'", "'.$facture_entreprise_ville.'", "'.$facture_entreprise_pays.'", "'.$facture_prix_ht.'", "'.$facture_prix_tva.'", "'.$facture_prix_ttc.'", "'.date('Y-m-d').'")');

			// Requête d'insertion de la facturation libellé
			$requete_insertion_5 = mysqli_query($connexion_mysql, 'INSERT INTO factures_libelles (facture_libelle_id, facture_id, facture_libelle_description, facture_libelle_prix_unitaire_ht, facture_libelle_prix_total_ht) VALUES("'.$facture_libelle_id.'", "'.$facture_id.'", "'.$facture_libelle_description.'", "'.$facture_prix_ht.'", "'.$facture_prix_ht.'")');

		}


		header('Location: ./');
		exit;

	}else{
		$joueur_licence = stripslashes($joueur_licence);
		$joueur_club = stripslashes($joueur_club);
		$joueur_nom = stripslashes($joueur_nom);
		$joueur_prenom = stripslashes($joueur_prenom);
		$joueur_adresse_1 = stripslashes($joueur_adresse_1);
		$joueur_adresse_2 = stripslashes($joueur_adresse_2);
		$joueur_code_postal = stripslashes($joueur_code_postal);
		$joueur_ville = stripslashes($joueur_ville);
		$joueur_email = stripslashes($joueur_email);
		$joueur_mobile = stripslashes($joueur_mobile);
		$joueur_telephone = stripslashes($joueur_telephone);
		$joueur_package_entreprise_nom = stripslashes($joueur_package_entreprise_nom);
		$joueur_package_entreprise_adresse_1 = stripslashes($joueur_package_entreprise_adresse_1);
		$joueur_package_entreprise_adresse_2 = stripslashes($joueur_package_entreprise_adresse_2);
		$joueur_package_entreprise_code_postal = stripslashes($joueur_package_entreprise_code_postal);
		$joueur_package_entreprise_ville = stripslashes($joueur_package_entreprise_ville);
	}

}


if(isset($erreur_message) AND $erreur_message==''){

	// Initialisation des champs
	$joueur_actif = 1;
	$joueur_club = '';
	$joueur_licence = '';
	$joueur_handicap = '';
	$joueur_handicap_validation = 0;
	$joueur_taille_polo = '';
	$joueur_equipe_choix = 0;
	$joueur_sexe = 'M.';
	$joueur_nom = '';
	$joueur_prenom = '';
	$joueur_date_naissance = '';
	$joueur_adresse_1 = '';
	$joueur_adresse_2 = '';
	$joueur_code_postal = '';
	$joueur_ville = '';
	$joueur_pays = 'FR';
	$joueur_email = '';
	$joueur_mobile = '';
	$joueur_telephone = '';
	$joueur_langue = 'FR';
	$joueur_package_entreprise_nom = '';
	$joueur_package_entreprise_adresse_1 = '';
	$joueur_package_entreprise_adresse_2 = '';
	$joueur_package_entreprise_code_postal = '';
	$joueur_package_entreprise_ville = '';
	$joueur_package_entreprise_pays = 'FR';

}else{

	// Si le formulaire comporte des erreurs, alors traitement des données
	$joueur_club = stripslashes($joueur_club);
	$joueur_licence = stripslashes($joueur_licence);
	$joueur_nom = stripslashes($joueur_nom);
	$joueur_prenom = stripslashes($joueur_prenom);
	$joueur_code_postal = stripslashes($joueur_code_postal);
	$joueur_adresse_1 = stripslashes($joueur_adresse_1);
	$joueur_adresse_2 = stripslashes($joueur_adresse_2);
	$joueur_ville = stripslashes($joueur_ville);
	$joueur_email = stripslashes($joueur_email);
	$joueur_mobile = stripslashes($joueur_mobile);
	$joueur_telephone = stripslashes($joueur_telephone);
	$joueur_package_entreprise_nom = stripslashes($joueur_package_entreprise_nom);
	$joueur_package_entreprise_adresse_1 = stripslashes($joueur_package_entreprise_adresse_1);
	$joueur_package_entreprise_adresse_2 = stripslashes($joueur_package_entreprise_adresse_2);
	$joueur_package_entreprise_code_postal = stripslashes($joueur_package_entreprise_code_postal);
	$joueur_package_entreprise_ville = stripslashes($joueur_package_entreprise_ville);
}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none">
	<script type="text/javascript">
		function joueur_profil_details(profil){
			if(profil=='pro' || profil=='am'){
				document.getElementById('calque_joueur_pro_am').style.display = 'block';
				document.getElementById('calque_joueur_pro_am_2').style.display = 'block';
				document.getElementById('calque_joueur_acc').style.display = 'none';
				if(profil=='pro'){
					document.getElementById('calque_joueur_pro_equipe').style.display = 'block';
					document.getElementById('calque_joueur_am_equipe').style.display = 'none';
					document.getElementById('calque_pro_profil_handicap').style.display = 'none';
				}else{
					document.getElementById('calque_joueur_pro_equipe').style.display = 'none';
					document.getElementById('calque_joueur_am_equipe').style.display = 'block';
					document.getElementById('calque_pro_profil_handicap').style.display = 'block';
				}
			}else{
				document.getElementById('calque_joueur_pro_am').style.display = 'none';
				document.getElementById('calque_joueur_pro_am_2').style.display = 'none';
				document.getElementById('calque_joueur_acc').style.display = 'block';
			}
		}

		function joueur_profil_facturation(package){
			if(package=='golfeur'){
				document.getElementById('calque_joueur_package_entreprise').style.display = 'none';
			}else if(package=='entreprise'){
				document.getElementById('calque_joueur_package_entreprise').style.display = 'block';
			}else{
				document.getElementById('calque_joueur_package_entreprise').style.display = 'none';
			}
		}
	</script>
</head>

<body>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2">

	<div id="contenu_3" align="left" style="width: 650px;">

		<div id="titres">
			<span class="titre_1"><a href="./">Joueurs</a> <span class="separateur">/</span> <span class="titre_2">Ajouter</span></span>
		</div>
		<br clear="all">

		<div id="bloc_bis">

			<?php if(isset($erreur_message) AND $erreur_message!=''){ ?>
				<div align="center"><div id="message_erreur" align="left"><b><?=$erreur_message_introduction.'</b><br>'.$erreur_message?></div></div>
			<?php } ?>

			<form name="ajouter" action="<?=$PHP_SELF?>" method="post" enctype="multipart/form-data">

				<input type="hidden" name="action" value="ajouter">

				<div id="formulaire_ligne_intertitre">COMPTE</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle">Statut</div>
					<div id="formulaire_champ" style="width: 195px;">
						<input type="radio" id="joueur_actif_1" name="joueur_actif" value="1" <?php if($joueur_actif==1){ echo 'checked'; } ?> class="radio"> <label for="joueur_actif_1">Actif</label>
						<input type="radio" id="joueur_actif_0" name="joueur_actif" value="0" <?php if($joueur_actif==0){ echo 'checked'; } ?> class="radio" style="margin-left: 20px;"> <label for="joueur_actif_0">Inactif</label>
					</div>
					<div id="formulaire_libelle" style="width: 90px;">Langue</div>
					<div id="formulaire_champ" style="width: 195px;">
						<select name="joueur_langue" size="1" class="select" style="width: 150px;">
							<option value="FR" <?php if($joueur_langue=='FR'){ echo 'selected'; } ?>>Français</option>
							<option value="EN" <?php if($joueur_langue=='EN'){ echo 'selected'; } ?>>Anglais</option>
						</select>
					</div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne_intertitre">PROFIL</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Profil</div>
					<div id="formulaire_champ" style="width: 500px;">
						<input type="radio" id="joueur_profil_pro" name="joueur_profil" value="pro" <?php if(isset($joueur_profil) AND $joueur_profil=='pro'){ echo 'checked'; } ?> onclick="joueur_profil_details('pro')"> <label for="joueur_profil_pro">Professionnel</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
						<input type="radio" id="joueur_profil_am" name="joueur_profil" value="am" <?php if(isset($joueur_profil) AND $joueur_profil=='am'){ echo 'checked'; } ?> onclick="joueur_profil_details('am')"> <label for="joueur_profil_am">Amateur</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
						<input type="radio" id="joueur_profil_acc" name="joueur_profil" value="acc" <?php if(isset($joueur_profil) AND $joueur_profil=='acc'){ echo 'checked'; } ?> onclick="joueur_profil_details('acc')"> <label for="joueur_profil_acc">Accompagnateur</label>
					</div>
					<br clear="all">
				</div>
				<div id="calque_joueur_pro_am"<?php if(!isset($joueur_profil) OR (isset($joueur_profil) AND $joueur_profil=='acc')){ echo ' style="display: none;"'; } ?>>
					<div id="formulaire_ligne">
						<div id="formulaire_libelle">N° licence</div>
						<div id="formulaire_champ" style="width: 195px;"><input type="text" name="joueur_licence" value="<?=$joueur_licence?>" class="input" style="width: 164px;"></div>
						<div id="calque_pro_profil_handicap"<?php if(isset($joueur_profil) AND $joueur_profil=='pro'){ echo ' style="display: none;"'; } ?>>
							<div id="formulaire_libelle" style="width: 145px;">Handicap</div>
							<div id="formulaire_champ" style="width: 140px;"><input type="text" name="joueur_handicap" value="<?=$joueur_handicap?>" class="input" style="width: 60px;"></div>
						</div>
						<br clear="all">
					</div>
					<div id="formulaire_ligne">
						<div id="formulaire_libelle">Club</div>
						<div id="formulaire_champ" style="width: 195px;"><input type="text" name="joueur_club" value="<?=$joueur_club?>" class="input" style="width: 164px;"></div>
						<div id="formulaire_libelle" style="width: 145px;">Validation du HDCP</div>
						<div id="formulaire_champ" style="width: 140px;"><input type="checkbox" name="joueur_handicap_validation" value="1" <?php if($joueur_handicap_validation==1){ echo 'checked'; } ?>></div>
						<br clear="all">
					</div>
					<div id="formulaire_ligne">
						<div id="formulaire_libelle" style="padding-top: 0px; padding-bottom: 0px;">&nbsp;</div>
						<div id="formulaire_champ" style="width: 195px; color: #666666;"><input type="checkbox" name="joueur_membre_club_competition" value="1" <?php if(isset($joueur_membre_club_competition) AND $joueur_membre_club_competition==1){ echo 'checked'; } ?>> Membre de l'un des 4 clubs</div>
						<div id="formulaire_libelle_obligatoire" style="width: 145px;">Taille du polo</div>
						<div id="formulaire_champ" style="width: 140px;">
							<select name="joueur_taille_polo" size="1" class="select" style="width: 100px;">
								<option value="0">-</option>
								<option value="NC"<?php if($joueur_taille_polo=='NC'){ echo ' selected'; } ?>>NC</option>
								<option value="S"<?php if($joueur_taille_polo=='S'){ echo ' selected'; } ?>>S</option>
								<option value="M"<?php if($joueur_taille_polo=='M'){ echo ' selected'; } ?>>M</option>
								<option value="L"<?php if($joueur_taille_polo=='L'){ echo ' selected'; } ?>>L</option>
								<option value="XL"<?php if($joueur_taille_polo=='XL'){ echo ' selected'; } ?>>XL</option>
								<option value="XXL"<?php if($joueur_taille_polo=='XXL'){ echo ' selected'; } ?>>XXL</option>
							</select>
						</div>
						<br clear="all">
					</div>

					<div id="formulaire_ligne_separateur"></div>

					<div id="formulaire_ligne">
						<div id="formulaire_libelle_obligatoire">&Eacute;quipe</div>
						<div id="formulaire_champ" style="width: 500px;"><input type="radio" id="equipe_choix_creer" name="joueur_equipe_choix" value="0"<?php if($joueur_equipe_choix==0){ echo 'checked'; } ?> class="input"> <label for="equipe_choix_creer">Créer une nouvelle équipe</label></div>
						<br clear="all">
					</div>
					<div id="formulaire_ligne">
						<div id="formulaire_libelle">&nbsp;</div>
						<div id="formulaire_champ" style="width: 500px;">
							<div style="float: left; width: 240px;"><input type="radio" id="equipe_choix_selectionner" name="joueur_equipe_choix" value="1" <?php if($joueur_equipe_choix==1){ echo 'checked'; } ?> class="input"> <label for="equipe_choix_selectionner">Sélectionner une équipe incomplète :</label>&nbsp;&nbsp;&nbsp; </div>

							<div id="calque_joueur_pro_equipe" style="float: left;<?php if(isset($joueur_profil) AND $joueur_profil!='pro'){ echo ' display: none;'; } ?>">
								<select name="joueur_pro_equipe_id" size="1" class="select" style="width: 230px;">
									<option value="0">-</option>
									<?php 
									// Sélection des équipes
									$requete_equipes = mysqli_query($connexion_mysql, 'SELECT equipe_id, equipe_nom FROM equipes WHERE competition_id="'.$competition_id.'" AND (SELECT COUNT(ej_id) FROM equipes_joueurs A INNER JOIN joueurs B ON A.ej_joueur=B.joueur_id WHERE ej_equipe=equipe_id AND joueur_profil="pro")=0');
									$nb_equipes = mysqli_num_rows($requete_equipes);
									if($nb_equipes!=0){
										for($equipe_boucle=0; $equipe_boucle<$nb_equipes; $equipe_boucle++){
											$resultat_equipe = mysqli_fetch_array($requete_equipes);
											$equipe_id = $resultat_equipe[0];
											$equipe_nom = $resultat_equipe[1];

											if($equipe_id==$joueur_pro_equipe_id){ $equipe_selection = ' selected'; }else{ $equipe_selection = ''; }

											echo '<option value="'.$equipe_id.'"'.$equipe_selection.'>'.$equipe_nom.'</option>'."\n";

										}
									}
									?>
								</select>
							</div>

							<div id="calque_joueur_am_equipe" style="float: left;<?php if(isset($joueur_profil) AND $joueur_profil!='am'){ echo ' display: none;'; } ?>">
								<select name="joueur_am_equipe_id" size="1" class="select" style="width: 230px;">
									<option value="0">-</option>
									<?php 
									// Sélection des équipes
									$requete_equipes = mysqli_query($connexion_mysql, 'SELECT equipe_id, equipe_nom FROM equipes WHERE competition_id="'.$competition_id.'" AND (SELECT COUNT(ej_id) FROM equipes_joueurs A INNER JOIN joueurs B ON A.ej_joueur=B.joueur_id WHERE ej_equipe=equipe_id AND joueur_profil!="acc")<4');
									$nb_equipes = mysqli_num_rows($requete_equipes);
									if($nb_equipes!=0){
										for($equipe_boucle=0; $equipe_boucle<$nb_equipes; $equipe_boucle++){
											$resultat_equipe = mysqli_fetch_array($requete_equipes);
											$equipe_id = $resultat_equipe[0];
											$equipe_nom = $resultat_equipe[1];

											if($equipe_id==$joueur_am_equipe_id){ $equipe_selection = ' selected'; }else{ $equipe_selection = ''; }

											echo '<option value="'.$equipe_id.'"'.$equipe_selection.'>'.$equipe_nom.'</option>'."\n";

										}
									}
									?>
								</select>
							</div>

						</div>
						<br clear="all">
					</div>

				</div>

				<div id="calque_joueur_acc"<?php if(!isset($joueur_profil) OR (isset($joueur_profil) AND $joueur_profil!='acc')){ echo ' style="display: none;"'; } ?>>

					<div id="formulaire_ligne_separateur"></div>

					<div id="formulaire_ligne">
						<div id="formulaire_libelle_obligatoire">&Eacute;quipe</div>
						<div id="formulaire_champ" style="width: 500px;">
							<select name="joueur_acc_equipe_id" size="1" class="select" style="width: 300px;">
								<option value="0">-</option>
								<?php 
								// Sélection des équipes
								$requete_equipes = mysqli_query($connexion_mysql, 'SELECT equipe_id, equipe_nom FROM equipes WHERE equipe_active=1 AND competition_id="'.$competition_id.'"');
								$nb_equipes = mysqli_num_rows($requete_equipes);
								if($nb_equipes!=0){
									for($equipe_boucle=0; $equipe_boucle<$nb_equipes; $equipe_boucle++){
										$resultat_equipe = mysqli_fetch_array($requete_equipes);
										$equipe_id = $resultat_equipe[0];
										$equipe_nom = $resultat_equipe[1];

										if($equipe_id==$joueur_acc_equipe_id){ $equipe_selection = ' selected'; }else{ $equipe_selection = ''; }

										echo '<option value="'.$equipe_id.'"'.$equipe_selection.'>'.$equipe_nom.'</option>'."\n";

									}
								}
								?>
							</select>
						</div>
						<br clear="all">
					</div>

					<div id="formulaire_ligne">
						<div id="formulaire_libelle_obligatoire">Accompagnant</div>
						<div id="formulaire_champ" style="width: 500px;">
							<select name="joueur_acc_accompagnant" size="1" class="select" style="width: 300px;">
								<option value="0">-</option>
								<?php 
								// Sélection des joueurs
								$requete_joueurs = mysqli_query($connexion_mysql, 'SELECT joueur_id, joueur_nom, joueur_prenom FROM joueurs WHERE joueur_profil IN ("am", "pro") ORDER BY joueur_nom, joueur_prenom');
								$nb_joueurs = mysqli_num_rows($requete_joueurs);
								if($nb_joueurs!=0){
									for($joueur_boucle=0; $joueur_boucle<$nb_joueurs; $joueur_boucle++){
										$resultat_joueur = mysqli_fetch_array($requete_joueurs);
										$joueur_acc_id = $resultat_joueur[0];
										$joueur_acc_nom = $resultat_joueur[1];
										$joueur_acc_prenom = $resultat_joueur[2];

										if($joueur_acc_id==$joueur_acc_accompagnant){ $joueur_selection = ' selected'; }else{ $joueur_selection = ''; }

										echo '<option value="'.$joueur_acc_id.'"'.$pays_selection.'>'.$joueur_acc_nom.' '.$joueur_acc_prenom.'</option>'."\n";

									}
								}
								?>
							</select>
						</div>
						<br clear="all">
					</div>

				</div>

				<div id="formulaire_ligne_intertitre">INFORMATIONS</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle">Sexe</div>
					<div id="formulaire_champ" style="width: 500px;">
						<input type="radio" id="joueur_sexe_homme" name="joueur_sexe" value="H" <?php if(isset($joueur_sexe) AND $joueur_sexe=='H'){ echo 'checked'; } ?>> <label for="joueur_sexe_homme">Homme</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
						<input type="radio" id="joueur_sexe_femme" name="joueur_sexe" value="F" <?php if(isset($joueur_sexe) AND $joueur_sexe=='F'){ echo 'checked'; } ?>> <label for="joueur_sexe_femme">Femme</label>
					</div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Nom</div>
					<div id="formulaire_champ" style="width: 195px;"><input type="text" name="joueur_nom" value="<?=$joueur_nom?>" class="input" style="width: 164px;"></div>
					<div id="formulaire_libelle_obligatoire" style="width: 90px;">Prénom</div>
					<div id="formulaire_champ" style="width: 195px;"><input type="text" name="joueur_prenom" value="<?=$joueur_prenom?>" class="input" style="width: 164px;"></div>
					<br clear="all">
				</div>

				<div id="calque_joueur_pro_am_2"<?php if(isset($joueur_profil) AND $joueur_profil=='acc'){ echo ' style="display: none;"'; } ?>>

					<div id="formulaire_ligne">
						<div id="formulaire_libelle">Né(e) le</div>
						<div id="formulaire_champ" style="width: 195px;"><input type="text" name="joueur_date_naissance" value="<?=$joueur_date_naissance?>" class="input" style="width: 164px;"></div>
						<br clear="all">
					</div>

					<div id="formulaire_ligne_separateur"></div>

					<div id="formulaire_ligne">
						<div id="formulaire_libelle_obligatoire">Adresse</div>
						<div id="formulaire_champ" style="width: 500px;">
							<input type="text" name="joueur_adresse_1" value="<?=$joueur_adresse_1?>" class="input" style="width: 470px; margin-bottom: 5px;"><br>
							<input type="text" name="joueur_adresse_2" value="<?=$joueur_adresse_2?>" class="input" style="width: 470px;">
						</div>
						<br clear="all">
					</div>
					<div id="formulaire_ligne">
						<div id="formulaire_libelle_obligatoire">Code postal</div>
						<div id="formulaire_champ" style="width: 195px;"><input type="text" name="joueur_code_postal" value="<?=$joueur_code_postal?>" class="input" style="width: 164px;"></div>
						<div id="formulaire_libelle_obligatoire" style="width: 90px;">Ville</div>
						<div id="formulaire_champ" style="width: 195px;"><input type="text" name="joueur_ville" value="<?=$joueur_ville?>" class="input" style="width: 164px;"></div>
						<br clear="all">
					</div>
					<div id="formulaire_ligne">
						<div id="formulaire_libelle_obligatoire">Pays</div>
						<div id="formulaire_champ" style="width: 500px;">
							<select name="joueur_pays" size="1" class="select">
								<option value="0">-</option>
								<?php 
								// Sélection des pays
								$requete_pays = mysqli_query($connexion_mysql, 'SELECT pays_code, pays_libelle_FR FROM pays ORDER BY pays_libelle_FR');
								$nb_pays = mysqli_num_rows($requete_pays);
								if($nb_pays!=0){
									for($pays_boucle=0; $pays_boucle<$nb_pays; $pays_boucle++){
										$resultat_pays = mysqli_fetch_array($requete_pays);
										$pays_code = $resultat_pays[0];
										$pays_libelle = $resultat_pays[1];

										if($pays_code==$joueur_pays){ $pays_selection = ' selected'; }else{ $pays_selection = ''; }

										echo '<option value="'.$pays_code.'"'.$pays_selection.'>'.$pays_libelle.'</option>'."\n";

									}
								}
								?>
							</select>
						</div>
						<br clear="all">
					</div>

					<div id="formulaire_ligne_separateur"></div>

					<div id="formulaire_ligne">
						<div id="formulaire_libelle_obligatoire">E-mail</div>
						<div id="formulaire_champ" style="width: 500px;"><input type="text" name="joueur_email" value="<?=$joueur_email?>" class="input" style="width: 470px;"></div>
						<br clear="all">
					</div>
					<div id="formulaire_ligne">
						<div id="formulaire_libelle">Mobile</div>
						<div id="formulaire_champ" style="width: 195px;"><input type="text" name="joueur_mobile" value="<?=$joueur_mobile?>" class="input" style="width: 164px;"></div>
						<div id="formulaire_libelle" style="width: 90px;">Téléphone</div>
						<div id="formulaire_champ" style="width: 195px;"><input type="text" name="joueur_telephone" value="<?=$joueur_telephone?>" class="input" style="width: 164px;"></div>
						<br clear="all">
					</div>

				</div>

				<div id="formulaire_ligne_intertitre">FACTURATION</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Package</div>
					<div id="formulaire_champ" style="width: 500px;">
						<input type="radio" id="joueur_package_golfeur" name="joueur_package" value="golfeur" onclick="joueur_profil_facturation('golfeur');" <?php if(isset($joueur_package) AND $joueur_package=='golfeur'){ echo 'checked'; } ?>> <label for="joueur_package_golfeur">Golfeur</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
						<input type="radio" id="joueur_package_entreprise" name="joueur_package" value="entreprise" onclick="joueur_profil_facturation('entreprise');" <?php if(isset($joueur_package) AND $joueur_package=='entreprise'){ echo 'checked'; } ?>> <label for="joueur_package_entreprise">Entreprise</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
						<input type="radio" id="joueur_package_accompagnateur" name="joueur_package" value="accompagnateur" onclick="joueur_profil_facturation('accompagnateur');" <?php if(isset($joueur_package) AND $joueur_package=='accompagnateur'){ echo 'checked'; } ?>> <label for="joueur_package_accompagnateur">Accompagnateur</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
						<input type="radio" id="joueur_package_gratuit" name="joueur_package" value="gratuit" onclick="joueur_profil_facturation('gratuit');" <?php if(isset($joueur_package) AND $joueur_package=='gratuit'){ echo 'checked'; } ?>> <label for="joueur_package_gratuit">Gratuit</label>
					</div>
					<br clear="all">
				</div>

				<div id="calque_joueur_package_entreprise"<?php if(!isset($joueur_package) OR (isset($joueur_package) AND $joueur_package!='entreprise')){ echo ' style="display: none;"'; } ?>>

					<div id="formulaire_ligne">
						<div id="formulaire_libelle_obligatoire" style="padding-top: 0px; padding-bottom: 0px;">Nom de l'entreprise</div>
						<div id="formulaire_champ" style="width: 500px;"><input type="text" name="joueur_package_entreprise_nom" value="<?=$joueur_package_entreprise_nom?>" class="input" style="width: 470px;"></div>
						<br clear="all">
					</div>
					<div id="formulaire_ligne">
						<div id="formulaire_libelle_obligatoire">Adresse</div>
						<div id="formulaire_champ" style="width: 500px;">
							<input type="text" name="joueur_package_entreprise_adresse_1" value="<?=$joueur_package_entreprise_adresse_1?>" class="input" style="width: 470px; margin-bottom: 5px;"><br>
							<input type="text" name="joueur_package_entreprise_adresse_2" value="<?=$joueur_package_entreprise_adresse_2?>" class="input" style="width: 470px;">
						</div>
						<br clear="all">
					</div>
					<div id="formulaire_ligne">
						<div id="formulaire_libelle_obligatoire">Code postal</div>
						<div id="formulaire_champ" style="width: 195px;"><input type="text" name="joueur_package_entreprise_code_postal" value="<?=$joueur_package_entreprise_code_postal?>" class="input" style="width: 164px;"></div>
						<div id="formulaire_libelle_obligatoire" style="width: 90px;">Ville</div>
						<div id="formulaire_champ" style="width: 195px;"><input type="text" name="joueur_package_entreprise_ville" value="<?=$joueur_package_entreprise_ville?>" class="input" style="width: 164px;"></div>
						<br clear="all">
					</div>
					<div id="formulaire_ligne">
						<div id="formulaire_libelle_obligatoire">Pays</div>
						<div id="formulaire_champ" style="width: 500px;">
							<select name="joueur_package_entreprise_pays" size="1" class="select">
								<option value="0">-</option>
								<?php 
								// Sélection des pays
								$requete_pays = mysqli_query($connexion_mysql, 'SELECT pays_code, pays_libelle_FR FROM pays ORDER BY pays_libelle_FR');
								$nb_pays = mysqli_num_rows($requete_pays);
								if($nb_pays!=0){
									for($pays_boucle=0; $pays_boucle<$nb_pays; $pays_boucle++){
										$resultat_pays = mysqli_fetch_array($requete_pays);
										$pays_code = $resultat_pays[0];
										$pays_libelle = $resultat_pays[1];

										if($pays_code==$joueur_package_entreprise_pays){ $pays_selection = ' selected'; }else{ $pays_selection = ''; }

										echo '<option value="'.$pays_code.'"'.$pays_selection.'>'.$pays_libelle.'</option>'."\n";

									}
								}
								?>
							</select>
						</div>
						<br clear="all">
					</div>

				</div>


				<div id="formulaire_boutons"><input type="image" src="<?=$admin_img?>btn_enregistrer.png" width="150" height="32" align="absmiddle" style="margin: 15px 5px 20px 0px;"> ou&nbsp; <a href="./" class="lien_annuler">annuler</a></div>

			</form>

		</div>

	</div>
	<br clear="all">

</div></div>

<?php include $general_path_relatif.'sources/pied_page.inc'; ?>

<script language="Javascript">
	<!-- 
	document.ajouter.joueur_nom.focus();
	//-->
</script>

</body>
</html>
