<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(5, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(7, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


// Sélection de la compétition  (sélectionne la plus récente)
$requete_competition = mysqli_query($connexion_mysql, 'SELECT competition_date_debut, competition_date_fin, competition_golfs, competition_sponsor_1, competition_sponsor_2, competition_sponsor_3, competition_sponsor_4 FROM competitions WHERE competition_active=1 AND competition_archive=0 ORDER BY competition_annee DESC');
$nb_competitions = mysqli_num_rows($requete_competition);

if($nb_competitions!=0){
	$resultat_competition = mysqli_fetch_array($requete_competition);
	$competition_date_debut = $resultat_competition[0];
	$competition_date_fin = $resultat_competition[1];
	$competition_golfs = explode(',', $resultat_competition[2]);
}

// Sélection de la DATE DE DÉPART la plus grande  
// Sélectionne max Date du duo de tables scores (A) + planning (B) où A.planning_id = B.planning
$requete_date_max = mysqli_query($connexion_mysql, 'SELECT MAX(planning_depart_date) FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id');
$nb_date_max = mysqli_num_rows($requete_date_max);
if($nb_date_max!=0){
	$resultat_date_max = mysqli_fetch_array($requete_date_max);
	$date_max = $resultat_date_max[0];
}


// Critères par défaut
if(!isset($action)){ $critere_type_classement = 'brut'; }
if(!isset($critere_dates)){ $critere_dates = array('cumul'); }
if(!isset($critere_groupes)){ $critere_groupes = array(); }
if(!isset($critere_golfs)){ $critere_golfs = array(); }


$export_parametres = '?critere_type_classement='.$critere_type_classement.'&critere_dates='.implode(',', $critere_dates).'&critere_groupes='.implode(',', $critere_groupes).'&critere_groupes_separer=1&critere_golfs='.implode(',', $critere_golfs);

$where = '';
/*
if($critere_type_classement=='brut'){
	$ordre = 'score_joueur_brut_total';
	$ordre_9derniers = 'score_joueur_brut_retour';
	$ordre_6derniers = 'score_joueur_brut_total';
	$ordre_3derniers = 'score_joueur_brut_total';
}else{
	$ordre = 'score_joueur_net_total';
	$ordre_9derniers = 'score_joueur_net_retour';
	$ordre_6derniers = 'score_joueur_net_total';
	$ordre_3derniers = 'score_joueur_net_total';
}
*/



if($critere_type_classement=='brut'){
	$ordre = 'score_joueur_brut_total';
	$ordre_9derniers = 'score_joueur_brut_retour';
	$ordre_6derniers = 'score_joueur_brut_6derniers';
	$ordre_3derniers = 'score_joueur_brut_3derniers';
}else{
	$ordre = 'score_joueur_net_total';
	$ordre_9derniers = 'score_joueur_net_retour';
	$ordre_6derniers = 'score_joueur_net_6derniers';
	$ordre_3derniers = 'score_joueur_net_3derniers';
}



# ajoute CONTRAINTE <=> "afficher date" dans colonne de droite (front office)
if(isset($critere_dates) AND in_array('cumul', $critere_dates)==false){

	$where .= ' AND (';
	foreach($critere_dates as $date_cle=>$date_selection){
		$where .= 'planning_depart_date="'.$date_selection.'" OR ';
		$date_max = $date_selection;
	}
	$where = substr($where, 0, -4).')';

}else{
	$critere_dates = array('cumul');
}


# ajoute CONTRAINTE <=> "afficher groupe" dans colonne de droite (front office)
if(isset($critere_groupes) AND count($critere_groupes)!=0){

	$where .= ' AND (';
	foreach($critere_groupes as $groupe_cle=>$groupe_selection){
		$where .= 'planning_groupe="'.$groupe_selection.'" OR ';
	}
	$where = substr($where, 0, -4).')';

}


# ajoute CONTRAINTE <=> "afficher golf" dans colonne de droite (front office)
if(isset($critere_golfs) AND count($critere_golfs)!=0){

	$where .= ' AND (';
	foreach($critere_golfs as $golf_cle=>$golf_selection){
		$where .= 'golf_id='.$golf_selection.' OR ';
	}
	$where = substr($where, 0, -4).')';

}


// Sélection des joueurs enregistrés
$requete_scores = mysqli_query($connexion_mysql, 'SELECT A.equipe_id AS equipe_selection, SUM('.$ordre.'), planning_groupe FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE A.equipe_id!=""'.$where.' GROUP BY A.equipe_id ORDER BY SUM('.$ordre.'), (SELECT '.$ordre_9derniers.' FROM scores C INNER JOIN planning D ON C.planning_id=D.planning_id WHERE C.equipe_id=equipe_selection AND D.golf_id=1), (SELECT '.$ordre_6derniers.' FROM scores E INNER JOIN planning F ON E.planning_id=F.planning_id WHERE E.equipe_id=equipe_selection AND F.golf_id=1), (SELECT '.$ordre_3derniers.' FROM scores G INNER JOIN planning H ON G.planning_id=H.planning_id WHERE G.equipe_id=equipe_selection AND H.golf_id=1)');


/*
	$ordre = 'score_joueur_net_total';
	$ordre_9derniers = 'score_joueur_net_retour';
	$ordre_6derniers = 'score_joueur_net_6derniers';
	$ordre_3derniers = 'score_joueur_net_3derniers';*/


//$requete_scores = mysqli_query($connexion_mysql, 'SELECT A.equipe_id AS equipe_selection, SUM('.$ordre.'), planning_groupe FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE A.equipe_id!=""'.$where.' GROUP BY A.equipe_id ORDER BY SUM('.$ordre.'), SUM(CASE WHEN planning_depart_date = "'.$date_max.'" THEN score_joueur_net_total END), SUM(CASE WHEN planning_depart_date = "'.$date_max.'" THEN '.$ordre_9derniers.' END), SUM(CASE WHEN planning_depart_date = "'.$date_max.'" THEN '.$ordre_6derniers.' END), SUM(CASE WHEN planning_depart_date = "'.$date_max.'" THEN '.$ordre_3derniers.' END)');


//$requete_scores = mysqli_query($connexion_mysql, 'SELECT A.equipe_id AS equipe_selection, SUM('.$ordre.'), planning_groupe FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE A.equipe_id!=""'.$where.' GROUP BY A.equipe_id ORDER BY SUM('.$ordre.'), SUM(CASE WHEN golf_id = 1 THEN '.$ordre.' END), SUM(CASE WHEN golf_id = 1 THEN '.$ordre_9derniers.' END), SUM(CASE WHEN golf_id = 1 THEN '.$ordre_6derniers.' END), SUM(CASE WHEN golf_id = 1 THEN '.$ordre_3derniers.' END)');


//print_r('SELECT A.equipe_id AS equipe_selection, SUM('.$ordre.'), planning_groupe FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE A.equipe_id!=""'.$where.' GROUP BY A.equipe_id ORDER BY SUM('.$ordre.'), SUM(CASE WHEN golf_id = 1 THEN score_joueur_net_total END), SUM(CASE WHEN golf_id = 1 THEN '.$ordre_9derniers.' END), SUM(CASE WHEN golf_id = 1 THEN '.$ordre_6derniers.' END), SUM(CASE WHEN golf_id = 1 THEN '.$ordre_3derniers.' END)');

$nb_scores = mysqli_num_rows($requete_scores);

// $score_numero_affichage = 0;
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none">
</head>

<body>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2" style="width: 1340px;">

	<div id="contenu_3" align="left" style="width: 1026px;">

		<div id="titres">
			<span class="titre_1" style="width: 557px;">Classement cumulé</span>
			<?php if($nb_scores!=0){ ?>
				<span class="ajouter" style="width: 200px; margin-right: 40px;"><a href="./exporter_brut_net.php<?=$export_parametres?>" target="_blank">Exporter Brut & Net&nbsp; (PDF)</a></span>
				<?php if(isset($critere_groupes_separer) AND $critere_groupes_separer==1){ ?>
					<span class="ajouter" style="width: 205px;"><a href="./exporter_selection_groupes.php<?=$export_parametres?>" target="_blank">Exporter la sélection&nbsp; (PDF)</a></span>
				<?php }else{ ?>
					<span class="ajouter" style="width: 205px;"><a href="./exporter_selection.php<?=$export_parametres?>" target="_blank">Exporter la sélection&nbsp; (PDF)</a></span>
				<?php } ?>
			<?php } ?>
		</div>
		<br clear="all">

		<div id="bloc" style="display:flex;flex-direction: column;">

			<?php if($nb_scores!=0){ ?>

				<div id="ligne_entete">
					<div style="float: left; width: 50px;" title="Numéro">N°</div>
					<div style="float: left; width: 140px; padding-left: 10px; border-left: 1px solid #CCCCCC;" title="Équipe">&Eacute;QUIPE</div>
					<div style="float: left; width: 160px; padding-left: 10px; border-left: 1px solid #CCCCCC;" title="Équipe">PROFESSIONNEL</div>
					<div style="float: left; width: 470px; padding-left: 10px; border-left: 1px solid #CCCCCC;" title="Joueurs">JOUEURS</div>
					<div align="center" style="float: left; width: 70px; border-left: 1px solid #CCCCCC;" title="Groupe">GROUPE</div>
					<div align="center" style="float: left; width: 90px; border-left: 1px solid #CCCCCC;" title="Cumul <?=$critere_type_classement?>">CUMUL <?=strtoupper($critere_type_classement)?></div>
				</div>

			<?php 
				for($score_boucle=0; $score_boucle<$nb_scores; $score_boucle++){
					$resultat_score = mysqli_fetch_array($requete_scores);
					$equipe_id = $resultat_score[0];
					$score_joueur_total = $resultat_score[1];
					$planning_groupe = $resultat_score[2];

//					if(!isset($score_joueur_total_precedent) OR (isset($score_joueur_total_precedent) AND $score_joueur_total_precedent!=$score_joueur_total)){
//						$score_numero_affichage = $score_numero_affichage + 1;
//					}

					$score_joueur_total_precedent = $score_joueur_total;

					$liste_joueurs = '';

					// Sélection l'équipe du joueur
					$requete_equipe = mysqli_query($connexion_mysql, 'SELECT equipe_nom FROM equipes_joueurs A INNER JOIN equipes B ON A.ej_equipe=B.equipe_id WHERE ej_equipe="'.$equipe_id.'"');
					$resultat_equipe = mysqli_fetch_array($requete_equipe);
					$equipe_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_equipe[0])));

					// Sélection des joueurs de l'équipe
					$requete_joueurs = mysqli_query($connexion_mysql, 'SELECT joueur_nom, joueur_prenom, joueur_handicap, joueur_profil FROM joueurs A INNER JOIN equipes_joueurs B ON A.joueur_id=B.ej_joueur WHERE ej_equipe="'.$equipe_id.'" AND joueur_profil<>"acc"');
					$nb_joueurs = mysqli_num_rows($requete_joueurs);
					if($nb_joueurs!=0){
						for($joueur_boucle=0; $joueur_boucle<$nb_joueurs; $joueur_boucle++){
							$resultat_joueur = mysqli_fetch_array($requete_joueurs);
							$joueur_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[0])));
							$joueur_prenom = ucwords(strtolower(decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[1])))));
							// $joueur_prenom = substr(decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[1]))), 0, 1).'.';
							$joueur_handicap = number_format($resultat_joueur[2], 1, ',', '');
							$joueur_profil = $resultat_joueur[3];

							// Permet de mettre la 1ere lettre en majuscule si le prénom est composé (avec -)
							if(preg_match('/-/', $joueur_prenom)==true){
								$joueur_prenom_tab = explode('-', $joueur_prenom);
								$joueur_prenom = '';
								foreach($joueur_prenom_tab as $joueur_prenom_morceau){
									$joueur_prenom .= ucwords(strtolower($joueur_prenom_morceau)).'-';
								}
								$joueur_prenom = substr($joueur_prenom, 0, -1);
							}

							$joueur_nom_prenom = $joueur_nom.' '.$joueur_prenom;
							if(strlen($joueur_nom_prenom)>22){  $joueur_nom_prenom = substr($joueur_nom_prenom, 0, 22).'.'; }

							if(substr($joueur_handicap, -2)==',0'){ $joueur_handicap = preg_replace('/,0/', '', $joueur_handicap); }

							if($joueur_profil=='am'){
								$liste_joueurs .= $joueur_nom_prenom.' ('.$joueur_handicap.') &nbsp;-&nbsp; ';
							}elseif($joueur_profil=='pro'){
								$joueur_professionnel = $joueur_nom_prenom;
							}
						}
						$liste_joueurs = substr($liste_joueurs, 0, -15);
					}

			?>

					<div id="ligne">
						<div style="float: left; width: 50px;" title="N°"><b><?=$score_boucle+1?></b></div>
						<div style="float: left; width: 140px; padding-left: 10px; border-left: 1px solid #CCCCCC;" title="Équipe"><b><?=$equipe_nom?></b></div>
						<div style="float: left; width: 160px; padding-left: 10px; border-left: 1px solid #CCCCCC; font-size: 11px;" title="Équipe"><b><?=$joueur_professionnel?></b></div>
						<div style="float: left; width: 470px; padding-left: 10px; border-left: 1px solid #CCCCCC; font-size: 11px;" title="Joueurs"><?=$liste_joueurs?></div>
						<div align="center" style="float: left; width: 70px; border-left: 1px solid #CCCCCC;" title="Groupe"><?=$planning_groupe?></div>
						<div align="center" style="float: left; width: 90px; border-left: 1px solid #CCCCCC;" title="Cumul <?=$critere_type_classement?>"><b><?=$score_joueur_total?></b></div>
					</div>

			<?php 
				}
			}else{
				if(isset($action) AND $action=='rechercher'){
					echo '<div id="ligne">aucun score correspond à votre recherche</div>'."\n";
				}else{
					echo '<div id="ligne">aucun score enregistré</div>'."\n";
				}
			}
			?>

		</div>

	</div>

	<div id="contenu_secondaire">

		<form action="<?=$PHP_SELF?>" method="post">

			<input type="hidden" name="action" value="rechercher">

			<div class="titre">type du classement</div>

			<input type="radio" id="affichage_type_brut" name="critere_type_classement" value="brut"<?php if(!isset($critere_type_classement) OR (isset($critere_type_classement) AND $critere_type_classement=='brut')){ echo ' checked'; } ?>>&nbsp; <label for="affichage_type_brut">Classement BRUT</label><br>
			<img src="<?=$admin_img?>p.gif" width="1" height="5"><br>
			<input type="radio" id="affichage_type_net" name="critere_type_classement" value="net"<?php if(isset($critere_type_classement) AND $critere_type_classement=='net'){ echo ' checked'; } ?>>&nbsp; <label for="affichage_type_net">Classement NET</label><br>

			<img src="<?=$admin_img?>p.gif" width="1" height="5"><br>

			<div class="titre">afficher une date</div>

			<?php 
			// Sélection des dates enregistrées
			$requete_dates = mysqli_query($connexion_mysql, 'SELECT DISTINCT(planning_depart_date) FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id ORDER BY planning_depart_date');
			$nb_dates = mysqli_num_rows($requete_dates);
			if($nb_dates!=0){

				if(isset($critere_dates) AND in_array('cumul', $critere_dates)==true){ $date_competition_checked = ' checked'; }else{ $date_competition_checked = ''; }

				echo '<input type="checkbox" id="affichage_date_cumul" name="critere_dates[]" value="cumul"'.$date_competition_checked.'>&nbsp; <label for="affichage_date_cumul">Toutes les dates</label><br>'."\n";
				echo '<img src="'.$admin_img.'p.gif" width="1" height="5"><br>'."\n\n";

				for($date_boucle=0; $date_boucle<$nb_dates; $date_boucle++){
					$resultat_date = mysqli_fetch_array($requete_dates);
					$date_competition = $resultat_date[0];

					$tab_date_competition = explode('-', $date_competition);
					$date_competition_libelle = $tab_date_competition[2].'/'.$tab_date_competition[1].'/'.$tab_date_competition[0];

					if(isset($critere_dates) AND in_array($date_competition, $critere_dates)==true){ $date_competition_checked = ' checked'; }else{ $date_competition_checked = ''; }

					echo '<img src="'.$admin_img.'p.gif" width="1" height="3"><br>'."\n";
					echo '<input type="checkbox" id="affichage_date_'.$date_boucle.'" name="critere_dates[]" value="'.$date_competition.'"'.$date_competition_checked.'>&nbsp; <label for="affichage_date_'.$date_boucle.'">'.$date_competition_libelle.'</label><br>'."\n";

				}
			}else{
				echo 'aucune date<br>';
			}
			?>
			<img src="<?=$admin_img?>p.gif" width="1" height="5"><br>

			<div class="titre">afficher un groupe</div>

			<?php 
			$requete_groupes = mysqli_query($connexion_mysql, 'SELECT DISTINCT(planning_groupe) FROM planning ORDER BY planning_groupe');
			$nb_groupes = mysqli_num_rows($requete_groupes);
			if($nb_groupes!=0){
				for($groupe_boucle=0; $groupe_boucle<$nb_groupes; $groupe_boucle++){
					$resultat_groupe = mysqli_fetch_array($requete_groupes);
					$competition_groupe = $resultat_groupe[0];

					if(isset($critere_groupes) AND in_array($competition_groupe, $critere_groupes)==true){ $competition_groupe_checked = ' checked'; }else{ $competition_groupe_checked = ''; }

					echo '<input type="checkbox" id="affichage_groupe_'.$competition_groupe.'" name="critere_groupes[]" value="'.$competition_groupe.'"'.$competition_groupe_checked.'> <label for="affichage_groupe_'.$competition_groupe.'">Groupe '.$competition_groupe.'</label><br>'."\n";
					if($groupe_boucle!=($nb_groupes-1)){ echo '<img src="'.$admin_img.'p.gif" width="1" height="3"><br>'."\n"; }

				}

				if(isset($critere_groupes_separer) AND $critere_groupes_separer==1){ $critere_groupes_separer_checked = ' checked'; }else{ $critere_groupes_separer_checked = ''; }

				echo '<br>'."\n";
				echo '<input type="checkbox" id="affichage_separer_par_groupe" name="critere_groupes_separer" value="1"'.$critere_groupes_separer_checked.'> <label for="affichage_separer_par_groupe">séparer les résultats<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; par groupe dans l\'export<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; de la sélection</label><br>'."\n";

			}else{
				echo 'aucun groupe<br>';
			}
			?>
			<img src="<?=$admin_img?>p.gif" width="1" height="5"><br>

			<div class="titre">afficher un golf</div>

			<?php 
			$requete_golfs = mysqli_query($connexion_mysql, 'SELECT DISTINCT(golf_id) AS competition_golf_id, (SELECT golf_nom FROM golfs WHERE golf_id=competition_golf_id) AS golf_nom FROM planning ORDER BY golf_nom');
			$nb_golfs = mysqli_num_rows($requete_golfs);
			if($nb_golfs!=0){
				for($golf_boucle=0; $golf_boucle<$nb_golfs; $golf_boucle++){
					$resultat_golf = mysqli_fetch_array($requete_golfs);
					$competition_golf = $resultat_golf[0];
					$competition_golf_nom = $resultat_golf[1];

					if(isset($critere_golfs) AND in_array($competition_golf, $critere_golfs)==true){ $competition_golf_checked = ' checked'; }else{ $competition_golf_checked = ''; }

					echo '<input type="checkbox" id="affichage_golf_'.$competition_golf.'" name="critere_golfs[]" value="'.$competition_golf.'"'.$competition_golf_checked.'> <label for="affichage_golf_'.$competition_golf.'">'.$competition_golf_nom.'</label><br>'."\n";
					if($golf_boucle!=($nb_golfs-1)){ echo '<img src="'.$admin_img.'p.gif" width="1" height="3"><br>'."\n"; }

				}
			}else{
				echo 'aucun golf<br>';
			}
			?>

			<img src="<?=$admin_img?>p.gif" width="100%" height="1" style="background-color: #807D73; margin: 20px 0px 20px 0px;"><br>

			<center><input type="submit" value="valider" style="width: 100px;"></center>

		</form>

	</div>
	<br clear="all">

</div></div>


<?php include $general_path_relatif.'sources/pied_page.inc'; ?>

</body>
</html>
