<?php 
include '../lib/configuration.inc';

if(!isset($_SESSION['SessionWeb_joueur_id'])){
	header('Location: ./compte_deconnexion.php');
	exit;
}


if(isset($autorisation) AND $autorisation=='compte'){

	if(strlen(trim($joueur_email))!=0){
		// Vérification si l'adresse e-mail existe
		$requete_verification_email = mysqli_query($connexion_mysql, 'SELECT joueur_id FROM joueurs WHERE joueur_email="'.$joueur_email.'"');
		$nb_verification_email = mysqli_num_rows($requete_verification_email);
	}

	if(isset($nb_verification_email) AND $nb_verification_email!=0 AND $joueur_email!=$joueur_email_ancien){
		$formulaire_erreur[] = 'joueur_email_inscrit';
	}else{

		if(strlen(trim($joueur_sexe))==0){
			$formulaire_erreur[] = 'joueur_sexe';
		}
		if(strlen(trim($joueur_nom))==0){
			$formulaire_erreur[] = 'joueur_nom';
		}
		if(strlen(trim($joueur_prenom))==0){
			$formulaire_erreur[] = 'joueur_prenom';
		}
		if(strlen(trim($joueur_date_naissance))!=0 AND preg_match('/\//', $joueur_date_naissance)==true){
			$joueur_date_naissance_tab = explode('/', $joueur_date_naissance);
			if(count($joueur_date_naissance_tab)!=3 OR strlen($joueur_date_naissance_tab[0])!=2 OR strlen($joueur_date_naissance_tab[1])!=2 OR strlen($joueur_date_naissance_tab[2])!=4){
				$formulaire_erreur[] = 'joueur_date_naissance_incorrecte';
			}
		}elseif(strlen(trim($joueur_date_naissance))!=0 AND preg_match('/\//', $joueur_date_naissance)==false){
			$formulaire_erreur[] = 'joueur_date_naissance_incorrecte';
		}
		if($joueur_taille_polo=='0'){
			$formulaire_erreur[] = 'joueur_taille_polo';
		}
		if(strlen(trim($joueur_adresse_1))==0){
			$formulaire_erreur[] = 'joueur_adresse_1';
		}
		if(strlen(trim($joueur_code_postal))==0){
			$formulaire_erreur[] = 'joueur_code_postal';
		}
		if(strlen(trim($joueur_ville))==0){
			$formulaire_erreur[] = 'joueur_ville';
		}
		if($joueur_pays=='0'){
			$formulaire_erreur[] = 'joueur_pays';
		}
		if(strlen(trim($joueur_email))==0){
			$formulaire_erreur[] = 'joueur_email';
		}elseif(preg_match('/@/', $joueur_email)==false OR preg_match('/\./', $joueur_email)==false){
			$formulaire_erreur[] = 'joueur_email_incorrect';
		}
		if(strlen(trim($joueur_mobile))==0){
			$formulaire_erreur[] = 'joueur_mobile';
		}
		if(strlen(trim($joueur_motdepasse_1))==0 AND strlen(trim($joueur_motdepasse_2))!=0){
			$formulaire_erreur[] = 'joueur_motdepasse_1';
		}elseif((strlen(trim($joueur_motdepasse_1))!=0 AND strlen(trim($joueur_motdepasse_2))!=0) AND strlen(trim($joueur_motdepasse_1))<8){
			$formulaire_erreur[] = 'joueur_motdepasse_1_incorrect';
		}elseif(strlen(trim($joueur_motdepasse_1))!=strlen(trim($joueur_motdepasse_2))){
			$formulaire_erreur[] = 'joueur_motdepasses_differents';
		}

	}

	if(count($formulaire_erreur)==0){

		// Traitement des informations pour enregistrement en base de données
		$joueur_code_postal = enregistrement_chiffres($joueur_code_postal);
		$joueur_telephone = enregistrement_chiffres($joueur_telephone);
		$joueur_mobile = enregistrement_chiffres($joueur_mobile);

		$joueur_club = htmlentities(ucfirst(stripslashes($joueur_club)), ENT_QUOTES);
		$joueur_licence = htmlentities(strtoupper_max(stripslashes($joueur_licence)), ENT_QUOTES);
		if(preg_match('/./', $joueur_handicap)==true){ $joueur_handicap = preg_replace('/,/', '.', $joueur_handicap); }
		$joueur_nom = htmlentities(strtoupper_max(stripslashes($joueur_nom)), ENT_QUOTES);
		$joueur_prenom = htmlentities(ucfirst(strtolower_max(stripslashes($joueur_prenom))), ENT_QUOTES);
		$joueur_email = strtolower_max(stripslashes(stripslashes($joueur_email)));
		$joueur_adresse_1 = htmlentities(ucfirst(stripslashes($joueur_adresse_1)), ENT_QUOTES);
		$joueur_adresse_2 = htmlentities(ucfirst(stripslashes($joueur_adresse_2)), ENT_QUOTES);
		$joueur_code_postal = strtolower_max(stripslashes($joueur_code_postal));
		$joueur_ville = htmlentities(strtoupper_max(stripslashes($joueur_ville)), ENT_QUOTES);
		$joueur_mobile = strtolower_max(stripslashes($joueur_mobile));
		$joueur_telephone = strtolower_max(stripslashes($joueur_telephone));
		$joueur_motdepasse_crypte = md5($joueur_motdepasse_1);

		if($_SESSION['SessionWeb_joueur_profil']=='pro'){
			$requete_joueur_handicap = 'NULL';
		}elseif($joueur_handicap_validation==0){
			$requete_joueur_handicap = '"'.$joueur_handicap.'"';
		}


		// Modification du joueur en base de données
		$requete_modification_joueur = mysqli_query($connexion_mysql, 'UPDATE joueurs SET joueur_club="'.$joueur_club.'", joueur_licence="'.$joueur_licence.'", joueur_handicap='.$requete_joueur_handicap.', joueur_sexe="'.$joueur_sexe.'", joueur_nom="'.$joueur_nom.'", joueur_prenom="'.$joueur_prenom.'", joueur_date_naissance=STR_TO_DATE("'.$joueur_date_naissance.'", "%d/%m/%Y"), joueur_taille_polo="'.$joueur_taille_polo.'", joueur_adresse_1="'.$joueur_adresse_1.'", joueur_adresse_2="'.$joueur_adresse_2.'", joueur_code_postal="'.$joueur_code_postal.'", joueur_ville="'.$joueur_ville.'", joueur_pays="'.$joueur_pays.'", joueur_email="'.$joueur_email.'", joueur_mobile="'.$joueur_mobile.'", joueur_telephone="'.$joueur_telephone.'" WHERE joueur_id="'.$_SESSION['SessionWeb_joueur_id'].'"');

		// Récupération de l'ID de l'équipe du joueur
		$requete_selection_equipe = mysqli_query($connexion_mysql, 'SELECT ej_equipe FROM equipes_joueurs WHERE ej_joueur="'.$_SESSION['SessionWeb_joueur_id'].'"');
		$requete_selection_equipe = mysqli_fetch_array($requete_selection_equipe);
		$equipe_id = $requete_selection_equipe[0];

		if($_SESSION['SessionWeb_joueur_profil']=='pro'){

			// Traitement des informations pour enregistrement en base de données
			$equipe_nom = $joueur_nom;

			// Modification du nom de l'équipe en base de données
			$requete_creation_equipe = mysqli_query($connexion_mysql, 'UPDATE equipes SET equipe_nom="'.$equipe_nom.'" WHERE equipe_id="'.$equipe_id.'"');

		}

		if(strlen(trim($joueur_motdepasse_1))!=0 AND strlen(trim($joueur_motdepasse_2))!=0){

			// Modification du mot de passe de l'équipe en base de données
			$requete_creation_equipe = mysqli_query($connexion_mysql, 'UPDATE equipes SET equipe_motdepasse="'.$joueur_motdepasse_crypte.'" WHERE equipe_id="'.$equipe_id.'"');

		}

		$_SESSION['SessionWeb_joueur_nom'] = decodage_apostrophe(html_entity_decode(stripslashes($joueur_nom)));
		$_SESSION['SessionWeb_joueur_prenom'] = decodage_apostrophe(html_entity_decode(stripslashes($joueur_prenom)));

		$confirmation = 1;

	}else{
		// Traitement d'affichage en cas d'erreur dans le formulaire
		$joueur_club = stripslashes($joueur_club);
		$joueur_licence = stripslashes($joueur_licence);
		$joueur_handicap = stripslashes($joueur_handicap);
		$joueur_nom = stripslashes($joueur_nom);
		$joueur_prenom = stripslashes($joueur_prenom);
		$joueur_date_naissance = stripslashes($joueur_date_naissance);
		$joueur_adresse_1 = stripslashes($joueur_adresse_1);
		$joueur_adresse_2 = stripslashes($joueur_adresse_2);
		$joueur_code_postal = stripslashes($joueur_code_postal);
		$joueur_ville = stripslashes($joueur_ville);
		$joueur_email = stripslashes($joueur_email);
		$joueur_mobile = stripslashes($joueur_mobile);
		$joueur_telephone = stripslashes($joueur_telephone);
	}

}


if(!isset($autorisation) OR (isset($autorisation) AND $autorisation!='compte')){

	// Sélection des informations du joueur
	$requete_joueur = mysqli_query($connexion_mysql, 'SELECT joueur_club, joueur_licence, joueur_handicap, joueur_sexe, DATE_FORMAT(joueur_date_naissance, "%d/%m/%Y"), joueur_taille_polo, joueur_adresse_1, joueur_adresse_2, joueur_code_postal, joueur_ville, joueur_pays, joueur_email, joueur_mobile, joueur_telephone, joueur_handicap_validation FROM joueurs WHERE joueur_id="'.$_SESSION['SessionWeb_joueur_id'].'"');
	$resultat_joueur = mysqli_fetch_array($requete_joueur);
	$joueur_club = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[0])));
	$joueur_licence = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[1])));
	$joueur_handicap = $resultat_joueur[2];
	$joueur_sexe = $resultat_joueur[3];
	$joueur_date_naissance = $resultat_joueur[4];
	$joueur_taille_polo = $resultat_joueur[5];
	$joueur_adresse_1 = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[6])));
	$joueur_adresse_2 = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[7])));
	$joueur_code_postal = $resultat_joueur[8];
	$joueur_ville = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[9])));
	$joueur_pays = $resultat_joueur[10];
	$joueur_email = $resultat_joueur[11];
	$joueur_mobile = $resultat_joueur[12];
	$joueur_telephone = $resultat_joueur[13];
	$joueur_handicap_validation = $resultat_joueur[14];

	$joueur_nom = $_SESSION['SessionWeb_joueur_nom'];
	$joueur_prenom = $_SESSION['SessionWeb_joueur_prenom'];

	if($joueur_date_naissance=='00/00/0000'){ $joueur_date_naissance = ''; }
	if($joueur_handicap==NULL){ $joueur_handicap = ''; }else{ $joueur_handicap = number_format($joueur_handicap, 1, ',', ''); }

}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="<?=$_SESSION['SessionWeb_langue']?>" xml:lang="<?=strtolower($_SESSION['SessionWeb_langue'])?>">
<head>
	<title><?=$txt_espace_equipe_titre?></title>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=8">
	<meta name="language" content="<?=strtolower($_SESSION['SessionWeb_langue'])?>">
	<meta name="robots" content="index, follow">
	<link rel="shortcut icon" type="image/x-icon" href="/favicon.ico">
	<link rel="shortcut icon" href="/favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$web_commun?>commun.css">
</head>

<body scroll="auto">

<div id="page" align="center">

	<div id="contenu">

		<?php $espace='equipe'; include './commun/entete.inc'; ?>

		<div id="contenu_bis">

			<div id="menu">

				<?php include './commun/menu.inc'; ?>

			</div>

			<div id="formulaire_bis">

				<h1><?=$txt_espace_equipe_informations_titre?></h1>

				<?php 
				if(isset($confirmation) AND $confirmation==1){
					echo '<div class="separateur"></div>';
					echo '<div class="confirmation">'.$txt_espace_equipe_informations_modifications_prises_en_compte.'</div>';
				}

				if(count($formulaire_erreur)!=0 AND in_array('joueur_email_inscrit', $formulaire_erreur)==true){
					echo '<div class="separateur"></div>';
					echo '<div class="erreur" align="center" style="width: 600px; padding-left: 0px; margin: 0px 0px 10px 0px;">'.$txt_espace_equipe_informations_email_deja_inscrite.'</div><br clear="all">';

				}
				?>

				<form action="<?=$REQUEST_URI?>" method="post">

					<input type="hidden" name="autorisation" value="compte">
					<?php if($joueur_handicap_validation==1){ ?>
						<input type="hidden" name="joueur_club" value="<?=$joueur_club?>">
						<input type="hidden" name="joueur_licence" value="<?=$joueur_licence?>">
						<input type="hidden" name="joueur_handicap" value="<?=$joueur_handicap?>">
						<input type="hidden" name="joueur_handicap_validation" value="<?=$joueur_handicap_validation?>">
					<?php } ?>
					<input type="hidden" name="joueur_email_ancien" value="<?=$joueur_email?>">

					<?php if($joueur_handicap_validation==0){ ?>

						<div class="separateur"></div>

						<div class="colonne_gauche"><?=$txt_espace_equipe_informations_club?> :</div>
						<div class="colonne_droite"><input type="text" name="joueur_club" value="<?=$joueur_club?>"></div>
						<br clear="all">

						<div class="colonne_gauche"><?=$txt_espace_equipe_informations_numero_licence?> :</div>
						<div class="colonne_droite"><input type="text" name="joueur_licence" value="<?=$joueur_licence?>"></div>
						<br clear="all">

						<?php if($_SESSION['SessionWeb_joueur_profil']!='pro'){ ?>

							<div class="colonne_gauche"><?=$txt_espace_equipe_informations_handicap?> :</div>
							<div class="colonne_droite"><input type="text" name="joueur_handicap" value="<?=$joueur_handicap?>" style="width: 50px;"></div>
							<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_handicap', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; } ?>
							<br clear="all">

						<?php } ?>

					<?php }else{ ?>

						<div class="separateur"></div>

						<div class="colonne_gauche"><?=$txt_espace_equipe_informations_club?> :</div>
						<div class="colonne_droite" style="padding-top: 5px; height: 35px;"><?=$joueur_club?></div>
						<br clear="all">

						<div class="colonne_gauche"><?=$txt_espace_equipe_informations_numero_licence?> :</div>
						<div class="colonne_droite" style="padding-top: 5px; height: 35px;"><?=$joueur_licence?></div>
						<br clear="all">

						<?php if($_SESSION['SessionWeb_joueur_profil']!='pro'){ ?>

							<div class="colonne_gauche"><?=$txt_espace_equipe_informations_handicap?> :</div>
							<div class="colonne_droite" style="padding-top: 5px; height: 35px;"><?=$joueur_handicap?><span style="margin-left: 100px; font-size: 11px; font-style: italic; color: green;"><?=$txt_espace_equipe_informations_handicap_valide?></span></div>
							<br clear="all">

						<?php } ?>

					<?php } ?>

					<div class="separateur"></div>

					<div class="colonne_gauche_obligatoire" style="height: 33px; padding-top: 0px;"><?=$txt_espace_equipe_informations_vous_etes?> :</div>
					<div class="colonne_droite" style="height: 33px;">
						<input type="radio" id="joueur_sexe_homme" name="joueur_sexe" value="H"<?php if($joueur_sexe=='H'){ echo ' checked'; } ?>> <label for="joueur_sexe_homme"><?=$txt_espace_equipe_informations_homme?></label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
						<input type="radio" id="joueur_sexe_femme" name="joueur_sexe" value="F"<?php if($joueur_sexe=='F'){ echo ' checked'; } ?>> <label for="joueur_sexe_femme"><?=$txt_espace_equipe_informations_femme?></label>
					</div>
					<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_sexe', $formulaire_erreur)==true){ echo '<div class="erreur" style="margin-top: 0px;">'.$txt_obligatoire.'</div>'; } ?>
					<br clear="all">

					<div class="colonne_gauche_obligatoire"><?=$txt_espace_equipe_informations_nom?> :</div>
					<div class="colonne_droite"><input type="text" name="joueur_nom" value="<?=$joueur_nom?>"></div>
					<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_nom', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; } ?>
					<br clear="all">

					<div class="colonne_gauche_obligatoire"><?=$txt_espace_equipe_informations_prenom?> :</div>
					<div class="colonne_droite"><input type="text" name="joueur_prenom" value="<?=$joueur_prenom?>"></div>
					<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_prenom', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; } ?>
					<br clear="all">

					<div class="<?php if($_SESSION['SessionWeb_joueur_profil']=='am'){ echo 'colonne_gauche_obligatoire'; }else{ echo 'colonne_gauche'; } ?>"><?=$txt_espace_equipe_informations_date_naissance?> :</div>
					<div class="colonne_droite"><input type="text" name="joueur_date_naissance" value="<?=$joueur_date_naissance?>" style="width: 80px;"><span class="indication"><?=$txt_date_format?></span></div>
					<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_date_naissance', $formulaire_erreur)==true AND $_SESSION['SessionWeb_joueur_profil']=='am'){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; }elseif(count($formulaire_erreur)!=0 AND in_array('joueur_date_naissance_incorrecte', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_incorrecte.'</div>'; } ?>
					<br clear="all">

					<div class="colonne_gauche_obligatoire"><?=$txt_espace_equipe_informations_taille_polo?> :</div>
					<div class="colonne_droite">
						<select name="joueur_taille_polo" size="1" style="width: 90px;">
							<option value="0">-</option>
							<option value="NC"<?php if(isset($joueur_taille_polo) AND $joueur_taille_polo=='NC'){ echo ' selected'; } ?>><?=$txt_espace_equipe_informations_nom_communique?></option>
							<option value="S"<?php if(isset($joueur_taille_polo) AND $joueur_taille_polo=='S'){ echo ' selected'; } ?>>S</option>
							<option value="M"<?php if(isset($joueur_taille_polo) AND $joueur_taille_polo=='M'){ echo ' selected'; } ?>>M</option>
							<option value="L"<?php if(isset($joueur_taille_polo) AND $joueur_taille_polo=='L'){ echo ' selected'; } ?>>L</option>
							<option value="XL"<?php if(isset($joueur_taille_polo) AND $joueur_taille_polo=='XL'){ echo ' selected'; } ?>>XL</option>
							<option value="XXL"<?php if(isset($joueur_taille_polo) AND $joueur_taille_polo=='XXL'){ echo ' selected'; } ?>>XXL</option>
						</select>
					</div>
					<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_taille_polo', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; } ?>
					<br clear="all">

					<div class="colonne_gauche_obligatoire"><?=$txt_espace_equipe_informations_adresse_postale?> :</div>
					<div class="colonne_droite"><input type="text" name="joueur_adresse_1" value="<?=$joueur_adresse_1?>"></div>
					<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_adresse_1', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; } ?>
					<br clear="all">

					<div class="colonne_gauche">&nbsp;</div>
					<div class="colonne_droite"><input type="text" name="joueur_adresse_2" value="<?=$joueur_adresse_2?>"></div>
					<br clear="all">

					<div class="colonne_gauche_obligatoire"><?=$txt_espace_equipe_informations_code_postal?> :</div>
					<div class="colonne_droite"><input type="text" name="joueur_code_postal" value="<?=$joueur_code_postal?>" style="width: 100px;"></div>
					<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_code_postal', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; } ?>
					<br clear="all">

					<div class="colonne_gauche_obligatoire"><?=$txt_espace_equipe_informations_ville?> :</div>
					<div class="colonne_droite"><input type="text" name="joueur_ville" value="<?=$joueur_ville?>"></div>
					<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_ville', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; } ?>
					<br clear="all">

					<div class="colonne_gauche_obligatoire"><?=$txt_espace_equipe_informations_pays?> :</div>
					<div class="colonne_droite">
						<select name="joueur_pays" size="1" class="select">
							<option value="0"><?=$txt_selectionnez?></option>
							<?php 
							// Sélection des pays
							$requete_pays = mysqli_query($connexion_mysql, 'SELECT pays_code, pays_libelle_'.$_SESSION['SessionWeb_langue'].' FROM pays ORDER BY pays_libelle_'.$_SESSION['SessionWeb_langue']);
							$nb_pays = mysqli_num_rows($requete_pays);
							if($nb_pays!=0){
								for($pays_boucle=0; $pays_boucle<$nb_pays; $pays_boucle++){
									$resultat_pays = mysqli_fetch_array($requete_pays);
									$pays_code = $resultat_pays[0];
									$pays_libelle = $resultat_pays[1];

									if($pays_code==$joueur_pays){ $pays_selection = ' selected'; }else{ $pays_selection = ''; }

									echo '<option value="'.$pays_code.'"'.$pays_selection.'>'.$pays_libelle.'</option>'."\n";

								}
							}
							?>
						</select>
					</div>
					<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_pays', $formulaire_erreur)==true){ echo '<div class="erreur" style="margin-top: 6px;">'.$txt_obligatoire.'</div>'; } ?>
					<br clear="all">

					<div class="separateur"></div>

					<div class="colonne_gauche_obligatoire"><?=$txt_espace_equipe_informations_email?> :</div>
					<div class="colonne_droite"><input type="text" name="joueur_email" value="<?=$joueur_email?>"></div>
					<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_email', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; }elseif(count($formulaire_erreur)!=0 AND in_array('joueur_email_incorrect', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_incorrect.'</div>'; }elseif(count($formulaire_erreur)!=0 AND in_array('joueur_email_inscrit', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_deja_inscrit.'</div>'; } ?>
					<br clear="all">

					<div class="colonne_gauche"><?=$txt_espace_equipe_informations_mobile?> :</div>
					<div class="colonne_droite"><input type="text" name="joueur_mobile" value="<?=$joueur_mobile?>"></div>
					<br clear="all">

					<div class="colonne_gauche"><?=$txt_espace_equipe_informations_telephone?> :</div>
					<div class="colonne_droite"><input type="text" name="joueur_telephone" value="<?=$joueur_telephone?>"></div>
					<br clear="all">

					<div class="separateur"></div>

					<?=$txt_espace_equipe_informations_remplacez_motdepasse?> :<br><br>

					<div class="colonne_gauche_obligatoire"><?=$txt_espace_equipe_informations_nouveau_motdepasse?> :</div>
					<div class="colonne_droite" style="width: 350px;"><input type="password" name="joueur_motdepasse_1" style="width: 150px;"><span class="indication"><?=$txt_espace_equipe_informations_8_caracteres_mini?></span></div>
					<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_motdepasse_1', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; }elseif(count($formulaire_erreur)!=0 AND in_array('joueur_motdepasse_1_incorrect', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_incorrect.'</div>'; } ?>
					<br clear="all">

					<div class="colonne_gauche_obligatoire"><?=$txt_espace_equipe_informations_resaisissez_le?> :</div>
					<div class="colonne_droite" style="width: 160px;"><input type="password" name="joueur_motdepasse_2" style="width: 150px;"></div>
					<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_motdepasses_differents', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_espace_equipe_informations_2_motsdepasse_pas_identiques.'</div>'; } ?>
					<br clear="all">

					<div class="separateur"></div>

					<input type="submit" value="<?=$txt_espace_equipe_informations_bouton_valider?>" style="margin-left: 180px;">

				</form>

				<br><br><br>
				<?=$txt_champs_obligatoires_vert?><br>
			</div>
			<br clear="all">

		</div>

	</div>

</div>

</body>
</html>
