<?php 
include '../lib/configuration.inc';


// Redirection vers la page de compte si le joueur est toujours identifié
if(isset($_SESSION['SessionWeb_joueur_id']) AND strlen(trim($_SESSION['SessionWeb_joueur_id']))!=0){
	header('Location: ./compte.php');
}


// Détection si l'appareil est un mobile (smartphone), si oui alors redirection vers l'application mobile
if(preg_match('/iphone/i', $HTTP_USER_AGENT)==true OR preg_match('/android/i', $HTTP_USER_AGENT)==true OR preg_match('/blackberry/i', $HTTP_USER_AGENT)==true){
	header('Location: '.$mobile_url);
}


if(isset($autorisation) AND $autorisation=='identification'){

	if(strlen(trim($joueur_email))==0){
		$formulaire_erreur[] = 'joueur_email';
	}
	if(strlen(trim($equipe_motdepasse))==0){
		$formulaire_erreur[] = 'equipe_motdepasse';
	}

	if(count($formulaire_erreur)==0){

		// Vérification si le joueur existe
		$requete_verification_email = mysqli_query($connexion_mysql, 'SELECT joueur_id FROM joueurs WHERE joueur_email="'.$joueur_email.'"');
		$nb_verification_email = mysqli_num_rows($requete_verification_email);
		if($nb_verification_email==0){
			$formulaire_erreur[] = 'joueur_email_incorrect';
		}else{

			// Vérification si le joueur existe
			$requete_verification_joueur = mysqli_query($connexion_mysql, 'SELECT joueur_id, joueur_sexe, joueur_nom, joueur_prenom, joueur_profil, equipe_id, equipe_nom FROM (joueurs A INNER JOIN equipes_joueurs B ON A.joueur_id=B.ej_joueur) INNER JOIN equipes C ON B.ej_equipe=C.equipe_id WHERE C.competition_id="'.$_SESSION['SessionWeb_competition_id'].'" AND equipe_active="1" AND joueur_email="'.$joueur_email.'" AND joueur_profil IN ("pro", "am") AND equipe_motdepasse="'.md5($equipe_motdepasse).'"');
			$nb_verification_joueur = mysqli_num_rows($requete_verification_joueur);
			if($nb_verification_joueur==1){
				$resultat_joueur = mysqli_fetch_array($requete_verification_joueur);
				$joueur_id = $resultat_joueur[0];
				$joueur_sexe = $resultat_joueur[1];
				$joueur_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[2])));
				$joueur_prenom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[3])));
				$joueur_profil = $resultat_joueur[4];
				$equipe_id = $resultat_joueur[5];
				$equipe_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[6])));

				$_SESSION['SessionWeb_joueur_id'] = $joueur_id;
				$_SESSION['SessionWeb_joueur_sexe'] = $joueur_sexe;
				$_SESSION['SessionWeb_joueur_nom'] = $joueur_nom;
				$_SESSION['SessionWeb_joueur_prenom'] = $joueur_prenom;
				$_SESSION['SessionWeb_joueur_profil'] = $joueur_profil;
				$_SESSION['SessionWeb_equipe_id'] = $equipe_id;
				$_SESSION['SessionWeb_equipe_nom'] = $equipe_nom;

				// Redirection vers la page du compte du joueur
				header('Location: ./compte.php');
				exit;

			}else{
				$formulaire_erreur[] = 'equipe_motdepasse_incorrect';
			}
		}
	}
}


if(!isset($autorisation) OR (isset($autorisation) AND $autorisation!='identification')){

	// Valeurs par défaut lorsque le formulaire est vierge
	$joueur_email = '';
	$equipe_motdepasse = '';

}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="<?=$_SESSION['SessionWeb_langue']?>" xml:lang="<?=strtolower($_SESSION['SessionWeb_langue'])?>">
<head>
	<title><?=$txt_espace_equipe_titre?></title>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=8">
	<meta name="language" content="<?=strtolower($_SESSION['SessionWeb_langue'])?>">
	<meta name="robots" content="index, follow">
	<link rel="shortcut icon" type="image/x-icon" href="/favicon.ico">
	<link rel="shortcut icon" href="/favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$web_commun?>commun.css">
</head>

<body scroll="auto">

<div id="page" align="center">

	<div id="contenu">

		<?php $espace='equipe'; include './commun/entete.inc'; ?>

		<div id="formulaire">

			<form action="<?=$REQUEST_URI?>" method="post">

				<input type="hidden" name="autorisation" value="identification">

				<h1><?=$txt_espace_equipe_identification_titre?></h1>

				<div class="separateur"></div>

				<div class="colonne_gauche_obligatoire" style="width: 170px;"><?=$txt_espace_equipe_identification_email_joueur?> :</div>
				<div class="colonne_droite" style="width: 320px;"><input type="text" name="joueur_email" value="<?=$joueur_email?>" style="width: 300px;"></div>
				<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_email', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; }elseif(count($formulaire_erreur)!=0 AND in_array('joueur_email_incorrect', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_incorrect.'</div>'; } ?>
				<br clear="all">

				<div class="colonne_gauche_obligatoire" style="width: 170px;"><?=$txt_espace_equipe_identification_motdepasse?> :</div>
				<div class="colonne_droite" style="width: 170px;"><input type="password" name="equipe_motdepasse" style="width: 150px;"></div>
				<?php if(count($formulaire_erreur)!=0 AND in_array('equipe_motdepasse', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; }elseif(count($formulaire_erreur)!=0 AND in_array('equipe_motdepasse_incorrect', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_incorrect.'</div>'; } ?>
				<br clear="all">

				<div style="margin-left: 170px;"><a href="./motdepasse_oublie.php" style="font-size: 11px;"><?=$txt_espace_equipe_identification_motdepasse_oublie?></a></div>

				<div class="separateur"></div>

				<input type="submit" value="<?=$txt_bouton_entrer?>">

			</form>

		</div>

	</div>

</div>

</body>
</html>
