<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(1, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(1, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


if(isset($action) AND $action=='ajouter'){

	/******************************/
	/**  Traitement des erreurs  **/
	/******************************/
	if(strlen(trim($compte_nom_utilisateur))==0){
		$erreur_message .= "- le nom d'utilisateur est manquant<br>";
	}
	if(strlen(trim($compte_mot_passe))==0){
		$erreur_message .= "- le mot de passe est manquant<br>";
	}
	if(strlen(trim($compte_nom))==0){
		$erreur_message .= "- le nom est manquant<br>";
	}
	if(strlen(trim($compte_prenom))==0){
		$erreur_message .= "- le prénom est manquant<br>";
	}
	if(strlen(trim($compte_email))==0){
		$erreur_message .= "- l'adresse e-mail est manquante<br>";
	}

	/******************************/
	/**  Traitement des données  **/
	/******************************/
	$compte_nom = htmlentities(strtoupper_max($compte_nom), ENT_QUOTES);
	$compte_prenom = htmlentities(ucfirst($compte_prenom), ENT_QUOTES);
	$compte_email = strtolower($compte_email);

	/****************************************/
	/**  Enregistrement des modifications  **/
	/****************************************/
	if($erreur_message==''){

		$compte_id = uniqid('');

		$compte_mot_passe = md5($compte_mot_passe);

		// Requête d'insertion du compte
		$requete_insertion = mysqli_query($connexion_mysql, 'INSERT INTO admin_comptes (compte_id, compte_type, compte_nom_utilisateur, compte_mot_passe, compte_nom, compte_prenom, compte_email, compte_commentaire) VALUES("'.$compte_id.'", "'.$compte_type.'", "'.$compte_nom_utilisateur.'", "'.$compte_mot_passe.'", "'.$compte_nom.'", "'.$compte_prenom.'", "'.$compte_email.'", "'.$compte_commentaire.'")');

		header('Location: ./');
		exit;

	}else{
		$compte_nom_utilisateur = stripslashes($compte_nom_utilisateur);
		$compte_nom = stripslashes($compte_nom);
		$compte_prenom = stripslashes($compte_prenom);
		$compte_commentaire = stripslashes($compte_commentaire);
	}

}


if(isset($erreur_message) AND $erreur_message==''){

	// Initialisation des champs
	$compte_type = 'utilisateur';
	$compte_nom_utilisateur = '';
	$compte_mot_passe = '';
	$compte_nom = '';
	$compte_prenom = '';
	$compte_email = '';
	$compte_commentaire = '';

}else{

	// Si le formulaire comporte des erreurs, alors traitement des données
	$compte_nom_utilisateur = stripslashes($compte_nom_utilisateur);
	$compte_nom = stripslashes($compte_nom);
	$compte_prenom = stripslashes($compte_prenom);
	$compte_commentaire = stripslashes($compte_commentaire);

}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<script type="text/javascript" src="<?=$admin_js?>scriptaculous/prototype.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>scriptaculous/scriptaculous.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>scriptaculous/prototip.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<script type="text/javascript">
		jQuery.noConflict();
		document.observe('dom:loaded', function() {
			new Tip('colonne_drapeau', 'Formats acceptés : JPEG, GIF ou PNG<br>Poids maximum : 500 Ko<br>Largeur : 16 pixels<br>Hauteur : 11 pixels.', {
				className: 'infobulle_information', title: 'informations', effect: 'appear', hook: { target: 'bottomMiddle', tip: 'topLeft'}
			});
		});
	</script>
	<meta name="robots" content="none">
</head>

<body>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2">

	<div id="contenu_3" align="left" style="width: 450px;">

		<div id="titres">
			<span class="titre_1"><a href="./">Comptes</a> <span class="separateur">/</span> <span class="titre_2">Ajouter</span></span>
		</div>
		<br clear="all">

		<div id="bloc_bis">

			<?php if(isset($erreur_message) AND $erreur_message!=''){ ?>
				<div align="center"><div id="message_erreur" align="left"><b><?=$erreur_message_introduction.'</b><br>'.$erreur_message?></div></div>
			<?php } ?>

			<form name="ajouter" action="<?=$PHP_SELF?>" method="post" enctype="multipart/form-data">

				<input type="hidden" name="action" value="ajouter">

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Type</div>
					<div id="formulaire_champ">
						<input type="radio" id="compte_type_administrateur" name="compte_type" value="administrateur" <?php if($compte_type=='administrateur'){ echo 'checked'; } ?>> <label for="compte_type_administrateur">Administrateur</label>&nbsp;&nbsp;&nbsp; 
						<input type="radio" id="compte_type_utilisateur" name="compte_type" value="utilisateur" <?php if($compte_type=='utilisateur'){ echo 'checked'; } ?>> <label for="compte_type_utilisateur">Utilisateur</label>
					</div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Nom d'utilisateur</div>
					<div id="formulaire_champ"><input type="text" name="compte_nom_utilisateur" value="<?=$compte_nom_utilisateur?>" class="input" style="width: 270px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne" style="margin-bottom: 10px;">
					<div id="formulaire_libelle_obligatoire">Mot de passe</div>
					<div id="formulaire_champ"><input type="password" name="compte_mot_passe" value="<?=$compte_mot_passe?>" class="input" style="width: 100px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne_separateur"></div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Nom</div>
					<div id="formulaire_champ"><input type="text" name="compte_nom" value="<?=$compte_nom?>" class="input" style="width: 270px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Prénom</div>
					<div id="formulaire_champ"><input type="text" name="compte_prenom" value="<?=$compte_prenom?>" class="input" style="width: 270px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">E-mail</div>
					<div id="formulaire_champ"><input type="text" name="compte_email" value="<?=$compte_email?>" class="input" style="width: 270px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle">Commentaire</div>
					<div id="formulaire_champ"><textarea name="compte_commentaire" class="input" style="width: 270px; height: 52px; overflow: auto;"><?=$compte_commentaire?></textarea></div>
					<br clear="all">
				</div>

				<div id="formulaire_boutons"><input type="image" src="<?=$admin_img?>btn_enregistrer.png" width="150" height="32" align="absmiddle" style="margin: 15px 5px 20px 0px;"> ou&nbsp; <a href="./" class="lien_annuler">annuler</a></div>

			</form>

		</div>

	</div>
	<br clear="all">

</div></div>

<?php include $general_path_relatif.'sources/pied_page.inc'; ?>


<script language="Javascript">
	<!-- 
	document.ajouter.compte_nom_utilisateur.focus();
	//-->
</script>


</body>
</html>
