<?php 
include '../lib/configuration.inc';


// Si le nom du joueur pro n'est pas connu, alors retour à l'inscription
if(!isset($_SESSION['SessionWeb_joueur']['id'])){
	header('Location: ./inscription_1.php');
	exit;
}



/*******************/
/**  HEBERGEMENTS **/
/*******************/
$hebornot = $_GET['hebornot'] == 'yes' ? 1 : 0;
$vue_piscine = $_GET['vue_piscine'];
$chambre_double = $_GET['chambre_double'];
$nbre_places = $_SESSION['nbre_places'];
$tripstart = $_GET['trip-start'];
$tripdepart = $_GET['trip-departure'];
$date1 = strftime("%d/%m/%Y", strtotime($tripstart));
$date2 = strftime("%d/%m/%Y", strtotime($tripdepart));


/////////////////
// Données BDD //
/////////////////

// données hébergements
$requete_heb = mysqli_query($connexion_mysql, 'SELECT hotel, prix FROM hebergements WHERE id_hotel="'.$_GET['hotel_id'].'" AND chambre_double = "'.$chambre_double.'" AND vue_piscine = "'.$vue_piscine.'"');
$resultat_heb = mysqli_fetch_array($requete_heb);

$nom_hotel = $resultat_heb[0];
$prix_chambre_nuit = $resultat_heb[1];


// Données compétition
$requete_compet = mysqli_query($connexion_mysql, 'SELECT prix_forfait, single_no_pisc, single_pisc, double_no_pisc, double_pisc, no_heb_pro_no_hotel, no_heb_pro_hotel, competition_annee, DATE_FORMAT(competition_date_debut, "%d/%m/%Y"), DATE_FORMAT(competition_date_fin, "%d/%m/%Y"), date_debut_hotel, date_fin_hotel, DATE_FORMAT(date_debut_hotel_gratuit, "%d/%m/%Y"), DATE_FORMAT(date_fin_hotel_gratuit, "%d/%m/%Y"), acc_double_pisc, acc_single_pisc, acc_double_no_pisc, acc_single_no_pisc, acc_forfait FROM competitions WHERE competition_id = "'.$_SESSION['SessionWeb_competition_id'].'"');
$resultat_compet = mysqli_fetch_array($requete_compet);


// prix forfait
$prix_forfait = $resultat_compet[0];
$no_heb_pro_no_hotel = $resultat_compet[5];
$no_heb_pro_hotel = $resultat_compet[6];

// prix option supp : 
$prix_options = array(
	'single_no_pisc' => $resultat_compet[17],
	'single_pisc' => $resultat_compet[15],
	'double_no_pisc' => $resultat_compet[16],
	'double_pisc' => $resultat_compet[14]
);

// annee compet, date debut et fin
$competition_annee = $resultat_compet[7];
$competition_date_debut = $resultat_compet[8];
$competition_date_fin = $resultat_compet[9];

// dates liées à l'hébergement
$date_debut_hotel_gratuit = $resultat_compet[12];
$date_fin_hotel_gratuit = $resultat_compet[13];

// prix liés à l'accompagnateur
$acc_double_pisc = $resultat_compet[14];
$acc_single_pisc = $resultat_compet[15];
$acc_double_no_pisc = $resultat_compet[16];
$acc_single_no_pisc = $resultat_compet[17];
$acc_forfait = $resultat_compet[18];


/*******************************/
/**  TRAITEMENT DES DONNÉES **/
/*******************************/

// array FORFAIT
$forfait_arr = array(
	'desc' => 'forfait de base',
	'prix' => $acc_forfait,
	'type_libelle' => 'forfait'
);


// array OPTION SUPP
$option_supp = array(
	'desc' => '',
	'prix' => 0,
	'type_libelle' => 'option'
);


// Si il y a une option
if( ($vue_piscine or !$chambre_double) and $hebornot==1 ) {
	if(!$chambre_double and !$vue_piscine) { // dans l'admin "Option single no piscine"
		$option_supp['desc'] = 'Options: chambre simple';
		$option_supp['prix'] = $prix_options['single_no_pisc'];
	}
	if(!$chambre_double and $vue_piscine) { // si option = chambre simpl e + vue piscine
		$option_supp['desc'] = 'Options: chambre simple + vue piscine';
		$option_supp['prix'] = $prix_options['single_pisc'];
	}
	if($chambre_double and !$vue_piscine) { // si option = chambre simple + vue piscine
		$option_supp['desc'] = 'Options: aucune';
		$option_supp['prix'] = $prix_options['double_no_pisc'];
	}
	if($chambre_double and $vue_piscine) { // si option = chambre simple + vue piscine
		$option_supp['desc'] = 'Options: vue piscine';
		$option_supp['prix'] = $prix_options['double_pisc'];
	}
}



// array HEBERGEMENT GRATIS
$hebergement_gratis = array(
	'desc' => $heb_gratis_1.$nom_hotel.$heb_gratis_2.$date_debut_hotel_gratuit.$heb_gratis_3.$date_fin_hotel_gratuit.$heb_gratis_4,
	'prix' => 0
);

// array JOURS SUPP
$hebergement_jours_supp = array(
	'desc' => '',
	'prix' => 0,
	'type_libelle' => 'heb'
);


// nbre de jours total d'hebergements  souhaité (nber_nights)
$earlier = new DateTime($tripdepart);
$later = new DateTime($tripstart);
$nber_nights = $later->diff($earlier)->format("%a");
$nber_nights = intval($nber_nights);

// nbre jours gratuits
$date_debut_hotel_gratuit_format = DateTime::createFromFormat('d/m/Y', $date_debut_hotel_gratuit);
$date_fin_hotel_gratuit_format = DateTime::createFromFormat('d/m/Y', $date_fin_hotel_gratuit);
$nber_nights_gratis = $date_debut_hotel_gratuit_format->diff($date_fin_hotel_gratuit_format)->format("%a");
$nber_nights_gratis = intval($nber_nights_gratis);

// différence #jours_gratis / #total_de_jours
$diff_nb_nights = $nber_nights - $nber_nights_gratis;




// si nbre jours gratis < nbre jours ALORS on ajoute la différence !!
if($nber_nights_gratis < $nber_nights and $hebornot==1) {
	$hebergement_jours_supp['desc'] = strval($diff_nb_nights).' nuit(s) en plus (total: du '.$date1.' au '.$date2.')';
	$hebergement_jours_supp['prix'] = $diff_nb_nights * $prix_chambre_nuit;
}

// données pour l'enregistrement de la facture
$prix_forfait = $forfait_arr['prix'];
$prix_option = $option_supp['prix'];
$prix_heb = $prix_option + $hebergement_jours_supp['prix']; // dans le cas du pro: option_supp + hebergement_jours_supp

// type d'hébergement
$type_heb = 0;
if( (isset($_GET['hotel_id']) && $_GET['hotel_id'] == 'empty') ) {
	$type_heb = 0; // PAS d'hébergement
} else if ( isset($_SESSION['chambre_double']) && $chambre_double == 1 && (int)$diff_nb_nights == 0 ) {
	$type_heb = 1; // Hébergement standard, dates standard
} else {
	$type_heb = 2;	// autre
}

// prix total pour la facture
$facture_prix_total_ht = $prix_heb + $prix_forfait;
$facture_prix_total_tva = 0;
$facture_prix_total_ttc = $prix_heb + $prix_forfait + $facture_prix_total_tva;

// tableau contenant toutes les lignes du tableau de la facture (hors 'prix total')
$lignes_table = array(
	$forfait_arr,
	$hebergement_gratis,
	$option_supp,
	$hebergement_jours_supp
);
$lignes_facture = $lignes_table; // on a besoin d'un array pour les lignes du tableau et un pour les lignes de la facture



$facture_prix_accompagnateur_total_ht = $facture_prix_total_ht;
$facture_prix_accompagnateur_tva = $facture_prix_total_tva;
$facture_prix_accompagnateur_total_ttc = $facture_prix_total_ttc + $facture_prix_total_tva;


if(isset($autorisation) AND $autorisation=='facturation'){

	if(count($formulaire_erreur)==0){

		/*******************/
		/**  INSCRIPTION  **/
		/*******************/

		foreach($_SESSION['SessionWeb_joueurs_acc'] as $joueur_acc_cle=>$joueur_acc){


			$joueur_id = $_SESSION['SessionWeb_joueurs_acc'][$joueur_acc_cle]['id'] = uniqid();
			$ej_id = uniqid();


			// Création de l'accompagnateur en base de données 
			$requete_creation_joueur_acc = mysqli_query($connexion_mysql, 'INSERT INTO joueurs (joueur_id, competition_id, joueur_profil, joueur_sexe, joueur_nom, joueur_prenom, joueur_langue, joueur_datetime_creation) VALUES("'.$joueur_id.'", "'.$_SESSION['SessionWeb_competition_id'].'", "acc", "'.$joueur_acc['sexe'].'", "'.$joueur_acc['nom'].'", "'.$joueur_acc['prenom'].'", "'.$_SESSION['SessionWeb_langue'].'", "'.date('Y-m-d H:i:s').'")') or die(mysqli_error($connexion_mysql));

			// Ajout des joueurs amateurs dans l'équipe en base de données
			$requete_equipe_joueur_acc = mysqli_query($connexion_mysql, 'INSERT INTO equipes_joueurs (ej_id, ej_equipe, ej_joueur, ej_joueur_accompagnant) VALUES("'.$ej_id.'", "'.$equipe_id.'", "'.$joueur_id.'", "'.$_SESSION['SessionWeb_joueur']['id'].'")') or die(mysqli_error($connexion_mysql));

		}

		/*****************************************/
		/**  ENVOI DE L'E-MAIL DE CONFIRMATION  **/
		/*****************************************/

		// Récupération des infos sur la compétition
		$requete_competition = mysqli_query($connexion_mysql, 'SELECT competition_annee, DATE_FORMAT(competition_date_debut, "%d/%m/%Y"), DATE_FORMAT(competition_date_fin, "%d/%m/%Y") FROM competitions WHERE competition_id="'.$_SESSION['SessionWeb_competition_id'].'"');
		$resultat_competition = mysqli_fetch_array($requete_competition);
		$competition_annee = $resultat_competition[0];
		$competition_date_debut = $resultat_competition[1];
		$competition_date_fin = $resultat_competition[2];

		// Récupération des infos sur le joueur accompagnant
		$requete_joueur_accompagnant = mysqli_query($connexion_mysql, 'SELECT joueur_sexe, joueur_nom, joueur_prenom, joueur_email FROM joueurs WHERE joueur_id="'.$_SESSION['SessionWeb_joueur']['id'].'"');
		$resultat_joueur_accompagnant = mysqli_fetch_array($requete_joueur_accompagnant);
		$joueur_sexe = $resultat_joueur_accompagnant[0];
		$joueur_nom = $resultat_joueur_accompagnant[1];
		$joueur_prenom = $resultat_joueur_accompagnant[2];
		$joueur_email = $resultat_joueur_accompagnant[3];


		// Construction de l'e-mail de confirmation d'inscription
		$emailing_sujet = "Duos du golf Majorque ".$competition_annee.' - '.$txt_acc_etape6_email_sujet;
		$emailing_titre = $txt_acc_etape6_email_titre;

		if($joueur_sexe=='H'){ $txt_acc_etape6_email_1_message_civilite = $txt_monsieur; }else{ $txt_acc_etape6_email_1_message_civilite = $txt_madame; }

		$emailing_joueur_message  = $txt_acc_etape6_email_1_message_1." ".$txt_acc_etape6_email_1_message_civilite." ".$joueur_nom.",<br><br>\n";
		$emailing_joueur_message .= "<b>".$_SESSION['SessionWeb_joueurs_acc'][0]['prenom']." ".$_SESSION['SessionWeb_joueurs_acc'][0]['nom']."</b> ".$txt_acc_etape6_email_1_message_2." ".$competition_date_debut." ".$txt_acc_etape6_email_1_message_3." ".$competition_date_fin.".<br><br>\n";
		$emailing_joueur_message .= $txt_acc_etape6_email_1_message_4;

		// Envoi de l'e-mail de confirmation d'inscription à l'accompagnateur principal
		//emailing_envoi($web_email_alerte, $joueur_email, '', '', $emailing_sujet, $emailing_titre, $emailing_joueur_message, $web_url.'/emailing.htm', $web_url, $_SESSION['SessionWeb_langue']);

		/********************/
		/**  EMAIL ALERTE  **/
		/********************/

		$alerte_titre  = 'NOUVEAUX INSCRITS AUX DUOS DU GOLF MAJORQUE '.$competition_annee.'<br><br>';
		$alerte_titre .= 'PACKAGE ACCOMPAGNATEUR';

		$alerte_message .= '<br><b><u>JOUEUR</u> :</b><br><br>';
		if($_SESSION['SessionWeb_joueur_pro']['sexe']=='H'){ $professionnel_civilite = 'M.'; }else{ $professionnel_civilite = 'Mme'; }
		$alerte_message .= $professionnel_civilite.' '.$_SESSION['SessionWeb_joueur_pro']['nom'].' '.$_SESSION['SessionWeb_joueur_pro']['prenom'].'<br><br>';

		if(isset($_SESSION['SessionWeb_joueurs_acc']) AND count($_SESSION['SessionWeb_joueurs_acc']!=0)){
			$alerte_message = '<br><b><u>ACCOMPAGNATEUR(S)</u> :</b><br><br>';
			foreach($_SESSION['SessionWeb_joueurs_acc'] as $joueur_acc_cle=>$joueur_acc){
				if($joueur_acc['sexe']=='H'){ $accompagnateur_civilite = 'M.'; }else{ $accompagnateur_civilite = 'Mme'; }
				$alerte_message .= $accompagnateur_civilite.' '.$joueur_acc['nom'].' '.$joueur_acc['prenom'].'<br><br>';
			}
		}

		if(strlen(trim($facture_message_joueur))!=0) {
			$facture_message_bis = preg_replace('/\n/', '<br>', $facture_message);
			$alerte_message .= '<br><hr><br><br>';
			$alerte_message .= '<b><u>MESSAGE POUR L\'INSCRIPTION / FACTURATION</u> :</b><br><br>';
			$alerte_message .= stripslashes($facture_message_bis).'<br><br>';
		}

		$from_email = "proam@golf-first.fr";

		$web_email_alerte = array("proam@golf-first.fr");
		$emailing_destinataires_cc_email = '';
		//$emailing_destinataires_cc_email = "laetitia@makilas-golftour.com;makilasgolf@gmail.com";

		// Envoi de l'e-mail d'alerte
		emailing_envoi($from_email, $web_email_alerte, $emailing_destinataires_cc_email, '', "[ alerte ] Nouveaux inscrits aux duos du Golf Majorque ".$competition_annee, $alerte_titre, $alerte_message, $web_url.'/emailing_alerte.htm', $web_url, $_SESSION['SessionWeb_langue']);


		/****************************************/
		/**  ENREGISTREMENT DE LA FACTURATION  **/
		/****************************************/

		$facture_id = uniqid();
		$facture_message = htmlentities(ucfirst(stripslashes($facture_message)), ENT_QUOTES);

		// Création du numéro de facture
		$requete_facture_numero_max = mysqli_query($connexion_mysql, 'SELECT MAX(facture_numero) FROM factures');
		$resultat_facture_numero_max = mysqli_fetch_array($requete_facture_numero_max);
		$facture_numero = $resultat_facture_numero_max[0] + 1;

		// Libellé et calculs pour la facture
		$facture_libelle_accompagnateurs = $txt_acc_etape6_libelle_facture_1." ".$competition_date_debut." ".$txt_acc_etape6_libelle_facture_2." ".$competition_date_fin."\n".$txt_acc_etape6_libelle_facture_3." ".count($_SESSION['SessionWeb_joueurs_acc']);
		foreach($_SESSION['SessionWeb_joueurs_acc'] as $joueur_acc){
			$facture_libelle_accompagnateurs .= "\n".$joueur_acc['nom']." ".$joueur_acc['prenom'];
		}




		foreach ($lignes_facture as $key => $value) {

			if(!empty($value['desc'])) {

				// Création des libellés de la facture en base de données
				$requete_creation_libelle = mysqli_query($connexion_mysql, 'INSERT INTO factures_libelles (facture_id, facture_libelle_description, facture_libelle_prix_unitaire_ht, facture_libelle_quantite, facture_libelle_prix_total_ht, type_libelle) VALUES("'.$facture_id.'", "'.$value['desc'].'", "'.$value['prix'].'", "1", "'.$value['prix'].'", "'.$value['type_libelle'].'")') or die(mysqli_error($connexion_mysql)) or die(mysqli_error($connexion_mysql));
			}
		}


		$facture_message_joueur = '';
		$facture_message_heures = '';

		$facture_prix_golfeur_ht = number_format($facture_prix_golfeur_ht, 2, ".", "");

		$joueur_package = 'accompagnateur';

		$requete_creation_facture = mysqli_query($connexion_mysql, 'INSERT INTO factures (facture_id, joueur_id, facture_numero, facture_package, facture_prix_ht, facture_prix_tva, facture_prix_ttc, facture_message_joueur, facture_date, facture_message_heures) VALUES("'.$facture_id.'", "'.$_SESSION['SessionWeb_joueurs_acc'][0]['id'].'", "'.$facture_numero.'", "'.$joueur_package.'", "'.$facture_prix_accompagnateur_total_ht.'", "'.$facture_prix_accompagnateur_tva.'", "'.$facture_prix_accompagnateur_total_ttc.'", "'.$facture_message_joueur.'", "'.date('Y-m-d').'", "'.$facture_message_heures.'")') or die(mysqli_error($connexion_mysql));




		/********************************************/
		/**  SUPPRESSION DES VARIABLES DE SESSION  **/
		/********************************************/

		// Suppression des variables de session de l'inscription du joueur pro
		//unset($_SESSION['SessionWeb_joueur_profil'], $_SESSION['SessionWeb_joueur'], $_SESSION['SessionWeb_joueurs_acc']);


		//header('Location: ./inscription_7.php');	// Redirection vers la page de confirmation
		//exit;

	} else {
		// Traitement d'affichage en cas d'erreur dans le formulaire
		$facture_message = stripslashes($facture_message);
	}
}


if(!isset($autorisation) OR (isset($autorisation) AND $autorisation!='facturation')){
	// Valeurs par défaut lorsque le formulaire est vierge
	$facture_message = '';
}


// Récupération des packages sur l'équipe
$tableau_equipe_packages = array();
$requete_equipe_joueurs = mysqli_query($connexion_mysql, 'SELECT DISTINCT(facture_package) FROM equipes_joueurs A LEFT JOIN factures B ON A.ej_joueur=B.joueur_id WHERE ej_equipe="'.$equipe_id.'"');
$nb_equipe_joueurs = mysqli_num_rows($requete_equipe_joueurs);
if($nb_equipe_joueurs!=0) {
	for($equipe_joueurs_boucle=0; $equipe_joueurs_boucle<$nb_equipe_joueurs; $equipe_joueurs_boucle++){
		$resultat_equipe_joueurs = mysqli_fetch_array($requete_equipe_joueurs);
		array_push($tableau_equipe_packages, $resultat_equipe_joueurs[0]);
	}
}

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="<?=$_SESSION['SessionWeb_langue']?>" xml:lang="<?=strtolower($_SESSION['SessionWeb_langue'])?>">
<head>
	<title><?=$txt_page_titre?></title>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=8">
	<meta name="language" content="<?=strtolower($_SESSION['SessionWeb_langue'])?>">
	<meta name="robots" content="index, follow">
	<link rel="shortcut icon" type="image/x-icon" href="/favicon.ico">
	<link rel="shortcut icon" href="/favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$web_commun?>commun.css">
</head>

<body scroll="auto">

<div id="page" align="center">

	<div id="contenu">

		<?php include './commun/entete.inc'; ?>

		<div id="formulaire">

			<form action="<?=$REQUEST_URI?>" method="post">

				<input type="hidden" name="autorisation" value="facturation">

				<h1><?=$txt_acc_etape6_titre?></h1>

				<div class="separateur"></div>

				<div id="package_facture">

					<b><u><?=$txt_acc_etape6_soustitre_recapitulatif?></u></b><br><br>

					<table width="660" border="0" cellapdding="0" cellspacing="0">
						<tr>
							<td style="width: 280px;" class="entete_colonne"><?=$txt_acc_etape6_colonne_description?></td>
							<td style="width: 150px;" class="entete_colonne"><?=$txt_acc_etape6_colonne_prix_unitaire_ht?></td>
							<td style="width: 80px;" class="entete_colonne"><?=$txt_acc_etape6_colonne_quantite?></td>
							<td style="width: 150px;" class="entete_colonne"><?=$txt_acc_etape6_colonne_prix_total_ht?></td>
						</tr>


						<?php
						 	foreach ($lignes_table as $key => $value) {
						 		if($value['desc'] != '' && $key!=0 ) { ?>
									<tr style="height: 30px;">
										<td <?php if($key==0){ echo "class='change_js_bis'"; } ?> ><?php echo $value['desc']; ?></td>
										<td align="right" class="change_js_"><?php echo number_format($value['prix'], 2); ?> &euro;&nbsp;&nbsp;&nbsp;</td>
										<td align="right"><?php echo number_format(0, 2); ?> &euro;&nbsp;&nbsp;&nbsp;</td>
										<td align="right" class="change_js_"><?php echo number_format($value['prix'], 2); ?> &euro;&nbsp;&nbsp;&nbsp;</td>
									</tr>

						 		<?php } 
						 	}
						?>
						<tr>
							<td class="ligne_vide">&nbsp;</td>
							<td colspan="2" class="entete_ligne"><?=$txt_acc_etape6_colonne_sous_total_ht?>&nbsp;&nbsp;&nbsp;</td>
							<td align="right"><?=number_format($facture_prix_ht_accompagnateurs, 2, ',', ' ').' &euro;&nbsp;&nbsp;&nbsp;'?></td>
						</tr>
						<tr>
							<td class="ligne_vide">&nbsp;</td>
							<td colspan="2" class="entete_ligne"><?=$txt_acc_etape6_colonne_tva?> (<?=number_format($facture_tva, 0, ',', ' ')?>%)&nbsp;&nbsp;&nbsp;</td>
							<td align="right"><?=number_format($facture_prix_tva, 2, ',', ' ').' &euro;&nbsp;&nbsp;&nbsp;'?></td>
						</tr>
						<tr>
							<td class="ligne_vide">&nbsp;</td>
							<td colspan="2" class="entete_ligne"><?=$txt_acc_etape6_colonne_total_ttc?>&nbsp;&nbsp;&nbsp;</td>
							<td align="right" style="background-color: #EFEFEF; font-weight: bold;"><?=number_format($facture_prix_total_ttc, 2, ',', ' ').' &euro;&nbsp;&nbsp;&nbsp;'?></td>
						</tr>
					</table>
					<br>

				</div>




				<br clear="all">
				<div class="separateur_ter"></div>
				
				<?=$txt_facture_message_heures?><br>
				<textarea name="facture_message_heures" style="width: 645px; height: 100px; margin-top: 5px; resize: vertical;"><?=$facture_message_heures?></textarea>




				<div class="separateur_ter"></div>

				<?=$txt_acc_etape6_laisser_message_facturation?><br>
				<textarea name="facture_message" style="width: 645px; height: 100px; margin-top: 5px;"><?=$facture_message?></textarea>

				<div style="float: left; width: 120px; margin: 40px 0px 20px 0px;"><input type="button" value="<?=$txt_bouton_retour?>" onclick="window.location='./inscription_hebergement.php';" class="bouton_annuler"></div>
				<div align="right" style="margin: 40px 71px 20px 0px;"><input type="submit" value="<?=$txt_bouton_je_valide_inscription?>"></div><br clear="all">

			</form>

			<div class="separateur_ter"></div>

			<div id="texte">

				<?php if(in_array('entreprise', $tableau_equipe_packages)==true){ ?>

					<h2><?=$txt_package_entreprise_nom?></h2><br>

					<?=$txt_package_entreprise_texte?>

				<?php }else{ ?>


					<div id="texte">


						<?php if(isset($_GET['langue']) && $_GET['langue'] == 'en') { ?>


							<?=$text_acc_final_FR;?>



						<?php } else { ?>



							<?=$text_acc_final_FR;?>


						<?php } ?>


						<div class="separateur_ter"></div>

					</div>

					
				<?php } ?>


			</div>

		</div>

	</div>

</div>

</body>
</html>
