<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(6, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(4, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


if(isset($action) AND $action=='rechercher'){

	$requete_where = 'WHERE equipe_id<>""';
	$export_parametres = '';

	if(strlen(trim($recherche_motcle))!=0){
		$requete_where .= ' AND (equipe_id LIKE "%'.$recherche_motcle.'%" OR equipe_nom LIKE "%'.$recherche_motcle.'%")';
		$export_parametres .= 'export_equipe_motcle='.$recherche_motcle.'&';
	}

	if($recherche_equipe!='0'){
		$requete_where .= ' AND equipe_id="'.$recherche_equipe.'"';
		$export_parametres .= 'export_equipe='.$recherche_equipe.'&';
	}

	$export_parametres .= 'export_joueurs='.$recherche_joueurs.'&';

	if($classement=='nom'){
		$requete_orderby = 'equipe_nom '.$ordre;
	}elseif($classement=='statut'){
		$requete_orderby = 'equipe_active '.$ordre.', equipe_nom';
	}
	$export_parametres .= 'classement='.$classement.'&ordre='.$ordre.'&';

	if(strlen(trim($export_parametres))!=0){
		$export_parametres = '?'.substr($export_parametres, 0, -1);
	}

}else{

	$requete_where = '';
	$requete_orderby = 'equipe_nom';

	$export_parametres = '';

	$recherche_joueurs = 1;

}


// Sélection des équipes enregistrées
$requete_equipes = mysqli_query($connexion_mysql, 'SELECT equipe_id, equipe_nom, equipe_active FROM equipes '.$requete_where.' ORDER BY '.$requete_orderby);
$nb_equipes = mysqli_num_rows($requete_equipes);
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none">
	<script language="Javascript">
		<!-- 
		function supprimer(identifiant, nom, joueur_pro){
			if(joueur_pro == 1){
				resultat = confirm("Désirez-vous réellement supprimer l'équipe ' " + nom + " ' ?\n\nAttention : le joueur professionnel sera également supprimé de la base de données.");
			}else{
				resultat = confirm("Désirez-vous réellement supprimer l'équipe ' " + nom + " ' ?");
			}
			if(resultat == true){
				window.location = './supprimer.php?equipe_id=' + identifiant;
			}
		}
		//-->
	</script>
</head>

<body>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2" style="width: 1130px;">

	<div id="contenu_3" align="left" style="width: 485px;">

		<div id="titres">
			<span class="titre_1" style="width: 210px;">Équipes</span>
			<?php if($nb_equipes!=0){ ?>
				<span class="ajouter" style="width: 140px; margin-right: 30px;"><a href="./exporter_liste_joueurs.php" target="_blank">Liste des joueurs</a></span>
				<span class="ajouter" style="width: 80px;"><a href="./exporter.php<?=$export_parametres?>">Exporter</a></span>
			<?php } ?>
		</div>
		<br clear="all">

		<?php 
		if($nb_equipes==1){
			echo '<div id="ligne_compteur"><b>1</b> équipe sélectionnée</div>';
		}elseif($nb_equipes>1){
			echo '<div id="ligne_compteur"><b>'.$nb_equipes.'</b> équipes sélectionnées</div>';
		}
		?>

		<div id="bloc">

			<?php if($nb_equipes!=0){ ?>

				<div id="ligne_entete">
					<div style="float: left; width: 200px;" title="Nom de l'équipe">NOM ÉQUIPE</div>
					<div align="center" style="float: left; width: 70px; border-left: 1px solid #CCCCCC;" title="Nombre de joueurs professionnels">NB PROs</div>
					<div align="center" style="float: left; width: 70px; border-left: 1px solid #CCCCCC;" title="Nombre de joueurs amateurs">NB AMs</div>
					<div align="center" style="float: left; width: 70px; margin-right: 5px; border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC;" title="Nombre de accompagnateurs">NB ACCs</div>
				</div>

			<?php 
				for($equipe_boucle=0; $equipe_boucle<$nb_equipes; $equipe_boucle++){
					$resultat_equipe = mysqli_fetch_array($requete_equipes);
					$equipe_id = $resultat_equipe[0];
					$equipe_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_equipe[1])));
					$equipe_active = $resultat_equipe[2];

					if($equipe_active==1){ $equipe_ligne_css = 'ligne'; }else{ $equipe_ligne_css = 'ligne_inactive'; }

					// Sélection des joueurs professionnels de l'équipe sélectionnée
					$requete_joueurs_pro = mysqli_query($connexion_mysql, 'SELECT ej_id FROM equipes_joueurs A INNER JOIN joueurs B ON A.ej_joueur=B.joueur_id WHERE ej_equipe="'.$equipe_id.'" AND joueur_profil="pro"');
					$nb_joueurs_pro = mysqli_num_rows($requete_joueurs_pro);

					// Sélection des joueurs amateurs de l'équipe sélectionnée
					$requete_joueurs_am = mysqli_query($connexion_mysql, 'SELECT ej_id FROM equipes_joueurs A INNER JOIN joueurs B ON A.ej_joueur=B.joueur_id WHERE ej_equipe="'.$equipe_id.'" AND joueur_profil="am"');
					$nb_joueurs_am = mysqli_num_rows($requete_joueurs_am);

					// Sélection des accompagnateurs de l'équipe sélectionnée
					$requete_joueurs_acc = mysqli_query($connexion_mysql, 'SELECT ej_id FROM equipes_joueurs A INNER JOIN joueurs B ON A.ej_joueur=B.joueur_id WHERE ej_equipe="'.$equipe_id.'" AND joueur_profil="acc"');
					$nb_joueurs_acc = mysqli_num_rows($requete_joueurs_acc);

					$nb_professionnels_fond = $nb_amateurs_fond = '';
					if($nb_joueurs_pro<1){ $nb_professionnels_fond = ' background-color: #FFFF00;'; }
					if($nb_joueurs_am<3){ $nb_amateurs_fond = ' background-color: #FFFF00;'; }
					
			?>

					<div id="<?=$equipe_ligne_css?>">
						<div style="float: left; width: 200px;height: 100%;" title="Nom de l'équipe"><a href="./modifier.php?equipe_id=<?=$equipe_id?>"><?=$equipe_nom?></a></div>
						<div align="right" style="float: left; width: 60px; height: 100%; padding-right: 10px; border-left: 1px solid #CCCCCC;<?=$nb_professionnels_fond?>" title="Nombre de joueurs professionnels"><a href="./modifier.php?joueur_id=<?=$joueur_id?>"><?=$nb_joueurs_pro?></a>&nbsp; pro</div>
						<div align="right" style="float: left; width: 60px; padding-right: 10px; border-left: 1px solid #CCCCCC;<?=$nb_amateurs_fond?>" title="Nombre de joueurs amateurs"><a href="./modifier.php?joueur_id=<?=$joueur_id?>"><?=$nb_joueurs_am?></a>&nbsp; am</div>
						<div align="right" style="float: left; width: 60px; padding-right: 10px; margin-right: 5px; border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC;" title="Nombre de accompagnateurs"><a href="./modifier.php?joueur_id=<?=$joueur_id?>"><?=$nb_joueurs_acc?></a>&nbsp; acc</div>
						<div id="ligne_icone"><a href="./modifier.php?equipe_id=<?=$equipe_id?>" title="Modifier"><img src="<?=$admin_img?>picto_modifier.png" width="10" height="10"></a></div>
						<?php if(($nb_joueurs_am+$nb_joueurs_acc)==0 AND $nb_joueurs_pro==0){ ?>
							<div id="ligne_icone"><a href="Javascript:void(0);" onclick="supprimer('<?=$equipe_id?>', '<?=$equipe_nom?>')" title="Supprimer"><img src="<?=$admin_img?>picto_supprimer.png" width="10" height="10"></a></div>
						<?php }elseif(($nb_joueurs_am+$nb_joueurs_acc)==0 AND $nb_joueurs_pro!=0){ ?>
							<div id="ligne_icone"><a href="Javascript:void(0);" onclick="supprimer('<?=$equipe_id?>', '<?=$equipe_nom?>', 1)" title="Supprimer"><img src="<?=$admin_img?>picto_supprimer.png" width="10" height="10"></a></div>
						<?php }else{ ?>
							<div id="ligne_icone"><img src="<?=$admin_img?>picto_supprimer_off.png" width="10" height="10" title="Pour supprimer cette équipe, veuillez avant enlever tous les joueurs qui la composent."></div>
						<?php } ?>
					</div>

					<?php 
					if($recherche_joueurs==1){

						// Sélection des joueurs de l'équipe sélectionnée
						$requete_joueurs = mysqli_query($connexion_mysql, 'SELECT joueur_id, joueur_nom, joueur_prenom, joueur_profil FROM joueurs A INNER JOIN equipes_joueurs B ON A.joueur_id=B.ej_joueur WHERE ej_equipe="'.$equipe_id.'" ORDER BY joueur_profil DESC, joueur_nom, joueur_prenom');
						$nb_joueurs = mysqli_num_rows($requete_joueurs);
						if($nb_joueurs!=0){

							for($joueur_boucle=0; $joueur_boucle<$nb_joueurs; $joueur_boucle++){
								$resultat_joueur = mysqli_fetch_array($requete_joueurs);
								$joueur_id = $resultat_joueur[0];
								$joueur_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[1])));
								$joueur_prenom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[2])));
								$joueur_profil = $resultat_joueur[3];

								if($joueur_profil=='pro'){ $joueur_profil = 'Professionnel'; }elseif($joueur_profil=='am'){ $joueur_profil = 'Amateur'; }else{ $joueur_profil = 'Accompagnateur'; }
					?>

								<div id="<?=$equipe_ligne_css?>" style="background-color: #F6F6F2;">
									<div style="float: left; width: 241px; margin-left: 30px;" title="Nom & prénom du joueur"><a href="../joueurs/modifier.php?joueur_id=<?=$joueur_id?>" style="font-size: 11px;"><?=$joueur_nom.' '.$joueur_prenom?></a></div>
									<div style="float: left; width: 100px; padding-left: 10px; border-left: 1px solid #CCCCCC;" title="Profil du joueur"><a href="./modifier.php?joueur_id=<?=$joueur_id?>" style="font-size: 11px;"><?=$joueur_profil?></a></div>
								</div>

			<?php 
							}
						}
					}
				}
			}else{
				if(isset($action) AND $action=='rechercher'){
					echo '<div id="ligne">aucune équipe correspond à votre recherche</div>'."\n";
				}else{
					echo '<div id="ligne">aucune équipe enregistrée</div>'."\n";
				}
			}
			?>

		</div>

	</div>

	<div id="contenu_secondaire">

		<form action="<?=$PHP_SELF?>" method="post">

			<input type="hidden" name="action" value="rechercher">

			<div class="titre">rechercher</div>

			<input type="text" name="recherche_motcle" value="<?php if(isset($recherche_motcle)){ echo $recherche_motcle; } ?>" class="input" style="width: 156px;"><br>

			<div class="titre">sélectionner une équipe</div>

			<select name="recherche_equipe" size="1" class="select" style="width: 170px;">
				<option value="0">-</option>
				<?php 
				// Sélection des équipes enregistrées
				$requete_recherche_equipes = mysqli_query($connexion_mysql, 'SELECT equipe_id, equipe_nom FROM equipes ORDER BY equipe_nom');
				$nb_recherche_equipes = mysqli_num_rows($requete_recherche_equipes);
				if($nb_recherche_equipes!=0){
					for($equipe_recherche_boucle=0; $equipe_recherche_boucle<$nb_recherche_equipes; $equipe_recherche_boucle++){
						$resultat_recherche_equipe = mysqli_fetch_array($requete_recherche_equipes);
						$recherche_equipe_id = $resultat_recherche_equipe[0];
						$recherche_equipe_nom = $resultat_recherche_equipe[1];

						if($recherche_equipe_id==$recherche_equipe){ $recherche_equipe_selection = ' selected'; }else{ $recherche_equipe_selection = ''; }

						echo '<option value="'.$recherche_equipe_id.'"'.$recherche_equipe_selection.'>'.$recherche_equipe_nom.'</option>'."\n";
					}
				}
				?>
			</select>

			<div class="titre">afficher les joueurs</div>

			<input type="radio" id="recherche_joueurs_oui" name="recherche_joueurs" value="1" <?php if((isset($recherche_joueurs) AND $recherche_joueurs==1) OR !isset($recherche_joueurs)){ echo 'checked'; } ?>> <label for="recherche_joueurs_oui">oui</label>&nbsp;&nbsp;&nbsp;&nbsp; 
			<input type="radio" id="recherche_joueurs_non" name="recherche_joueurs" value="0" <?php if(isset($recherche_joueurs) AND $recherche_joueurs==0){ echo 'checked'; } ?>> <label for="recherche_joueurs_non">non</label><br>

			<div class="titre">classer les résultats</div>

			<input type="radio" id="classement_nom" name="classement" value="nom" <?php if((isset($classement) AND $classement=='nom') OR !isset($classement)){ echo 'checked'; } ?>> <label for="classement_nom">par nom</label><br>
			<img src="<?=$admin_img?>p.gif" width="1" height="3"><br>
			<input type="radio" id="classement_statut" name="classement" value="statut" <?php if(isset($classement) AND $classement=='statut'){ echo 'checked'; } ?>> <label for="classement_statut">par statut (actif ou inactif)</label><br>

			<img src="<?=$admin_img?>p.gif" width="100%" height="1" style="background-color: #807D73; margin: 10px 0px 10px 0px;"><br>

			<input type="radio" id="classement_ordre_croissant" name="ordre" value="ASC" <?php if((isset($ordre) AND $ordre=='ASC') OR !isset($ordre)){ echo 'checked'; } ?>> <label for="classement_ordre_croissant">ordre croissant</label><br>
			<img src="<?=$admin_img?>p.gif" width="1" height="3"><br>
			<input type="radio" id="classement_ordre_decroissant" name="ordre" value="DESC" <?php if(isset($ordre) AND $ordre=='DESC'){ echo 'checked'; } ?>> <label for="classement_ordre_decroissant">ordre décroissant</label><br>

			<img src="<?=$admin_img?>p.gif" width="100%" height="1" style="background-color: #807D73; margin: 10px 0px 20px 0px;"><br>

			<center><input type="submit" value="valider" style="width: 100px;"></center>

		</form>

	</div>
	<br clear="all">

</div></div>


<?php include $general_path_relatif.'sources/pied_page.inc'; ?>

</body>
</html>
